/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef COMPOE_NONSTAT_H
#define COMPOE_NONSTAT_H

#include<functionprofit.h>
#include<matrixMTL.h>
#include<tridiagmatrix.h>
#include<vectorMTL.h>
#include<setup.h>
#include<tridiagmatrix3d.h>
#include<sparsematrixMTL3d.h>
#include<compoe.h>
#include<matrix3d.h>
#include<rangenlib.h>
//#include <sys/param.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include<stack>

using namespace MTL;

using namespace std;

typedef struct {
  VectorMTL<double> *state;
  MatrixMTL<double> *iota;
  MatrixMTL<double> *rho;
  VectorMTL<double> *D0;
} stackItem;


/**
	@author Przemyslaw Jeziorski <przemekj@stanford.edu>
*/
class CompOE_nonstat : public CompOE{
private:
  int Tbar;
  int xmax_subtract;

  stack <stackItem *> *stackResolving;

  VectorMTL<double> *s0;

  MatrixMTL<double> *rhoMatrix_global;
  MatrixMTL<double> *iotaMatrix_global;
  MatrixMTL<double> *profitMatrix_global;
  VectorMTL<double> *lambdaVector_global; 
  MatrixMTL<double> *V_global;
  MatrixMTL<double> *s_global;
  MatrixMTL<double> *p_global;
  VectorMTL<double> *bound1avg_nonstat, *bound1pre_nonstat, *bound1var_nonstat, *bound1por_nonstat;
  VectorMTL<double> *bound2avg_nonstat, *bound2pre_nonstat, *bound2var_nonstat, *bound2por_nonstat;
  VectorMTL<double> *bound3avg_nonstat, *bound3pre_nonstat, *bound3var_nonstat, *bound3por_nonstat;

  double prodsurOut_nonstat,prodsurpre_nonstat,prodsurvar_nonstat;
  double conssurOut_nonstat,conssurpre_nonstat,conssurvar_nonstat;
  double totalsurOut_nonstat,totalsurpre_nonstat,totalsurvar_nonstat;
  double invOut_nonstat,invpre_nonstat,invvar_nonstat;

  double *nonstatparams;

  MatrixMTL<double> *shockTran;
  int shockn;

  VectorMTL<double> *backup;
  MatrixMTL<double> *ED;
public:
  CompOE_nonstat();

  inline void initialize(double *control_init, double *prof_fun_init, double *prof_fun_ipopt_init,
    double *transition_init, double *constants_init, double *init_init, 
    double *convtol_init, double *nonstatparams_init, MatrixMTL<double> *shockTranInit) {

    control = control_init;
    prof_fun = prof_fun_init;
    prof_fun_ipopt = prof_fun_ipopt_init;
    transition = transition_init;
    constants = constants_init;
    init = init_init;
    convtol = convtol_init;
    nonstatparams = nonstatparams_init;
    shockTran = shockTranInit;
    // Set low sell-off value of constant number of firms
    if(control[2] != 0)
      transition[0] = 1e-100;
  }

  inline void setOutput(ofstream *myfileInit) {
    myfile = myfileInit;
  }

  inline double getCondNumber() {
    return condNumber;
  }

  inline VectorMTL<double> *getLambdaVector() {
    return lambdaVector_global;
  }

  inline MatrixMTL<double> *getRhoMatrix() {
    return rhoMatrix_global;
  }

  inline MatrixMTL<double> *getIotaMatrix() {
    return iotaMatrix_global;
  }

  inline MatrixMTL<double> *getVMatrix() {
    return V_global;
  }

  inline MatrixMTL<double> *getsMatrix() {
    return s_global;
  }

  inline MatrixMTL<double> *getpMatrix() {
    return p_global;
  }

  inline MatrixMTL<double> *getProfitMatrix() {
    return profitMatrix_global;
  }

  inline void getStats_nonstat(VectorMTL<double> &csOut, VectorMTL<double> &psOut, 
      VectorMTL<double> &tsOut, VectorMTL<double> &invOut) {
    psOut[0]=prodsurOut_nonstat;
    psOut[1]=prodsurpre_nonstat;
    psOut[2]=prodsurvar_nonstat;
    csOut[0]=conssurOut_nonstat;
    csOut[1]=conssurpre_nonstat;
    csOut[2]=conssurvar_nonstat;
    tsOut[0]=totalsurOut_nonstat;
    tsOut[1]=totalsurpre_nonstat;
    tsOut[2]=totalsurvar_nonstat;
    invOut[0]=invOut_nonstat;
    invOut[1]=invpre_nonstat;
    invOut[2]=invvar_nonstat;
  }

  inline void getBound1_nonstat(VectorMTL<double> &bound1avgOut, VectorMTL<double> &bound1preOut, 
    VectorMTL<double> &bound1varOut) {

    bound1avgOut = *bound1avg_nonstat;
    bound1varOut = *bound1var_nonstat;
    bound1preOut = *bound1pre_nonstat;
  }

  inline void getBound2_nonstat(VectorMTL<double> &bound2avgOut, VectorMTL<double> &bound2preOut, 
    VectorMTL<double> &bound2varOut) {

    bound2avgOut = *bound2avg_nonstat;
    bound2varOut = *bound2var_nonstat;
    bound2preOut = *bound2pre_nonstat;
  }

  inline void getBound3_nonstat(VectorMTL<double> &bound3avgOut, VectorMTL<double> &bound3preOut, 
    VectorMTL<double> &bound3varOut) {

    bound3avgOut = *bound3avg_nonstat;
    bound3varOut = *bound3var_nonstat;
    bound3preOut = *bound3pre_nonstat;
  }

  void tloop(MatrixMTL<double> &rhoMatrix, MatrixMTL<double> &iotaMatrix, MatrixMTL<double> &pMatrix,
    VectorMTL<double> &lambda1, MatrixMTL<double> &VMatrix, MatrixMTL<double> &s, 
    VectorMTL<double> &d, double &Delta0, double &Delta1);

  void main_loop(int xmax_init, int TbarInit, VectorMTL<double> &VInit, 
    MatrixMTL<double> &iotaInit, MatrixMTL<double> &rhoInit, VectorMTL<double> &s0_init, VectorMTL<double> &tildes,
    MatrixMTL<double> &prices_init, VectorMTL<double> &lambda_oe, VectorMTL<double> &D0);

  ~CompOE_nonstat();

  void computeState(MatrixMTL<double> &iotaMatrix, MatrixMTL<double> &rhoMatrix,
    VectorMTL<double> &lambda1, MatrixMTL<double> &s);

//  void computeT(VectorMTL<double> *,VectorMTL<double> *,VectorMTL<double> *, double, int &, int &);
//  VectorMTL<double> *computeV(VectorMTL<double> &, VectorMTL<double> &, VectorMTL<double> &,double, int sizeOfV);

  void computeStatsNonstat(double *bounds, int Tbar, int xmax, MatrixMTL<double> &iotaMatrix, MatrixMTL<double> &rhoMatrix,
    VectorMTL<double> &lambdaVector, MatrixMTL<double> &pMatrix, VectorMTL<double> &s0_init,
    VectorMTL<double> &VInit, VectorMTL<double> &tildes, VectorMTL<double> &D0);
  void computeBoundsNonstat(double *, MatrixMTL<double> &, MatrixMTL<double> &,
    MatrixMTL<double> &, VectorMTL<double> &, MatrixMTL<double> &);

  stackItem* searchStack(MTL::VectorMTL<double>&, MTL::VectorMTL<double>&);
  //void setShock(int w);
  void setShock(int t);
  void restore();
};

#endif
