/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "function.h"

Function::Function(const int xSizeInit, const int ySizeInit) {
  xSize=xSizeInit;
  ySize=ySizeInit;
  myfile = &cout;
}

void Function::setParams(VectorMTL<double> &paramsInit) {
  paramsSize=paramsInit.getSize();
  params.init(paramsSize);
  params = paramsInit;
}


int Function::solveNR(VectorMTL<double> &x_init, VectorMTL<double> &x) {
  int success;
  int check;
  x=x_init; // Back up starting point
//  while(1) {
    success=newt(x,ySize,&check);
    if (check==0) {
//      break;
    } else {
      cout << "Global Newton-Rhapson has converged to the local minimum\n";
      success = 0;
    }
//  }
//  cout << x << endl;
// cout << eval(x);
//  getchar();
  return success;
}
void Function::lnsrch(int n, VectorMTL<double> &xold, float fold, VectorMTL<double> &g, VectorMTL<double> &p,  
   VectorMTL<double> &x, double *f, double stpmax, int *check) {

  int i;
  double a,alam,alam2,alamin,b,disc,f2,rhs1,rhs2,slope,sum,temp,
      test,tmplam;
  *check=0;
  for (sum=0.0,i=0;i<n;i++) sum += p[i]*p[i];
  sum=sqrt(sum);
  if (sum > stpmax) //Scale if attempted step is too big.
    for (i=0;i<n;i++) p[i] *= stpmax/sum;
  for (slope=0.0,i=0;i<n;i++)
    slope += g[i]*p[i];
  if (slope >= 0.0) {
    slope = -1e-4;
    cout << "Roundoff problem in lnsrch.\n";
  }
  test=0.0;
  for (i=0;i<n;i++) {
      temp=fabs(p[i])/FMAX(fabs(xold[i]),1.0);
      if (temp > test) test=temp;
  }
  alamin=TOLX/test; //Always try full Newton step first.
  alam=1.0; //Start of iteration loop.
  for (;;) {
      for (i=0;i<n;i++) x[i]=xold[i]+alam*p[i];
      *f=fmin(x); 
      if (alam < alamin) { 
          for (i=0;i<n;i++) x[i]=xold[i];
          *check=1;
          return;
      } else if (*f <= fold+ALF*alam*slope) return;
      else {
          if (alam == 1.0)
              tmplam = -slope/(2.0*(*f-fold-slope));
          else {
              rhs1 = *f-fold-alam*slope;
              rhs2=f2-fold-alam2*slope;
              a=(rhs1/(alam*alam)-rhs2/(alam2*alam2))/(alam-alam2);
              b=(-alam2*rhs1/(alam*alam)+alam*rhs2/(alam2*alam2))/(alam-alam2);
              if (a == 0.0) tmplam = -slope/(2.0*b);
              else {
                  disc=b*b-3.0*a*slope;
                  if (disc < 0.0) tmplam=0.5*alam;
                  else if (b <= 0.0) tmplam=(-b+sqrt(disc))/(3.0*a);
                  else tmplam=-slope/(b+sqrt(disc));
              }
              if (tmplam > 0.5*alam)
                  tmplam=0.5*alam;
          }
      }
      alam2=alam;
      f2 = *f;
      alam=FMAX(tmplam,0.1*alam);
  }
}

int Function::newt(VectorMTL<double> &x, int n, int *check) {
  int i,its,j;
  double den,f,fold,stpmax,sum,temp,test;

  MatrixMTL<double> fjac(n,n);
  VectorMTL<double> g(n);
  VectorMTL<double> p(n);
  VectorMTL<double> xold(n);

  fvec = new VectorMTL<double>(n);

  f=fmin(x);
  test=0.0;

  for (i=0;i<n;i++)
      if (fabs((*fvec)[i]) > test) test=fabs((*fvec)[i]);
  if (test < 0.01*TOLF) {
//      cout << "tol f hit" << endl;
      *check=0;
      delete(fvec);
      return 1;
  }
  for (sum=0.0,i=0;i<n;i++) sum += x[i]*x[i];
  stpmax=STPMX*FMAX(sqrt(sum),(float)n);

  for (its=0;its<MAXITS;its++) {
    jacobian(fjac,x); // put numerical jacobian here
    for (i=0;i<n;i++) {
       for (sum=0.0,j=0;j<n;j++) sum += fjac[j][i]*(*fvec)[j];
       g[i]=sum;
//       cout << "grad" << g << endl;
    }

    for (i=0;i<n;i++) xold[i]=x[i];
    fold=f;
    for (i=0;i<n;i++) p[i] = -(*fvec)[i];
    if(!fjac.solve(p)) {
      cout << "Singlar jacobian in global NR\n";
      return 0;
    }
//    cout << "fjac " << p <<endl;
    lnsrch(n,xold,fold,g,p,x,&f,stpmax,check);

    test=0.0;

    for (i=0;i<n;i++) {
      if (fabs((*fvec)[i]) > test) test=fabs((*fvec)[i]);
      if (test < TOLF) {
        *check=0;
//        cout << "tol f fit" << endl;
        delete(fvec);
        return 1;
      }
    }

    if (*check) {
      test=0.0;
      den=FMAX(f,0.5*n);
      for (i=0;i<n;i++) {
        temp=fabs(g[i])*FMAX(fabs(x[i]),1.0)/den;
        if (temp > test) test=temp;
      }
      *check=(test < TOLMIN ? 1 : 0);
//      cout << "weird tol hit" << endl;
      delete(fvec);
      return 1;
    }
    test=0.0;
    for (i=0;i<n;i++) {
      temp=(fabs(x[i]-xold[i]))/FMAX(fabs(x[i]),1.0);
      if (temp > test) test=temp;
    }
    if (test < TOLX) {
//      cout << "tol x hit" << endl;
//      cout << x << endl;
//      cout << xold << endl;
//      getchar();
      delete(fvec);
      return 1;
    }
  }
  cout << "Maximum number of iterations was hit\n";
  return 0;
}


double Function::fmin(VectorMTL<double> &x) {
  double output = 0;
  int size = (fvec->getSize());
  *fvec = eval(x);
//  cout << *fvec;
//  getchar();

  for(int i=0;i<size;i++) {
    output += ((*fvec)[i])*((*fvec)[i]);
  }
  return 0.5*output;
}

VectorMTL<double> Function::eval(VectorMTL<double> &xInit){};

void Function::jacobian(MatrixMTL<double> &output, VectorMTL<double> &xInit){};

Function::~Function() {
}
