/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FUNCTION_H
#define FUNCTION_H

#include "vectorMTL.h"
#include "matrixMTL.h"
#include "math.h"
#include "setup.h"
#include<iostream>
#include <sys/time.h>
#include<stdlib.h>

#define MAX_ITER 10000


#define NEWTON__STEP 0.5
#define ALF 1e-1
//#define TOLX (convtol[14])
#define TOLX 1e-10
#define MAXITS 50000
//#define TOLF (convtol[15])
#define TOLF 1e-4
#define TOLMIN 1e-10
#define STPMX 100.0
#define PERTURB_SIZE 0.3

using namespace std;
using namespace MTL;

/**
	@author Przemyslaw Jeziorski <przemekj@stanford.edu>
*/
class Function {
protected:
  VectorMTL<double> params;
  int paramsSize;
  int xSize;
  int ySize;
  VectorMTL<double> *fvec;
  ostream *myfile;

public:
  Function(const int xSizeInit, const int ySizeInit);
//  Function(const int xSizeInit, const int ySizeInit, ofstream *myfile_init);
  void setParams(VectorMTL<double> &paramsInit);

  virtual VectorMTL<double> eval(VectorMTL<double> &xInit);

  virtual void jacobian(MatrixMTL<double> &output, VectorMTL<double> &xInit);
  int solveNR(VectorMTL<double> &x_init, VectorMTL<double> &x);
  void lnsrch(int n, VectorMTL<double> &xold, float fold, VectorMTL<double> &g, VectorMTL<double> &p, VectorMTL<double> &x,
    double *f, double stpmax, int *check);
  double fmin(VectorMTL<double> &x);
  int newt(VectorMTL<double> &x, int n, int *check);

  virtual ~Function();

};

#endif
