#include "functionIpopt.h"

using namespace Ipopt;

FunctionIpopt::FunctionIpopt(double *init, int dim_init, double *state_init, double *x0_init, 
   VectorMTL<double> *solution_init, double x_l_init_, double x_u_init_) {

   solution=solution_init;
   dim = dim_init;
   state = new double[dim];
   x0 = new double[dim];
   x_l_init = x_l_init_;
   x_u_init = x_u_init_;

   for(int i=0;i<dim;i++) {
     state[i] = state_init[i];
     x0[i] = x0_init[i];
   }

   prof_fun = new double[PROF_FUN_PARAM_NO];
   for(int i=0;i<PROF_FUN_PARAM_NO;i++) {
     prof_fun[i] = init[i];
   }
}

FunctionIpopt::~FunctionIpopt() {
//  if(solution!=NULL) {
//    delete solution;
//  }
  delete[] state;
  delete[] prof_fun;
  delete[] x0;
}

void FunctionIpopt::initStructures(double *init) {
  prof_fun = init;
}

void FunctionIpopt::setState(double *state_init) {
  state = state_init;
}

void FunctionIpopt::setStartingPoint(double *x0_init) {
  x0 = x0_init;
}

void FunctionIpopt::setDim(int dim_init) {
  dim = dim_init;
}

bool FunctionIpopt::get_nlp_info(Index& n, Index& m, Index& nnz_jac_g,
                         Index& nnz_h_lag, IndexStyleEnum& index_style) {
  // Optimizer finds prices that maximize the objective function
  // There are the same number of prices as state variables
  n = dim;

  // Constraints are the FOCs
  m = n;

  // number of nonzeros in the Jacobian of the constraints
  nnz_jac_g = n*n;

  // number of distinct nonzeros in the Hessian of the Langragian
  #ifndef NUMERICAL_HESSIAN
    nnz_h_lag = n*(n-1)/2;
  #endif
  // We use the standard fortran index style for row/col entries
  index_style = TNLP::C_STYLE;;

  return true;
}

bool FunctionIpopt::get_bounds_info(Index n, Number* x_l, Number* x_u,
                            Index m, Number* g_l, Number* g_u) {
  // Inequality constraints
  for(int i=0;i<n;i++) {
    x_u[i] = x_u_init;
    x_l[i] = x_l_init;
  }

  // we have one equality constraint, so we set the bounds on this constraint
  // to be equal (and zero).
  for(int i=0;i<n;i++) {
    g_l[i] = g_u[i] = 0.0;
  }


  return true;
}

bool FunctionIpopt::get_starting_point(Index n, bool init_x, Number* x,
                               bool init_z, Number* z_L, Number* z_U,
                               Index m, bool init_lambda,
                               Number* lambda)
{
  // Here, we assume we only have starting values for x, if you code
  // your own NLP, you can provide starting values for the others if
  // you wish.
  assert(init_x == true);
  assert(init_z == false);
  assert(init_lambda == false);

  // we initialize x in bounds, in the upper right quadrant
  for(int i=0;i<n;i++) {
    x[i] = x0[i];
//    cout << x[i] << endl;
//    getchar();
  }

  return true;
}

bool FunctionIpopt::eval_f(Index n, const Number* x, bool new_x, Number& obj_value) {
  obj_value = 1;
  return true;
}

bool FunctionIpopt::eval_grad_f(Index n, const Number* x, bool new_x, Number* grad_f) {  

  // return the gradient of the objective function grad_{x} f(x)

  for(int i=0;i<n;i++) {
    grad_f[i] = 0.0;
  }

  return true;
}

bool FunctionIpopt::eval_g(Index n, const Number* x, bool new_x, Index m, Number* g) {
  profitFOC((double *) g, (double *) x, state, n, (double *) prof_fun);

  return true;
}

bool FunctionIpopt::eval_jac_g(Index n, const Number* x, bool new_x,
                       Index m, Index nele_jac, Index* iRow, Index *jCol,
                       Number* values) {
  if (values == NULL) {
    int idx = 0;
    for(int row=0;row<n;row++) {
      for(int col=0;col<n;col++) {
        iRow[idx] = row;
        jCol[idx] = col;
        idx++;
      }
    }
  } else {
    profitJacobian((double *) values, (double *) x, state, n, (double *) prof_fun);
  }

  return true;
}

bool FunctionIpopt::eval_h(Index n, const Number* x, bool new_x,
                   Number obj_factor, Index m, const Number* lambda,
                   bool new_lambda, Index nele_hess, Index* iRow,
                   Index* jCol, Number* values) {
  #ifndef NUMERICAL_HESSIAN
    if (values == NULL) {
      int idx = 0;
      for(int row=0;row<n;row++) {
        for(int col=0;col<row;col++) {
          iRow[idx] = row;
          jCol[idx] = col;
          idx++;
        }
      }
    } else {
      profitHessian((double *)values, (double *)x, state, n, (double *) lambda, prof_fun);
    }
    return true;
  #else
    return false;
  #endif
}

void FunctionIpopt::finalize_solution(SolverReturn status,
                              Index n, const Number* x, const Number* z_L, const Number* z_U,
                              Index m, const Number* g, const Number* lambda,
                              Number obj_value,
			      const IpoptData* ip_data,
			      IpoptCalculatedQuantities* ip_cq) {
//  if(solution!=NULL) {
//    delete solution;
//  }
//  solution = new VectorMTL<double>(n);

  for(int i=0;i<n;i++) {
    (*solution)[i]=x[i];
  }
}

