/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "functionprofit.h"

/****************************************
 * Argumnets of the function are states *
 ****************************************/

int FunctionProfit::eval(VectorMTL<double> &xInit, VectorMTL<double> &p0, VectorMTL<double> &output, 
  int eval_stats, VectorMTL<double> &ms, double &prodsur, double &conssur) {

  int success = 1;

  VectorMTL<double> pstar(ySize);
  int numberOfStates = xInit.getSize();
  VectorMTL<double> nominator(numberOfStates);
  double denominator, second_term;
  denominator=exp(prof_fun[5]);

  /* reset the initial condition for all iterations */
  // p0 = prof_fun[9];

  #ifdef USE_IPOPT
   SmartPtr<TNLP> mynlp = new FunctionIpopt(prof_fun,xInit.getSize(),xInit.data,p0.data,&pstar, 
     prof_fun_ipopt[0], prof_fun_ipopt[1]);
   SmartPtr<IpoptApplication> app = new IpoptApplication();

    // Change some options
    app->Options()->SetNumericValue("tol", 1e-9);
    app->Options()->SetIntegerValue("max_iter", 200);
//    app->Options()->SetStringValue("output_file", "ipopt.out");
    #ifdef NUMERICAL_HESSIAN
      app->Options()->SetStringValue("hessian_approximation", "limited-memory");
    #endif
    app->Options()->SetIntegerValue("print_level",-2);

    // Intialize the IpoptApplication and process the options
    ApplicationReturnStatus status;
    status = app->Initialize();
    if (status != Solve_Succeeded) {
      printf("\n\n*** Error during initialization!\n");
      return (int) status;
    }

    // Set parameters
//    mynlp->initStructures(prof_fun);
//    mynlp->setDim(xInit.getSize());
//    mynlp->setState(xInit.data);
//    mynlp->setStartingPoint(p0.data);
    // Ask Ipopt to solve the problem
    status = app->OptimizeTNLP(mynlp);

    if (status != Solve_Succeeded) {
//      printf("\n\n*** The problem FAILED!\n");
        success=0;
    }
//    mynlp->getSolution(pstar);

  #else
    FunctionProfitFoc profitfoc(numberOfStates,numberOfStates);
    profitfoc.initStructures(prof_fun);
    profitfoc.setParams(xInit);
//  Switch on if you want to use constant prices
//    success = 1;
//    pstar=prof_fun[9];
//  Switch off this
    success = profitfoc.solveNR(p0,pstar);
  #endif

  for (int i=0; i<numberOfStates; i++) {
    second_term=prof_fun[1]-pstar[i];
    if(second_term<=0) {
      cout << "Complex profit, trying to continue...\n";
      second_term=1e-10;
      pstar[i]=prof_fun[1]-(1e-10);
      success = 0;
    }
    if(pstar[i]<=0) {
      cout << "Negative prices, trying to continue...\n";
      pstar[i]=0;
      success = 0;
    }

    nominator[i] = exp(prof_fun[2]*(log(i/prof_fun[4]+1))+
      prof_fun[3]*log(second_term));
    denominator += xInit[i]*nominator[i];
  }


  for (int i=0; i<numberOfStates; i++) {
    ms[i]=nominator[i]/denominator;
    output[i]=prof_fun[0] * nominator[i]/denominator * (pstar[i]-MACRO__MARGINAL_COST(i))-prof_fun[8];
  }
  p0=pstar;

  if(eval_stats==1) {
    prodsur=sum(output*xInit);
    conssur=prof_fun[0]*log(denominator);
  }

  return success;
}

void FunctionProfit::jacobian(MatrixMTL<double> &output,VectorMTL<double> &xInit) {
}

FunctionProfit::~FunctionProfit()
{
}
