/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FUNCTIONPROFIT_H
#define FUNCTIONPROFIT_H

/***********************************************************
 * Implementation of logit one-period profit function      *
 * using the Function class.                               *
 * This gives the value of the Nash profit                 *
 * PARAMETRES:                                             *
 *    - none                                               *
 * INPUTS:                                                 *
 *    - state vector                                       *
 * VALUE:                                                  *
 *    - Nash profit                                        *
 ***********************************************************/
#include <function.h>
#include <functionprofitfoc.h>
#include <setup.h>
#include<marginalcost.h>

#ifdef USE_IPOPT
  #include "IpIpoptApplication.hpp"
  #include "IpSolveStatistics.hpp"
  #include "functionIpopt.h"
#endif

/**
	@author Przemyslaw Jeziorski <przemekj@stanford.edu>
*/

#define PROF_FUN_PARAM_NO 10

using namespace MTL;

class FunctionProfit : public Function {
public:
  FunctionProfit(const int xSizeInit, const int ySizeInit) : 
    Function (xSizeInit, ySizeInit) {};

  double *prof_fun;
  double *prof_fun_ipopt;

  /* Initialize internal structure */
  inline void initStructures(double *init, double *init2) {
    prof_fun = init;
    prof_fun_ipopt = init2;
  }

  /* It give profit and prices */  
  int eval(VectorMTL<double> &, VectorMTL<double> &, VectorMTL<double> &,
    int, VectorMTL<double> &, double &, double &);

  void jacobian(MatrixMTL<double> &output, VectorMTL<double> &xInit);

  ~FunctionProfit();
};

#endif
