/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "functionprofitfoc.h"
void *thread_function_jacobian(void *input);

/****************************************
 * Argumnets of the function are prices *
 ****************************************/

VectorMTL<double> FunctionProfitFoc::eval(VectorMTL<double> &xInit) {
  VectorMTL<double> output(ySize); 
  profitFOC(output.getData(), xInit.getData(), params.getData(), output.getSize(), prof_fun);
  return output;
}

/****************************************
 * Calculate analytical jacobian at 'p' *
 * INPUT                                *
 *     - prices                         *
 * OUTPUT                               *
 *     - jacobian matrix                *
 ****************************************/

void FunctionProfitFoc::jacobian(MatrixMTL<double> &output, VectorMTL<double> &xInit) {
  profitJacobian(output.getData(), xInit.getData(), params.getData(), output.getHeight(), prof_fun);
}

FunctionProfitFoc::~FunctionProfitFoc() {
}
