/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FUNCTIONPROFITFOC_H
#define FUNCTIONPROFITFOC_H

/***********************************************************
 * Implementation of logit one-period profit function      *
 * using the Function class.                               *
 * This function solves for FOC of the profit maximization *
 * PARAMETRES:                                             *
 *    - state vector                                       *
 * INPUTS:                                                 *
 *    - prices                                             *
 * VALUE:                                                  *
 *    - FOC in the Nash equilibrium profit maximization    *
 ***********************************************************/
#include <iostream>
#include <fstream>

#include <function.h>
#include <setup.h>
#include <functionprofit.h>
#include <profitJacobian.h>
#include <profitFOC.h>

/**
	@author Przemyslaw Jeziorski <przemekj@stanford.edu>
*/

typedef struct {
   VectorMTL<double> *z;
   int from,to;
   MatrixMTL<double> *output;
   VectorMTL<double> *temp1;
   VectorMTL<double> *temp2;
   int xSize;
  } ThreadStructureJacobian;

class FunctionProfitFoc : public Function {
public:
  double *prof_fun;

  /* Initialize internal structure */
  inline void initStructures(double *init) {
    prof_fun = init;
  }

  FunctionProfitFoc(const int xSizeInit, const int ySizeInit) : 
    Function (xSizeInit, ySizeInit) {};

  VectorMTL<double> eval(VectorMTL<double> &xInit);

  void jacobian(MatrixMTL<double> &output, VectorMTL<double> &xInit);

  ~FunctionProfitFoc();

};

#endif
