#include "profitFOC.h"

bool profitFOC(double *values, double *x, double *state, int n, double *prof_fun) {
  VectorMTL<double> nominator(n);
  VectorMTL<double> output(n);
  double denominator;
  denominator=exp(prof_fun[5]);

  /* I do the loop not matrix opearations because it is faster */
  for (int i=0; i<n; i++) {
    double second_term = ((prof_fun[1]-x[i])>0) ? prof_fun[1]-x[i] : 1e-5;

    nominator[i] = exp(prof_fun[2]*(log(i/prof_fun[4]+1))+
      prof_fun[3]*log(second_term));
    denominator += state[i]*nominator[i];
  }

  /* Calculate the value of FOC for each state */
  for (int i=0; i<n; i++) {
    double p = x[i];
    double sigma = nominator[i]/denominator;
    values[i] = prof_fun[1]-p+prof_fun[3]*(p-MACRO__MARGINAL_COST(i))*(sigma-1);
  }

  return true;
}
