/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "profitHessian.h"

bool profitHessian(double *values, double *x, double *state, int n, double *lambda, double *prof_fun) {
  VectorMTL<double> nominator(n), sigma(n), z(n), r(n), q(n), w(n);
  double denominator=exp(prof_fun[5]);

  /* Precalculate the nominators and denominator of \sigma */
  for (int i=0; i<n; i++) {
    double second_term = ((prof_fun[1]-x[i])>0) ? prof_fun[1]-x[i] : 1e-5;

    nominator[i] = exp(prof_fun[2]*(log(i/prof_fun[4]+1))+
      prof_fun[3]*log(second_term));
    denominator += state[i]*nominator[i];
  }

  // Precompute more...
  for (int i=0; i<n; i++) {  
    sigma[i] = nominator[i]/denominator;
    double second_term = ((prof_fun[1]-x[i])>0) ? prof_fun[1]-x[i] : 1e-5;

    z[i] = prof_fun[3]*sigma[i]/second_term;
    r[i] = sigma[i]*prof_fun[3]*(x[i]-MACRO__MARGINAL_COST(i));
    q[i] = prof_fun[3]*(sigma[i]+2*(x[i]-MACRO__MARGINAL_COST(i))*z[i]*sigma[i]-(x[i]-MACRO__MARGINAL_COST(i))*z[i]);
    w[i] = z[i]*(z[i]-(prof_fun[3]-1)/second_term);
  }

  int idx = 0;
  for(int i=0;i<n;i++) {
    for(int j=0;j<i;j++) {
      values[idx]=0;
      for(int m=0;m<n;m++) {
        if(i==j) {
          if(i==m) {
            values[idx]+=lambda[m]*(2*prof_fun[3]*z[m]*(sigma[m]-1)-
              prof_fun[3]*(x[m]-MACRO__MARGINAL_COST(i))*(sigma[m]-1)*z[m]*(prof_fun[3]-1)/(prof_fun[1]-x[m])+
              2*prof_fun[3]*(x[m]-MACRO__MARGINAL_COST(i))*z[m]*z[m]*(sigma[m]-1));
          } else {
            values[idx]+=lambda[m]*r[m]*w[j];
          }
        } else {
          if(j==m) {
            values[idx]+=lambda[m]*q[m]*z[i];
          } else {
            if(i==m) {
              values[idx]+=lambda[m]*q[m]*z[j];
            } else {
              values[idx]+=lambda[m]*2*r[m]*z[j]*z[i];
            }
          }
        }
      }
    idx++;
    }
  }

  return true;
}
