#include "profitJacobian.h"

bool profitJacobian(double *values, double *x, double *state, int n, double *prof_fun) {
  VectorMTL<double> nominator(n), sigma(n), z(n), temp1(n), temp2(n);
  double denominator;
  denominator=exp(prof_fun[5]);
  /* Precalculate the nominators and denomintor of \sigma */
  for (int i=0; i<n; i++) {
    double second_term = ((prof_fun[1]-x[i])>0) ? prof_fun[1]-x[i] : 1e-5;

    nominator[i] = exp(prof_fun[2]*(log(i/prof_fun[4]+1))+
      prof_fun[3]*log(second_term));
    denominator += state[i]*nominator[i];
  }

  /* Precalculate \sigma and z */
  int offset = 0;
  for (int i=0; i<n; i++) {
    sigma[i] = nominator[i]/denominator;
    double second_term = ((prof_fun[1]-x[i])>0) ? prof_fun[1]-x[i] : 1e-5;
    z[i] = -prof_fun[3]*sigma[i]/second_term;
    temp1[i] = prof_fun[3]*(MACRO__MARGINAL_COST(i)-x[i]);
    temp2[i] = sigma[i]*temp1[i];
    values[offset]=prof_fun[3]*(sigma[i]-1)*(1+z[i]*(MACRO__MARGINAL_COST(i)-x[i]))-1;
    offset+=(n+1);
  }

  /* Calculate the analytical jacobian using \sigma and z */
  offset = 0;
  for (int i=0; i<n; i++) {
    for (int j=0; j<i; j++) {
      values[offset+j]=temp2[i]*z[j];
    }
    for (int j=i+1; j<n; j++) {
      values[offset+j]=temp2[i]*z[j];
    }
    offset+=n;
  }

  return true;
}
