/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SETUP_H
#define SETUP_H

/*****************************************************************
 * If the below line is present and Ipopt was compiled in        *
 * the algorithm will try Newton method first and fall back on   *
 * Ipopt in case of failure.                                     *
 * Comment it out to use only Ipopt.                             *
 *****************************************************************/
#define IPOPT_FALLBACK_ONLY

/*******************************************************************
 * This parameter controlls threads                                *
 * - If you comment it out you will get a single threaded version  *
 * - Set it to the number to get that number of threads            *
 * - Set it to 0 to get maximum number of threads                  * 
 *******************************************************************/
#define USE_THREADS 0

/***************************************************************************
 * This parameter controls the type of matrix used to implement            *
 * a transition matrix. It can take following values                       *
 * - 0 - Dense matrix, implementation in compoe-tranprob_dense.cpp         *
 * - 1 - Tridiagonal matrix, implementation in compoe-tranprob_tridiag.cpp *
 * - 2 - Sparse matrix, implementation in compoe-tranprob_sparse.cpp       *
 * Details of implementation are in the appropiate cpp files               *
 ***************************************************************************/
#define TRANSITION_MATRIX 1
#define TRANSITION_MATRIX_DOM 2

/* Comment it out for silent input into file */
#define DEBUG

/* Comment it out for silent standart output */
#define COUT_DEBUG

/* This option turns on numerical Hessian of the Lagrangian in the profit function */
/* If you comment this out and use Ipopt you must provide a proper Hessian in 'profitHessian.cpp'   */
//#define NUMERICAL_HESSIAN

/* If mean is above that number Poisson is approximated as normal */
#define POISSON_AS_NORMAL 250

/* Some macros */

#define FMAX(a,b) (((a) > (b)) ? (a) : (b))
#define MAX(a,b) (((a) > (b)) ? (a) : (b))
#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#define MACRO__POSITIVE(input) (((input)<0) ? 0 : (input))

#define  GET_TRANSITION
//#define ACW

#endif

