/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PARAMETERS_H
#define PARAMETERS_H

/* Enables computing bounds */
/* Comment out to disable   */
//#define BOUNDS

/* Enables nonstationary solver */
/* Comment out to disable   */
//#define NONSTAT

/* Enables computing bounds for nonstationary OE */
/* Comment out to disable   */
//#define BOUNDS_NONSTAT

/* Enables computing OE with aggregate shocks */
/* Comment out to disable   */
#define AGGR_OE

/* Enables computing bounds for OE with aggregate shocks */
/* Comment out to disable   */
#define BOUNDS_AGGR_OE

/* Starting state (s0) */

#define S0_NONSTAT {2,2,2,2,0}

/* Number of quality levels  for s0 */
#define S0_SIZE 5

/* Number of control parameters */
#define CONTROL_N 3

/* Number of transition parameters */
#define TRANSITION_N 13

/* Number of convtol (convergence tolerance) parameters */
#define CONVTOL_N 17

/* Number of constants parameters */
#define CONSTANTS_N 5

/* Number of init parameters */
#define INIT_N 5

/* Number of bounds parameters */
#define BOUNDS_N 10

/* Number of non-stationary parameters */
#define NONSTAT_N 16

/* Number of aggregate shocks OE parameters */
#define AGGR_N 13

/* Number of ipopt parameters */
#define PROF_FUN_IPOPT_N 2

void initializeStructures(double *control, double *prof_fun, double *prof_fun_ipopt, double *transition, 
  double *constants, double *init, double *convtol, double *bounds, 
  double *nonstatparams, double *aggr) {

  /*******************************
   * Tolerance parameters        *
   *******************************/

  /* Tolerance for value iteration (valueIt) */
  convtol[0] = 1e-8;

  /* Tolerance for transition matrix and probability of exiting */
  convtol[1] = 1e-2;

  /* Maximum numbet of fpstrat iteration */
  convtol[2] = 5000.0;

  /* Tolerance on the probability of jumping up from the highest state */
  /* If probability exeeds the value xmax is increased by convtol[4]   */
  convtol[3] = 1e-5;

  /* How much to increase xmax if it too small */
  convtol[4] = 5.0;

  /* Tolerance on zero profit condition -- not used when set low */
  convtol[5] = 1e-2;

  /* How much should we increase (relative measure) search interval of lambda */
  /* when switching from approximate to exact profit function */
  convtol[6] = 0.1;

  /* How much should we extend search interval if the equilibrium is outside of the */ 
  /* of the current search iterval */
  convtol[7] = 0.5;

  /* Tolerance value on the condition number of the matrix when calculating */
  /* stationary distribution. If condition number is smaller that the       */
  /* given value infinite sum is calculated istead of the inverse           */
  convtol[8] = 1e10;

  /* Parameter regulating size of infinte sum in case condition number is small */
   convtol[9] = 100.0;

  /* Parameter regulating smooth update of strategies */
  convtol[10] = 0.6666;

  /* Maximum xmax, can't go above this at all */
  convtol[11] = 140.0;

  /* Hard minimum entry rate [otherwise code fails out] */
  convtol[12] = 1e-5;

  /* Hard maximum entry rate [otherwise code fails out] */ 
  convtol[13] = 1e6;

  /* Lower bound on multiplier in the Gauss-Seidel method */
  /* 0 - Turns the lower bound off */
  convtol[14] = 1e-1;

  /* Upper bound on multiplier in the Gauss-Seidel method */
  /* 0 - Turns the upper bound off */
  convtol[15] = 10.0;

  /* Tolerance on entry rate in outer iterations [note: requires one or other tol to be hit] */
  convtol[16] = 0.01; 

  /**************************
   * Control parameters     *
   **************************/

  /* 1 - if compute approximate profits first in the stationary model */
  /* 2 - if compute only actual profits       */
  control[0] = 1;

  /* Entry process                            */
  /* 1 - Poisson Entry                        */
  /* 2 - Constant Entry                       */
  control[1] = 1;

  /* Entry process                            */
  /* 0 - Random number of firms               */
  /* >0 - Set the fixed number of firms       */
  control[2] = 0;


  /**************************************/
  /* Transition maxix parameters        */
  /**************************************/

  transition[0]=14.7653;
  transition[1]=0.598446;
  transition[2]=2.92891;
  transition[3]=9;
  transition[4]=0;
  transition[5]=0;
  transition[6]=0.054;
  transition[7]=0.244;
  transition[8]=0.404;
  transition[9]=0.244;
  transition[10]=0.054;
  transition[11]=0;
  transition[12]=0;


  /********************************
   * Other constants of the model *
   ********************************/
  constants[0]=30.5467;
  constants[1]=0.853456;
  constants[2]=0.925;
  constants[3]=10;
  constants[4]=14.1196;


  /*******************************
   * Initialization parameters   *
   *******************************/

  init[0]=80;
  init[1]=1;
  init[2]=30.5467;
  init[3]=3.8;
  init[4]=72.2;

  /*******************************************
   * CONTROL PARAMETERS FOR COMPUTING BOUNDS *
   *******************************************/

   /* not used */
  bounds[0]=0.0;

  /* tolerance relative precision when simulating bounds *
   * TOL_PRECBOUNDS                                      */ 
  bounds[1]=0.1;

  /* tolerance relative precision when simulating expected value function *
   * TOL_PRECV                                                            */ 
  bounds[2]=0.01;

  /* maximum number of iterations to compute bounds *
   * NMAX_BOUND                                     */ 
  bounds[3]=1000.0;

  /* minimum number of iterations to compute bounds *
   * NMIN_BOUND                                     */ 
  bounds[4]=100.0;

  /* maximum number of periods to consider when sampling state *
   * in case constant number of entrants                       *
   * TOL_TIME_CONS_ENTR                                        */
  bounds[5]=200.0;

  /* tolerance prob. being in industry when sampling state *
   * in case constant number of entrants                   *
   * TOL_SAMPLE_CONS_ENTR                                  */
  bounds[6]=1e-3;

  /* how much more states off equlibrium path should be considered *
   * XMAX_BOUNDS_EXT                                               */
  bounds[7]=1.0;

  /* number of maximum state jumps per period *
   * STATE_JUMP                               */
  bounds[8]=1.0;

  /* tolerance of checking if Delta_y is increasing */
   bounds[9]=1e-3;


  /************************************
   * Parameters for non-stationary    *
   * equilibrium solver               *
   ************************************/

  /*** Conergence parameters ***/

  /* Tolerance parameter for rho             */
  nonstatparams[0]=1000.0;

  /* Tolerance parameter for iota  */
  nonstatparams[1]=1000.0;

  /* Tolerance parameter for zero profit condition */
  nonstatparams[2]=1000.0;

  /*** Smooth updating of the parameters ***/

  /* Exponential parameter on mu */
  nonstatparams[3]=0.5;

  /* Exponential parameter on lambda */
  nonstatparams[4]=0.5;

  /* Addition parameter on mu */
  nonstatparams[5]=1.0;

  /* Addition parameter on lambda */
  nonstatparams[6]=1.0;

  /*** Other parameters ***/

  /* How much to increase xmax when computing Tbar */
  nonstatparams[7]=50.0;

  /* If xmax_nonstat is bigger than S0_NONSTAT then fill with this number */
  nonstatparams[8]=0.0;

  /* number of maximum state jumps per period */
  nonstatparams[9] = 1.0;

  /* Number of periods in the non-stationary equilibrium *
   * If set to zero algorithm will compute Tbar          * 
   * T_UPPERBAR                                          */
  nonstatparams[10]=50.0;

  /* Tolerance for computing Tbar                        */
  nonstatparams[11]=1e-5;

  /* Number of states in the non-stationary equilibrium               *
   * When set to zero takes the value from the stationary computation *
   * xmax_nonstat                                                     */
  nonstatparams[12]=0.0;

  /* T_LOWERBAR */
  nonstatparams[13]=0.0;

  /* 1 - if compute appriximate profits first in the non-stationary model */
  /* 2 - if compute only actual profits       */
  nonstatparams[14]=2.0;

  /* If lambda is smaller than this we treat it as zero */
  nonstatparams[15]=1e-5;

  /**********************************
   * Aggregate shocks OE parameters *
   **********************************/


  /* Tolerance parameter for rho             */
  aggr[0]=1e-3;

  /* Tolerance parameter for iota  */
  aggr[1]=1e-3;

  /* Tolerance parameter for zero profit condition */
  aggr[2]=1e-3;

  /* If lambda is smaller than this we treat it as zero */
  aggr[3]=1e-5;

  /* 1 - if compute appriximate profits first *
   *      in the aggregate shocks model       *
   * 2 - if compute only actual profits       */
  aggr[4]=2;

  /* How much to derease size of the market if low shock */
  aggr[5]=0.0;

  /* How much to increase size of the market if high shock */
  aggr[6]=0.0;

  /* Exponential parameter on mu */
  aggr[7]=0.5;

  /* Addition parameter on mu */
  aggr[8]=1.0;

  /* Number of states                                                 *
   * When set to zero takes the value from the stationary computation */
  aggr[9]=0.0;

  /* Aggregate shocks bounds specific parameters */

  /* Warm up period length */
  aggr[10]=100.0;

  /* Lentgh of repetitions to get one sample point */
  aggr[11]=20.0;

  /* Number of steps between repetitions to get one sample point */
  aggr[12]=10.0;

  #include<parameters_profit.h>
}

#endif
