/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PARAMETERS_PROFIT__H
#define PARAMETERS_PROFIT__H

  /********************************
   * Logit profit function params *
   ********************************/

  /* Market size (M) */
  prof_fun[0] = 600.0;

  /* Income size (Y) */
  prof_fun[1] = 1.0;

  /* Consumer theta 1 (theta1) */
  prof_fun[2] = 0.5;

  /* Consumer theta 2 (theta2) */
  prof_fun[3] = 0.5;

  /* Psi */
  prof_fun[4] = 1.0;

  /* Utility of outside option */
  prof_fun[5] = 0.0;

  /* Marginal cost parameter 1 */
  prof_fun[6] = 0.5;

  /* Marginal cost parameter 2 */
  prof_fun[7] = 0.0;

  /* Fixed cost */
  prof_fun[8] = 0.0;

  /* Initial prices */
  prof_fun[9] = (prof_fun[1]+prof_fun[3]*prof_fun[6])/(1+prof_fun[3]);

  /*******************************
   * Ipopt parameters            *
   *******************************/

   prof_fun_ipopt[0] = 0;
   prof_fun_ipopt[1] = prof_fun[1];

#endif
