/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <math.h>
#include <compoe/compoe.h>
#include <compoe/compoe_nonstat.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>
#include <matrix3d.h>
#include <parameters.h>
#include <sparsematrixMTL.h>
#include <tridiagmatrix.h>


using namespace std;
using namespace MTL;

extern "C" { void amub_(int *nrow, int *ncol, int *job, 
  double *a, int *ja, int *ia, double *b, int *jb, int *ib, 
  double *c, int *jc, int* ic, int *nzmax, int *iw, int *ierr);
}
int main(int argc, char *argv[]) {

  MatrixMTL<short int> A(60000,60000);

  for(int j=0;j<60000;j++) {
    for(int i=0;i<60000;i++) {
      A[j][i]=5;
    }
  }

  cout << "done" << A[100][4000];
  getchar();
//   int nrow = 4;
//   int ncol = 4; 
//   int job = 1; 
// 
//   double a[10];
//   int ja[10];
//   int ia[6];
// 
//   double b[10];
//   int jb[10];
//   int ib[6];
// 
//   double c[16];
//   int jc[16];
//   int ic[16]; 
// 
//   int nzmax=16; 
//   int iw[10]; 
//   int ierr;
// 
//   a[0] = 1;
//   a[1] = 3;
//   a[2] = 7;
//   a[3] = 7;
//   a[4] = 6;
//   a[5] = 1;
//   a[6] = 4;
//   a[7] = 1;
//   a[8] = 8;
//   a[9] = 9;
// 
// 
//   ja[0] = 1;
//   ja[1] = 3;
//   ja[2] = 1;
//   ja[3] = 2;
//   ja[4] = 3;
//   ja[5] = 3;
//   ja[6] = 4;
//   ja[7] = 1;
//   ja[8] = 3;
//   ja[9] = 4;
// 
//   ia[0] = 1;
//   ia[1] = 3;
//   ia[2] = 6;
//   ia[3] = 8;
//   ia[4] = 11;
// 
//   b[0] = 1;
//   b[1] = 3;
//   b[2] = 7;
//   b[3] = 7;
//   b[4] = 6;
//   b[5] = 1;
//   b[6] = 4;
//   b[7] = 1;
//   b[8] = 8;
//   b[9] = 9;
// 
// 
//   jb[0] = 1;
//   jb[1] = 3;
//   jb[2] = 1;
//   jb[3] = 2;
//   jb[4] = 3;
//   jb[5] = 3;
//   jb[6] = 4;
//   jb[7] = 1;
//   jb[8] = 3;
//   jb[9] = 4;
// 
//   ib[0] = 1;
//   ib[1] = 3;
//   ib[2] = 6;
//   ib[3] = 8;
//   ib[4] = 11;
// 
// 
//   amub_(&nrow, &ncol, &job, 
//     a, ja, ia, b, jb, ib, 
//     c, jc, ic, &nzmax, iw, &ierr);

//  for(int i=0;i<ic[4]-1;i++) {
//   cout << jc[i] << " " << c[i] << endl;
//  }


/*
  SparseMatrixMTL<double> uio(5,3);
  SparseMatrixMTL<double> uio2(3,5,5);
  SparseMatrixMTL<double> uio3(5,3);
  
  uio[0] = 1.0;
  uio[1] = 2.0;
  uio[2] = 3.0;
  uio[3] = 4.1;
  uio[4] = 4.12;
  uio[5] = 4.13;
  uio[6] = 4.14;
  uio[7] = 5.15;
  uio[8] = 6.16;
  uio[9] = 7.17;
  uio[10] = 8.1;
  uio[11] = 9.1;
  uio[12] = 4.2;

  MatrixMTL<double> test(5,5);
  cout << uio.inverse(test) << endl;

  cout << test;

  MatrixMTL<double> test2(5,5);
  test2=test.dot(uio);

  cout << test2;

  cout << uio.getRow(0);
  cout << uio.getRow(1);
  cout << uio.getRow(2);
  cout << uio.getRow(3);
  cout << uio.getRow(4);*/

//   TriDiagMatrixMTL<double> temp(3);
//   temp[0][0]=0.75;
//   temp[0][1]=0.25;
//   temp[0][2]=0.5;
// 
//   temp[-1][0]=0.5;
//   temp[-1][1]=0.25;
// 
//   temp[1][0]=0.25;
//   temp[1][1]=0.5;
// 
//   cout << temp;
// 
//   VectorMTL<double> temp2(3);
//   temp.statDistr(temp2);
//   cout << temp2;
// 
//   MatrixMTL<double> temp3(3,3);
//   temp3[0][0]=0.75;
//   temp3[0][1]=0.25;
//   temp3[0][2]=0.0;
// 
//   temp3[1][0]=0.25;
//   temp3[1][1]=0.5;
//   temp3[1][2]=0.25;
// 
//   temp3[2][0]=0.0;
//   temp3[2][1]=0.5;
//   temp3[2][2]=0.5;
// 
//   cout << temp3;
// 
//   temp3.statDistr(temp2);
//   cout << temp2;


/*
  uio2.columns[0] = 0;
  uio2.columns[1] = 4;
  uio2.columns[2] = 1;
  uio2.columns[3] = 3;
  uio2.columns[4] = 2;

  uio2.rows[0] = 0;
  uio2.rows[1] = 0;
  uio2.rows[2] = 1;
  uio2.rows[3] = 1;
  uio2.rows[4] = 2;

  uio2[0] = 1;
  uio2[1] = 2;
  uio2[2] = 3;
  uio2[3] = 4;
  uio2[4] = 5;


  cout << uio <<endl;
  cout << uio2 << endl;

  uio3=uio2.dot(uio);
  cout << uio3;


  VectorMTL<double> b(5);
  b[0]=1;
  b[1]=2;
  b[2]=3;
  b[3]=4;
  b[4]=5;

  VectorMTL<double> sol(5);
  uio.(b,sol);

  cout << sol;

  cout << uio.dot(sol);*/
//   SparseMatrixMTL<double> uio(3,3);
//   uio[0]=1;
//   uio[1]=0;
// 
//   uio[2]=0;
//   uio[3]=2;
//   uio[4]=0;
// 
//   uio[5]=0;
//   uio[6]=3;
// //  cout << uio.getSize();
//   VectorMTL<double> b(3);
//   b[0]=1;
//   b[1]=4;
//   b[2]=9;
//   VectorMTL<double> sol(3);
//   uio.solve(b,sol);
// 
//   cout << sol;

  int xmax_tmp = 30; // Set xmax here
  VectorMTL<double> state_tmp(xmax_tmp);
  state_tmp = 0; // for example all ones
  state_tmp[29]=0;
  VectorMTL<double> profit_tmp(xmax_tmp); 
  CompOE *oe = new CompOE();

  double prof_fun[PROF_FUN_PARAM_NO];
  double prof_fun_ipopt[PROF_FUN_IPOPT_N];
  double transition[TRANSITION_N];
  double constants[CONSTANTS_N];
  double init[INIT_N]; 
  double nonstatparams[NONSTAT_N];
  double convtol[CONVTOL_N];
  double bounds[BOUNDS_N];
  double control[CONTROL_N];
  double aggr[AGGR_N];

  initializeStructures(control, prof_fun, prof_fun_ipopt, transition, 
    constants, init, convtol, bounds, nonstatparams, aggr);

  ofstream myfile;
  myfile.open ("output");

  oe = new CompOE();
  oe->setOutput(&myfile);
  oe->initialize(control, prof_fun, prof_fun_ipopt, transition, constants, init, convtol);

  VectorMTL<double> prices_tmp(xmax_tmp);
  prices_tmp = prof_fun[9];

  // Compute profit
  if(!oe->compProf(state_tmp,prices_tmp,profit_tmp)) {
    cout << "Need to update xmax" << endl; 
    exit(1);
  }
/*
  VectorMTL<double> iota_tmp(xmax_tmp);
  VectorMTL<double> rho_tmp(xmax_tmp);
  // Set iota and rho here, counter of vectors start at zero
  // iota_tmp[0]=1;
  // iota_tmp[1]=2; and so on....
  iota_tmp = 1;
  rho_tmp = 0.5;

  VectorMTL<double> prcont_tmp(xmax_tmp);
  VectorMTL<double> condexp_tmp(xmax_tmp);
  VectorMTL<double> tildes_tmp(xmax_tmp);
  VectorMTL<double> expfreq_tmp(xmax_tmp);
  TriDiagMatrixMTL<double> tranmat_tmp(xmax_tmp);
  TriDiagMatrixMTL<double> conttranmat_tmp(xmax_tmp);

  tmpOE->continuationProb(rho_tmp,prcont_tmp,condexp_tmp);
  tmpOE->tranProb(iota_tmp,tranmat_tmp,conttranmat_tmp,prcont_tmp);
  // Precompute marginal cost //
  VectorMTL<double> d(xmax_tmp);
  for(int i=0;i<xmax_tmp;i++) {
    d[i]=MACRO__MINVCOST(i);
  }

  tmpOE->expState(conttranmat_tmp, tildes_tmp, expfreq_tmp, d);
*/
  cout << profit_tmp;
//  cout << tildes_tmp;
  delete oe;
//  cout << binopdf(5,10,0.8);

  exit(1);
}
