function [rev saveNu] = average_revenue(gamma,nmarkets)
  global pop weights profitData demographics index data dates markets mySeed arg

  k=1;

  %% gamma(1:3) = slope           (matket specific)
  %% gamma(4:6) = MC intercept    (market specific)
  %% gamma(6:9) = MC time dummies
 
  %% I bring back 2SLS residuals to compare with the output that C code gives
  %% Should be the same
  global ols_residual

  rev=zeros(nmarkets,1);

  for m=1:nmarkets
    fprintf('%d ',m);
    profitData.market = m-1;
    profitData.gamma = [1 (pop(m)<500)*gamma(1)+((pop(m)>=500)*(pop(m)<1500))*gamma(2)+((pop(m)>=1500)*(pop(m)<3500))*gamma(3)+(pop(m)>=3500)*gamma(4)];
    profitData.omega = weights{m};
    for d=1:21
      mc=(pop(m)<500)*gamma(5)+((pop(m)>=500)*(pop(m)<1500))*gamma(6)+(pop(m)>=1500)*gamma(7);
      if(d<4)
        profitData.dummy=1;
      else
        profitData.dummy=profitData.arg(profitData.parameters+profitData.demoCharacteristics*profitData.product+profitData.random_effects+profitData.extra_parameters+floor((d-2)/2));
%        profitData.gamma(1)=gamma(91+floor((d-2)/2));
        %% Add time effect to marginal cost
        mc=mc+(pop(m)<500)*gamma(7+floor((d-2)/2))+((pop(m)>=500)*(pop(m)<1500))*gamma(16+floor((d-2)/2))+(pop(m)>=1500)*gamma(25+floor((d-2)/2));
      end

      idx=(d-1)*88+m;
      dataIdx = [index(idx)+1:index(idx+1)];
      stations = index(idx+1)-index(idx);

      dataLocal=data(dataIdx,:);
      owner_share = [];
      for i=1:stations
        I=find(dataLocal(:,3)==dataLocal(i,3));
        owner_share=[owner_share; sum(dataLocal(I,4))];
      end
      % throw in xi
      xi=zeros(size(dataLocal,1),1);
      xi_number=dataLocal(:,19)+1;
      nondark_idx=find(xi_number~=0); %% 0 was -1, means entry
      xi(nondark_idx)=arg(xi_number(nondark_idx)+profitData.allParams);

      % 1-fm, 2-format, 3-owner, 4-owner_share, 5-station_share, 6-xi, 7-q, 8-power
      M=[dataLocal(:,1) dataLocal(:,2) dataLocal(:,3) owner_share dataLocal(:,4) xi dataLocal(:,5) dataLocal(:,6)];
      Z=[dataLocal(:,7)];
      [M I]=sortrows(M,[-4 3]);
      Z=Z(I,:);

      % initial demographics
      profitData.demographics=demographics(:,(idx-1)*profitData.N+1:(idx)*profitData.N);

      M(:,3) = createRanking(M(:,3));
      ranking = createRanking(M(:,3));
      M=[M ranking'];

      I=find((M(:,2)~=8) & (M(:,5)>0));

      profitData.q=M(I,7);
      profitData.data=M(I,:)';
      profitData.stations=size(I,1);

      profitData.reInit=1;
      epsilonFullDerMex(profitData, mySeed);
      profitData.reInit=0;
      [nu share dgamma1 dgamma2]= epsilonFullDerMex(profitData, mySeed);
      temp=-mc*ones(index(idx+1)-index(idx),1);
      temp(I)=nu;
      saveNu{d,m} = temp;
%{
      profitData2=profitData
      save profitData profitData2
      [M(I,:) nu]
      pause
%}
%      profitData.epsilon=nu;
      profitData.epsilon=zeros(size(nu));
      profitData.CPP=1;
      profitData.solve=0;

      q=profitData.q;
      save profitIn profitData mySeed
      dos('../mex/profitIpopt profitIn.mat profitOut.mat');
      load profitOut
      rev(m)=rev(m)+mean(profit_station);
%{      
      profit_station
      profitData.epsilon=nu;
      save profitIn profitData mySeed
      dos('../mex/profitIpopt profitIn.mat profitOut.mat');
      load profitOut
%}
      %% Compare with OLS
%      offset=k+size(nu,1)-1;      
%      ols_residual_local=ols_residual(k:offset,1)+(pop(m)<500)*gamma(4)+((pop(m)>=500)*(pop(m)<1500))*gamma(5)+(pop(m)>=1500)*gamma(6)+...
%               ((d>=4)*(d<10))*gamma(7)+((d>=10)*(d<16))*gamma(8)+((d>=16)*(d<22))*gamma(9);
%      k=k+size(nu,1);
      %% Compute average profit
    end % date
  end % market
  rev=rev/21;
  fprintf('\n');
end

