#!/usr/bin/perl
$n=0;
open(FILE,'beta_star.csv');
open(OUT2,'>beta_scatter.csv');
while($line = <FILE>) {
  chop $line;
  @fields = split(/:/,$line);
  $fields[0]=int($fields[0]);
  $gamma1{$fields[0]}=$fields[1];
  $gamma1std{$fields[0]}=$fields[2];
#  $gamma0{$fields[0]}=$fields[3]s
#  $gamma0std{$fields[0]}=$fields[4];
  $n++;
}
close(FILE);

open(FILE,'MARKETS_POPULATION_FILTERED.csv');
while($line = <FILE>) {
  chop $line;
  @fields = split(/:/,$line);
  if(exists $gamma1{$fields[0]}) {
    $names{$fields[0]}=$fields[1];
    $pop{$fields[0]}=$fields[2];
  }
}
close(FILE);

$n1=int($n/2);
open(OUT,'>gamma2.tex');

print OUT '\begin{landscape}\begin{table}\begin{center}\fontsize{6}{6}\selectfont\begin{tabular}{lcc||lcc}'."\n";
print OUT 'Name & Pop. 2007 & Intercept & ';
print OUT 'Name & Pop. 2007 & Intercept \\\\\\hline\\hline'."\n";
@a = reverse sort {$pop{$a} <=> $pop{$b}} keys %pop;
for($i=0;$i<=$n1;$i++) {
  $market=$a[$i];
  print OUT2 "$pop{$market},$gamma1{$market}\n";
#  print OUT "$names{$market} & $pop{$market} & $gamma1{$market} ($gamma1std{$market}) & $gamma0{$market} ($gamma0std{$market})&";
  print OUT "$names{$market} & $pop{$market} & $gamma1{$market} ($gamma1std{$market}) &";
  $market=$a[$i+$n1];
  print OUT2 "$pop{$market},$gamma1{$market}\n";
#  print OUT "$names{$market} & $pop{$market} & $gamma1{$market} ($gamma1std{$market}) & $gamma0{$market} ($gamma0std{$market})\\\\\n ";
  print OUT "$names{$market} & $pop{$market} & $gamma1{$market} ($gamma1std{$market})\\\\\\hline\n ";
}
print OUT "\\multicolumn{6}{c}{Standard errors (corrected for the first stage) in parentheses} \\\\\n";
print OUT "\\multicolumn{6}{c}{*** p$$<$$0.01, ** p$$<$$0.05, * p$$<$$0.1} \\\\\n";

=cut
if(2*$n1!=$n) {
  $market=$a[$n1-1];
  print OUT "$market & $names{$market} & $pop{$market} & $gamma{$market} & & & & \\\\\n";
}
=cut

print OUT "\\end{tabular}\\end{center}\n";
print OUT '\caption{Intercept of advertiser demand function for each market}\label{t:ADV1}'."\n";
print OUT '\end{table}\end{landscape}'."\n";

close(OUT);
close(OUT2);
