clear all

% addpath /afs/ir/users/p/r/przemekj/blp_bootstrap/advDem/mex
addpath ../mex

global profitData
global demographics
global index
global data
global dates
global markets
global mySeed
global arg

dates=21;
markets=88;

saveNu=cell(dates,markets);

load demographics
load ../matlab/argFinal_gmm2

index = dlmread('../data/OFFSET_ADV.csv');
data = dlmread('../data/DATA_ADV.csv');

global weights;

for i=1:88
  weights{i}=eye(8,8);
end

global pop
load pop

mySeed=[76762 321321897 321312 298098];

profitData.product=8;
profitData.demoCharacteristics=6;
profitData.demoLineSize=6;
profitData.parameters=10;
profitData.N=100;
profitData.dataLineSize=9;
profitData.reInit=0;
profitData.simulate=0;
profitData.random_effects=profitData.product+1;
profitData.extra_parameters=1;
profitData.year_dummies=9;
profitData.allParams=profitData.parameters+profitData.demoCharacteristics*profitData.product+profitData.random_effects+profitData.extra_parameters+profitData.year_dummies;
profitData.arg=arg(1:profitData.allParams);

gamma_star=zeros(markets,2);

global rev
rev=zeros(markets,1);
CPI = [157.3, 160.5, 161.75, 163.0, 164.8, 166.6, 169.4, 172.2, 174.64, 179.9, 178.5, 179.9,...
  181.95, 184.0, 186.45, 188.9, 192.1, 195.3, 198.45, 201.6, 204.47];
CPI=CPI(1)./CPI;

for i=1:markets
  rev(i)=0;
  for d=1:dates
    idx=(d-1)*88+i-1;
    dataIdx = [index(idx+1)+1:index(idx+2)];
    stations = index(idx+2)-index(idx+1);

    dataLocal=data(dataIdx,:);
    I=find((dataLocal(:,2)~=8) & (dataLocal(:,4)>0));
    rev(i)=rev(i)+CPI(d)*mean(dataLocal(I,7));
  end
  rev(i)=rev(i)/dates/1e3/2;
end

%%% z  -      instruments
%%% d1 - derivative with respect to the intercept
%%%           each column is a year - it allows for different intercept
%%% d2 - derivative with respect to slope
%%% y  - constant term (derivative with respect to intercept for a first year times -1)
[z d1 d2 y md xi ns] = regression_data();
stdq=0.141998154680609;

md=[md(:,1) md(:,2) md(:,3)+md(:,4)];
xi=[xi(:,1) xi(:,2) xi(:,3)+xi(:,4)];
ns=[ns(:,1) ns(:,2) ns(:,3)+ns(:,4)];
ns=ns>1;

% Set the intercept to 1 for all years
y2=-sum(d1,2)+y;
% Constuct time dummies
dm=([d1]~=0);
yd=zeros(size(dm,1),9*3);
% Group into 1year periods
%yd=dm;
for i=1:size(dm,1)
  yd(i,:)=kron(md(i,:),dm(i,:));
end
%yd=[sum(dm(:,[1:3]),2) sum(dm(:,[4:6]),2) sum(dm(:,[7:9]),2)];
% Construct x matrix - slope, market dummies, time dummies
%d2=[d2(:,1) d2(:,2) d2(:,3)+d2(:,4)];
xmd=[d2 md yd xi ns];
% Run OLS
b1=inv(xmd'*xmd)*xmd'*y2
Gols=xmd'*(y2-xmd*b1);
% Std. error
V_ols=inv(xmd'*xmd)*var(y2-xmd*b1);
errols=sqrt(diag(V_ols));
% Construct the instrument matrix
z=z(:,[1 2 3 4   5 6 7 8    9 10 11 12   13 14 15 16]);
zmd=[z md yd xi ns];
% Run 2SLS
PzX=zmd*((inv(zmd'*zmd)*zmd'*xmd));
%b1iv=inv((xmd'*zmd)*(inv(zmd'*zmd)*zmd'*xmd))*(xmd'*zmd)*(inv(zmd'*zmd)*zmd'*y2)
b1iv=inv(PzX'*PzX)*PzX'*y2
Gsls=PzX'*(y2-xmd*b1iv);
V=inv(xmd'*PzX)*var(y2-xmd*b1iv);
erriv=sqrt(diag(V));

idx=find(d2(:,1)~=0);
i1=regstats(d2(idx,1),z(idx,[1 2 3 4]),'linear',{'rsquare','tstat','fstat'});
idx=find(d2(:,2)~=0);
i2=regstats(d2(idx,2),z(idx,[5 6 7 8]),'linear',{'rsquare','tstat','fstat'});
idx=find(d2(:,3)~=0);
i3=regstats(d2(idx,3),z(idx,[9 10 11 12]),'linear',{'rsquare','tstat','fstat'});
idx=find(d2(:,4)~=0);
i4=regstats(d2(idx,4),z(idx,[13 14 15 16]),'linear',{'rsquare','tstat','fstat'});


pause
%%%%%%%%%%% Compute derivative of the moment condition with respect to theta
load ../matlab/Jxi

G12_ols=zeros(size(b1iv,1),78);
G12_sls=zeros(size(b1iv,1),78);

for i=1:77
  fprintf('Step 1: Der %d\n',i);

  profitData.arg=Jxi(:,i);
  [z_epsilon d1_epsilon d2_epsilon y_epsilon md_epsilon xi_epsilon] = regression_data();

  md_epsilon=[md_epsilon(:,1) md_epsilon(:,2) md_epsilon(:,3)+md_epsilon(:,4)];
  xi_epsilon=[xi_epsilon(:,1) xi_epsilon(:,2) xi_epsilon(:,3)+xi_epsilon(:,4)];

  % Set the intercept to 1 for all years
  y2_epsilon=-sum(d1_epsilon,2)+y_epsilon;

  % Construct x matrix - slope, market dummies, time dummies
  xmd_epsilon=[d2_epsilon md_epsilon yd xi_epsilon ns];
  % Run
  b1_epsilon=inv(xmd_epsilon'*xmd_epsilon)*xmd_epsilon'*y2_epsilon;
  % Moment conditions
  Gols_epsilon=xmd_epsilon'*(y2_epsilon-xmd_epsilon*b1);
  G12_ols(:,i)=(Gols_epsilon-Gols)*1e6;

  % Construct the instrument matrix
  zmd_epsilon=[z_epsilon(:,[1 2 3 4    5 6 7 8    9 10 11 12   13 14 15 16]) md_epsilon yd xi_epsilon ns];
  % Run 2SLS
  PzX_epsilon=zmd_epsilon*((inv(zmd_epsilon'*zmd_epsilon)*zmd_epsilon'*xmd_epsilon));
  b1iv_epsilon=inv(PzX_epsilon'*PzX_epsilon)*PzX_epsilon'*y2_epsilon;

  % Moment conditions
  Gsls_epsilon=PzX_epsilon'*(y2_epsilon-xmd_epsilon*b1iv);
  G12_sls(:,i)=(Gsls_epsilon-Gsls)*1e6;
end
G12_ols(:,78)=zeros(size(G12_ols,1),1);
G12_sls(:,78)=zeros(size(G12_sls,1),1);

G22_ols=(xmd'*xmd);
G22_sls=(xmd'*zmd)*(inv(zmd'*zmd)*zmd'*xmd);

cor_ols=inv(G22_ols)*G12_ols;
cor_sls=inv(G22_sls)*G12_sls;

V_cor=V+cor_sls*COV*cor_sls';
erriv=sqrt(diag(V_cor));
V_ols_cor=V+cor_ols*COV*cor_ols';
errols=sqrt(diag(V_ols_cor));

fprintf('Estimation of intercepts ...\n');

nmarkets=88;
global ols_residual
ols_residual=y2-xmd*b1iv;
[revData saveNu]=average_revenue(b1iv,nmarkets);

fprintf('\n\nPostprocessing ...\n');

global ban
ban=[];
k=0;
kk=0;
for m=1:nmarkets
  km=0;
  kkm=0;
  for d=1:21
    k=k+sum(saveNu{d,m}>0);
    kk=kk+size(saveNu{d,m},1);

    km=km+sum(saveNu{d,m}>0);
    kkm=kkm+size(saveNu{d,m},1);

    % correct that
%    saveNu{d,m}(find(saveNu{d,m}>0))=0;
  end
  if(km/kkm>.15)
    ban=[ban m];
    [m km/kkm]
    k=k-km;
    kk=kk-kkm;
  end
end
k/kk;

rev=rev*1e6; %% in dollars



%% We need to normalize revenue in the data
%% Price needs to be measured in price per rating point
%% Q needs to be in minutes sold per half year
% *10000 - normalization of q 
% /100   - because MS is a fraction when computing q (when computing 
% *1000  - because revenue in thousands
% /2     - because revenue was measured on a yearly basis
% *100   - because MS is a fraction when computing s
% 100*s*(1-alpha)*q*10000*1000/100
beta = 10000/100*1000*100/2;
betaq = 10000/100*1000/2;

%%% Derive intercepts
for m=1:nmarkets
  gamma2(m)=rev(m)/revData(m)/beta;
%  gamma1(m)=gamma2(m)*((pop(m)<500)*b1iv(1)+((pop(m)>=500)*(pop(m)<1500))*b1iv(2)+(pop(m)>=1500)*(pop(m)<2500)*b1iv(3)+(pop(m)>=2500)*b1iv(4))*50;
  MCm(m)=gamma2(m)*((pop(m)<500)*b1iv(5)+((pop(m)>=500)*(pop(m)<1500))*b1iv(6)+(pop(m)>=1500)*b1iv(7))*beta/betaq;
%{
  T1m(m,:)=gamma2(m)*b1iv(8)*beta/betaq;
  T2m(m,:)=gamma2(m)*b1iv(9)*beta/betaq;
  T3m(m,:)=gamma2(m)*b1iv(10)*beta/betaq;
  T4m(m,:)=gamma2(m)*b1iv(11)*beta/betaq;
  T5m(m,:)=gamma2(m)*b1iv(12)*beta/betaq;
  T6m(m,:)=gamma2(m)*b1iv(13)*beta/betaq;
  T7m(m,:)=gamma2(m)*b1iv(14)*beta/betaq;
  T8m(m,:)=gamma2(m)*b1iv(15)*beta/betaq;
  T9m(m,:)=gamma2(m)*b1iv(16)*beta/betaq;
%}
end

%%% Compute derivative
for i=1:size(b1iv,1)
  fprintf('Step 2: Der %d\n',i);
  e=zeros(size(b1iv));
  e(i)=1e-6;
  b1ivE=b1iv+e;
  revDataE=average_revenue(b1ivE,nmarkets);  %% in dollars
  for m=1:nmarkets
    gamma2E=rev(m)/revDataE(m)/beta;
    gamma2D(m,i)=(gamma2E-gamma2(m))*1e6;
    MCmE=gamma2E*((pop(m)<500)*b1ivE(5)+((pop(m)>=500)*(pop(m)<1500))*b1ivE(6)+(pop(m)>=1500)*b1ivE(7))*betaq;
    MCmD(m,i)=(MCmE-MCm(m))*1e6;
%{
    T1mE=gamma2E*b1ivE(8)*betaq;
    T1mD(m,i)=(T1mE-T1m(m))*1e6;
    T2mE=gamma2E*b1ivE(9)*betaq;
    T2mD(m,i)=(T2mE-T2m(m))*1e6;
    T3mE=gamma2E*b1ivE(10)*betaq;
    T3mD(m,i)=(T3mE-T3m(m))*1e6;
    T4mE=gamma2E*b1ivE(11)*betaq;
    T4mD(m,i)=(T4mE-T4m(m))*1e6;
    T5mE=gamma2E*b1ivE(12)*betaq;
    T5mD(m,i)=(T5mE-T5m(m))*1e6;
    T6mE=gamma2E*b1ivE(13)*betaq;
    T6mD(m,i)=(T6mE-T6m(m))*1e6;
    T7mE=gamma2E*b1ivE(14)*betaq;
    T7mD(m,i)=(T7mE-T7m(m))*1e6;
    T8mE=gamma2E*b1ivE(15)*betaq;
    T8mD(m,i)=(T8mE-T8m(m))*1e6;
    T9mE=gamma2E*b1ivE(16)*betaq;
    T9mD(m,i)=(T9mE-T9m(m))*1e6;
%}
  end
end

for m=1:nmarkets
  gamma2mStd(m)=sqrt(gamma2D(m,:)*V_cor*gamma2D(m,:)');
%{
  MCmStd(m)=sqrt(MCmD(m,:)*V*MCmD(m,:)');
  T1mStd(m)=sqrt(T1mD(m,:)*V*T1mD(m,:)');
  T2mStd(m)=sqrt(T2mD(m,:)*V*T2mD(m,:)');
  T3mStd(m)=sqrt(T3mD(m,:)*V*T3mD(m,:)');
  T4mStd(m)=sqrt(T4mD(m,:)*V*T4mD(m,:)');
  T5mStd(m)=sqrt(T5mD(m,:)*V*T5mD(m,:)');
  T6mStd(m)=sqrt(T6mD(m,:)*V*T6mD(m,:)');
  T7mStd(m)=sqrt(T7mD(m,:)*V*T7mD(m,:)');
  T8mStd(m)=sqrt(T8mD(m,:)*V*T8mD(m,:)');
  T9mStd(m)=sqrt(T9mD(m,:)*V*T9mD(m,:)');
%}
end

save estimates_rob1
