clear all
gamma_starBs2=zeros(91,50);

load partial0
gamma_starBs2(:,1:10)=gamma_starBs(:,1:10);
load partial1
gamma_starBs2(:,11:20)=gamma_starBs(:,11:20);
load partial2
gamma_starBs2(:,21:30)=gamma_starBs(:,21:30);
load partial3
gamma_starBs2(:,31:40)=gamma_starBs(:,31:40);
load partial4
gamma_starBs2(:,41:50)=gamma_starBs(:,41:50);


gamma_starBs=gamma_starBs2;

stderr=sqrt(var(gamma_starBs2'))';

load ../gamma_final_c
load market_names
load ../../2stage/pop

markets = [2,3,10,7,8,15,11,17,24,18,14,21,23,30,22,33,27,37,25,...
  44,32,40,35,51,36,73,49,61,48,31,47,34,...
    55,42,43,53,46,50,52,64,54,66,173,67,80,...
      69,79,81,88,104,91,82,92,111,108,115,70,...
        140,106,129,102,142,110,...
          99,68,130,136,132,143,137,131,...
            141,174,170,239,221,164,135,176,233,201,224,244,...
              256,209,83,240,187];

% *10000 - normalization
% /100 - because MS is in %
% *1000 - because revenue in thousands
% we get the multiplier for total number of minutes broadcasted
beta = 10000/100*1000 

gamma(1:88)=gamma(1:88).*gamma2/beta*1e6;
stderr(1:88)=stderr(1:88).*gamma2/beta*1e6;

markets(ban)=[];
pop(ban)=[];
gamma(ban)=[];
stderr(ban)=[];
pmargin(ban)=[];

[temp I] = sort(-pop);

file = fopen('2stage_cost.tex','w');
n=size(markets,2)/2;
fprintf(file,'\\begin{landscape}\\begin{table}\n\\centering\n\\fontsize{7}{7}\\selectfont\\begin{tabular}{l|c|c|c||l|c|c|c}\n');
fprintf(file,'Market & Population (mil) & \\begin{tabular}{@{}c@{}}Marginal\\\\cost (\\$ per-miute)\\end{tabular} & \\begin{tabular}{@{}c@{}}Profit\\\\margin\\end{tabular} &\n');
fprintf(file,'Market & Population & \\begin{tabular}{@{}c@{}}Marginal\\\\cost\\end{tabular} & \\begin{tabular}{@{}c@{}}Profit\\\\margin\\end{tabular}\\\\\\hline\n');
for m=1:n
  fprintf(file,'%s & %s & %.1f (%.2f) & %.0f\\%% & ', market_names{markets(I(m))}, ...
    thousandSep(pop(I(m)),0), gamma(I(m)), stderr(I(m)), 100*pmargin(I(m)));
  fprintf(file,'%s & %s & %.1f (%.2f) & %.0f\\%% \\\\\n', market_names{markets(I(m+n))}, ...
    thousandSep(pop(I(m+n)),0), gamma(I(m+n)), stderr(I(m+n)), 100*pmargin(I(m+n)));
end
fprintf(file,'\\end{tabular}\n');
fprintf(file,'\\caption{\\selectfont Estimated marginal cost (in dollars per minute of broadcasted advertising)\n and a profit margin (before subtracting the fixed cost) for a chosen set of markets}\\label{t:cost}\n');
fprintf(file,'\\end{table}\n\\end{landscape}\n');
fclose(file);file = fopen('2stage_adv.tex','w');
fprintf(file,'\\begin{table}\n\\centering\n\\begin{tabular}{c|c|c|c}\n');
fprintf(file,'Market population & less than .5m & between .5m and 1.5m & more than 1.5m\\\\\\hline\\hline\n');
fprintf(file,' & %.2f (%.3f) & %.2f (%.3f) & %.2f (%.3f) \\\\\n', gamma(2*n+1), stderr(2*n+1), gamma(2*n+2), stderr(2*n+2), gamma(2*n+3), stderr(2*n+3));
fprintf(file,'\\end{tabular}\n');
fprintf(file,'\\caption{Slope of the inverse demand for ads $\\theta_{2}^A$, by market size}\\label{t:adv}\n');
fprintf(file,'\\end{table}\n');
fclose(file);
