clear all

% addpath /afs/ir/users/p/r/przemekj/blp_bootstrap/advDem/mex
addpath ../../mex
addpath ..

load sample2
global profitData
global demographics
global index
global data
global dates
global markets
global mySeed
global arg

dates=21;
markets=88;

saveNu=cell(dates,markets);

load demographics
load ../../matlab/argFinal_gmm2

index = dlmread('../../data/OFFSET_ADV.csv');
data = dlmread('../../data/DATA_ADV.csv');

global weights;
load adv_weights;
for i=1:88
  weights{i}=1/8*ones(8,8);
end
global pop
load pop

mySeed=[76762 321321897 321312 298098];

profitData.product=8;
profitData.demoCharacteristics=6;
profitData.demoLineSize=6;
profitData.parameters=10;
profitData.N=100;
profitData.dataLineSize=9;
profitData.reInit=0;
profitData.simulate=0;
profitData.random_effects=profitData.product+1;
profitData.extra_parameters=1;
profitData.year_dummies=9;
profitData.allParams=profitData.parameters+profitData.demoCharacteristics*profitData.product+profitData.random_effects+profitData.extra_parameters+profitData.year_dummies;
profitData.arg=arg(1:profitData.allParams);

gamma_star=zeros(markets,2);

global rev
rev=zeros(markets,1);
CPI = [157.3, 160.5, 161.75, 163.0, 164.8, 166.6, 169.4, 172.2, 174.64, 179.9, 178.5, 179.9,...
  181.95, 184.0, 186.45, 188.9, 192.1, 195.3, 198.45, 201.6, 204.47];
CPI=CPI(1)./CPI;

for i=1:markets
  rev(i)=0;
  for d=1:dates
    idx=(d-1)*88+i-1;
    dataIdx = [index(idx+1)+1:index(idx+2)];
    stations = index(idx+2)-index(idx+1);

    dataLocal=data(dataIdx,:);
    I=find((dataLocal(:,2)~=8) & (dataLocal(:,4)>0));
    rev(i)=rev(i)+CPI(d)*mean(dataLocal(I,7));
  end
  rev(i)=rev(i)/dates/1e3/2;
end

nmarkets=88;
rev=rev*1e6; %% in dollars

%% We need to normalize revenue in the data
%% Price needs to be measured in price per rating point
%% Q needs to be in minutes sold per half year
% *10000 - normalization of q 
% /100   - because MS is a fraction when computing q (when computing 
% *1000  - because revenue in thousands
% /2     - because revenue was measured on a yearly basis
% *100   - because MS is a fraction when computing s
% 100*s*(1-alpha)*q*10000*1000/100
beta = 10000/100*1000*100/2;
betaq = 10000/100*1000/2;

for r=1:1e2
  arg=arg_bs(:,r);
  b1iv=b1iv_bs(:,r);
  profitData.arg=arg(1:profitData.allParams);
  [revData saveNu_bs{r}]=average_revenue(b1iv,nmarkets);

  %%% Derive intercepts
  for m=1:nmarkets
    gamma2_bs(m,r)=rev(m)/revData(m)/beta;
    MCm_bs(m,r)=gamma2_bs(m,r)*((pop(m)<500)*b1iv(5)+((pop(m)>=500)*(pop(m)<1500))*b1iv(6)+(pop(m)>=1500)*b1iv(7))*beta/betaq;
  end
end

save sample3_rob2 arg_bs b1iv_bs gamma2_bs MCm_bs saveNu_bs
