load estimates

%%save advDemEstimates b1iv erriv b1 errols

fid = fopen('advDem.tex','wt');

b1(1:4)=stdq*b1(1:4);
errols(1:4)=stdq*errols(1:4);
b1iv(1:4)=stdq*b1iv(1:4);
erriv(1:4)=stdq*erriv(1:4);

b1(5:end)=b1(5:end)*100;
errols(5:end)=errols(5:end)*100;
b1iv(5:end)=b1iv(5:end)*100;
erriv(5:end)=erriv(5:end)*100;

stdxi=1.27;
b1(35:37)=stdq*stdxi*b1(35:37);
errols(35:37)=stdq*stdxi*errols(35:37);
b1iv(35:37)=stdq*stdxi*b1iv(35:37);
erriv(35:37)=stdq*stdxi*erriv(35:37);

fprintf(fid,'\\begin{table}[!htb]\n');
fprintf(fid,'\\begin{center}\n');
fprintf(fid,'\\begin{tabular}{c||c|c|c|c}\n');
fprintf(fid,'   & Population $<$.5 & Population .5M-1.5M & Population 1.5M-3.5M & Population $>$3.5M\\\\ \\hline\\hline\n');
fprintf(fid,'OLS & \\results{$%.2f%s$}{$%.2f$}', -b1(1),statTest(2,abs(b1(1))/errols(1)),errols(1));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', -b1(2),statTest(2,abs(b1(2))/errols(2)),errols(2));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', -b1(3),statTest(2,abs(b1(3))/errols(3)),errols(3));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', -b1(4),statTest(2,abs(b1(4))/errols(4)),errols(4));
fprintf(fid,'\\\\\\hline\n');
fprintf(fid,'2SLS & \\results{$%.2f%s$}{$%.2f$}', -b1iv(1),statTest(2,abs(b1iv(1))/erriv(1)),erriv(1));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', -b1iv(2),statTest(2,abs(b1iv(2))/erriv(2)),erriv(2));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', -b1iv(3),statTest(2,abs(b1iv(3))/erriv(3)),erriv(3));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', -b1iv(4),statTest(2,abs(b1iv(4))/erriv(4)),erriv(4));
fprintf(fid,'\\\\\\hline\n');
fprintf(fid,'\\multicolumn{5}{c}{Standard errors (corrected for the first stage) in parentheses} \\\\\n');
fprintf(fid,'\\multicolumn{5}{c}{*** p$<$0.01, ** p$<$0.05, * p$<$0.1} \\\\\n');
fprintf(fid,'\\end{tabular}\n');
fprintf(fid,'\\end{center}\n');
fprintf(fid,'\\caption{Slope of advertising price per rating point (CPP). Intercept is set to 1. Units are standard deviations of quantity supplied on a station level.}\\label{t:adv2}\n');
fprintf(fid,'\\end{table}\n\n');





fprintf(fid,'\\begin{table}[!htb]\n');
fprintf(fid,'\\begin{center}\n');
fprintf(fid,'\\begin{tabular}{c||c|c|c||c|c|c}\n');
fprintf(fid,' & \\multicolumn{3}{|c||}{Mean level} & \\multicolumn{3}{|c}{Quality intercept}\\\\\n');
fprintf(fid,'   & Pop. $<$.5 & Pop. .5M-1.5M & Pop. $>$1.5M & Pop. $<$.5 & Pop. .5M-1.5M & Pop. $>$1.5M \\\\ \\hline\\hline\n');
fprintf(fid,'OLS & \\results{$%.2f%s$}{$%.2f$}', b1(5),statTest(2,abs(b1(5))/errols(5)),errols(5));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1(6),statTest(2,abs(b1(6))/errols(6)),errols(6));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1(7),statTest(2,abs(b1(7))/errols(7)),errols(7));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1(35),statTest(2,abs(b1(35))/errols(35)),errols(35));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1(36),statTest(2,abs(b1(36))/errols(36)),errols(36));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1(37),statTest(2,abs(b1(37))/errols(37)),errols(37));
fprintf(fid,'\\\\\\hline\n');
fprintf(fid,'2SLS & \\results{$%.2f%s$}{$%.2f$}', b1iv(5),statTest(2,abs(b1iv(5))/erriv(5)),erriv(5));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1iv(6),statTest(2,abs(b1iv(6))/erriv(6)),erriv(6));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1iv(7),statTest(2,abs(b1iv(7))/erriv(7)),erriv(7));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1iv(35),statTest(2,abs(b1iv(35))/erriv(35)),erriv(35));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1iv(36),statTest(2,abs(b1iv(36))/erriv(36)),erriv(36));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1iv(37),statTest(2,abs(b1iv(37))/erriv(37)),erriv(37));
fprintf(fid,'\\\\\\hline\n');
fprintf(fid,'\\multicolumn{7}{c}{Standard errors (corrected for the first stage) in parentheses} \\\\\n');
fprintf(fid,'\\multicolumn{7}{c}{*** p$<$0.01, ** p$<$0.05, * p$<$0.1} \\\\\n');
fprintf(fid,'\\end{tabular}\n');
fprintf(fid,'\\end{center}\n');
fprintf(fid,'\\caption{Marginal cost per minute of advertising sold. Intercept of advertising price per rating point is set to 1.\n');
fprintf(fid,' Note that these numbers might be higher than one because the final price of advertising is CPP times the station rating in per cent. Units for quality are standard deviations of quality in the sample.}\\label{t:adv3}\n');
fprintf(fid,'\\end{table}\n\n');

fprintf(fid,'\\begin{table}[!htb]\n');
fprintf(fid,'\\begin{center}\n');
fprintf(fid,'\\begin{tabular}{c||c|c|c}\n');
fprintf(fid,' & \\multicolumn{3}{|c}{Cost synergies}\\\\\n');
fprintf(fid,'   & Pop. $<$.5 & Pop. .5M-1.5M & Pop. $>$1.5M \\\\ \\hline\\hline\n');
fprintf(fid,'OLS & \\results{$%.2f%s$}{$%.2f$}', b1(38),statTest(2,abs(b1(38))/errols(38)),errols(38));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1(39),statTest(2,abs(b1(39))/errols(39)),errols(39));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1(40),statTest(2,abs(b1(40))/errols(40)),errols(40));
fprintf(fid,'\\\\\\hline\n');
fprintf(fid,'2SLS & \\results{$%.2f%s$}{$%.2f$}', b1iv(38),statTest(2,abs(b1iv(38))/erriv(38)),erriv(38));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1iv(39),statTest(2,abs(b1iv(39))/erriv(39)),erriv(39));
fprintf(fid,' & \\results{$%.2f%s$}{$%.2f$}', b1iv(40),statTest(2,abs(b1iv(40))/erriv(40)),erriv(40));
fprintf(fid,'\\\\\\hline\n');
fprintf(fid,'\\multicolumn{4}{c}{Standard errors (corrected for the first stage) in parentheses} \\\\\n');
fprintf(fid,'\\multicolumn{4}{c}{*** p$<$0.01, ** p$<$0.05, * p$<$0.1} \\\\\n');
fprintf(fid,'\\end{tabular}\n');
fprintf(fid,'\\end{center}\n');
fprintf(fid,'\\caption{Marginal cost synergies from owning multiple stations of the same format.}\\label{t:adv_syn}\n');
fprintf(fid,'\\end{table}\n\n');


fprintf(fid,'\\begin{table}[!htb]\\fontsize{8}{14}\\selectfont\n');
fprintf(fid,'\\begin{center}\n');
fprintf(fid,'\\begin{tabular}{c|c||c|c|c|c|c|c|c|c|c}\n');
fprintf(fid,'& & 1998 & 1999 & 2000 & 2001 & 2002 & 2003 & 2004 & 2005 & 2006 \\\\\\hline\\hline \n');
fprintf(fid,'\\multirow{3}{*}{OLS} & ');
fprintf(fid,'Pop. $<$.5M &');
for i=1:9
  fprintf(fid,'\\resultssmall{$%.2f%s$}{$%.2f$} ',b1(7+i),statTest(2,abs(b1(7+i))/errols(7+i)),errols(7+i));
  if(i==9)
    fprintf(fid,'\\\\ \n');
  else
    fprintf(fid,' & ');
  end
end
fprintf(fid,'& Pop. .5M-1.5M &');
for i=1:9
  fprintf(fid,'\\resultssmall{$%.2f%s$}{$%.2f$} ',b1(16+i),statTest(2,abs(b1(16+i))/errols(16+i)),errols(16+i));
  if(i==9)
    fprintf(fid,'\\\\ \n');
  else
    fprintf(fid,' & ');
  end
end
fprintf(fid,'& Pop. $>$1.5M &');
for i=1:9
  fprintf(fid,'\\resultssmall{$%.2f%s$}{$%.2f$} ',b1(25+i),statTest(2,abs(b1(25+i))/errols(25+i)),errols(25+i));
  if(i==9)
    fprintf(fid,'\\\\ \n');
  else
    fprintf(fid,' & ');
  end
end

fprintf(fid,'\\hline\n');

fprintf(fid,'\\multirow{3}{*}{2SLS} & ');
fprintf(fid,'Pop. $<$.5 &');
for i=1:9
  fprintf(fid,'\\resultssmall{$%.2f%s$}{$%.2f$} ',b1iv(7+i),statTest(2,abs(b1iv(7+i))/erriv(7+i)),erriv(7+i));
  if(i==9)
    fprintf(fid,'\\\\ \n');
  else
    fprintf(fid,' & ');
  end
end
fprintf(fid,'& Pop. .5M-1.5M &');
for i=1:9
  fprintf(fid,'\\resultssmall{$%.2f%s$}{$%.2f$} ',b1iv(16+i),statTest(2,abs(b1iv(16+i))/erriv(16+i)),erriv(16+i));
  if(i==9)
    fprintf(fid,'\\\\ \n');
  else
    fprintf(fid,' & ');
  end
end
fprintf(fid,'& Pop. $>$1.5M &');
for i=1:9
  fprintf(fid,'\\resultssmall{$%.2f%s$}{$%.2f$} ',b1iv(25+i),statTest(2,abs(b1iv(25+i))/erriv(25+i)),erriv(25+i));
  if(i==9)
    fprintf(fid,'\\\\ \n');
  else
    fprintf(fid,' & ');
  end
end

fprintf(fid,'\\multicolumn{11}{c}{Standard errors (corrected for the first stage) in parentheses} \\\\\n');
fprintf(fid,'\\multicolumn{11}{c}{*** p$<$0.01, ** p$<$0.05, * p$<$0.1} \\\\\n');
fprintf(fid,'\\end{tabular}\n');
fprintf(fid,'\\end{center}\n');
fprintf(fid,'\\caption{Time effects in the marginal cost. 1996 and 1997 value is normalized to zero.}\\label{t:adv4}\n');
fprintf(fid,'\\end{table}\n\n');

fclose(fid);

markets = [2,3,10,7,8,15,11,17,24,18,14,21,23,30,22,33,27,37,25,...
  44,32,40,35,51,36,73,49,61,48,31,47,34,...
  55,42,43,53,46,50,52,64,54,66,173,67,80,...
  69,79,81,88,104,91,82,92,111,108,115,70,...
  140,106,129,102,142,110,...
  99,68,130,136,132,143,137,131,...
  141,174,170,239,221,164,135,176,233,201,224,244,...
  256,209,83,240,187];
dlmwrite('beta_star.csv',[markets;gamma2;gamma2mStd]','precision','%0.2f','delimiter',':');
dos('./createTable.pl');
