%%%%% Compute the counterfactual1 - Counterfactual revenues and cost for observed data period
%%%%%%%%% and CS+AS

clear all
addpath ../../mex
addpath ..


global pop
load pop
%pop=pop/1e4;
total_pop=sum(pop);

scale=[199609, 199703, 199709, 199803, 199809, 199903, 199909, 200003, 200009, 200103, 200109, 200203,...
  200209, 200303, 200309, 200403, 200409, 200503, 200509, 200603, 200609];

load estimates

index = dlmread('../../data/OFFSET_ADV.csv');
data = dlmread('../../data/DATA_ADV.csv');

states=21;
period=80;
markets=88;

% initialize the system
global profitData mySeed mySeed_dem

mySeed=[76762   321321897      321312      298098];

% rand('seed',45328789);
% randn('seed',234324);
% mySeed_full=floor(rand(markets,states,4)*1e7);
% mySeed_full_dem=floor(rand(markets,states,4)*1e7);
% mySeed_full_zeta=floor(rand(markets,states,4)*1e7);
% mySeed_full_nu=floor(rand(markets,states,4)*1e7);

%load ../../matlab/argFinal_eye
load ../../matlab/argFinal_gmm2

load ../sample/sample3

r=1
r
arg=arg_bs(:,r);
b1iv=b1iv_bs(:,r);
gamma2=gamma2_bs(:,r);
saveNu=saveNu_bs{r};


global G;

w0=zeros(states,markets);
w1=zeros(states,markets);
w2=zeros(states,markets);
w3=zeros(states,markets);
w4=zeros(states,markets);
w5=zeros(states,markets);

as0=zeros(states,markets);
as1=zeros(states,markets);
as2=zeros(states,markets);
as3=zeros(states,markets);
as4=zeros(states,markets);
as5=zeros(states,markets);

rev0=zeros(states,markets);
rev1=zeros(states,markets);
rev2=zeros(states,markets);
rev3=zeros(states,markets);
rev4=zeros(states,markets);
rev5=zeros(states,markets);

cost0=zeros(states,markets);
cost1=zeros(states,markets);
cost2=zeros(states,markets);
cost3=zeros(states,markets);
cost4=zeros(states,markets);
cost5=zeros(states,markets);

q0=zeros(states,markets);
q1=zeros(states,markets);
q2=zeros(states,markets);
q3=zeros(states,markets);
q4=zeros(states,markets);
q5=zeros(states,markets);


qq0=zeros(states,markets);
qq1=zeros(states,markets);
qq2=zeros(states,markets);
qq3=zeros(states,markets);
qq4=zeros(states,markets);
qq5=zeros(states,markets);

ww0=zeros(states,markets);
ww1=zeros(states,markets);
ww2=zeros(states,markets);
ww3=zeros(states,markets);
ww4=zeros(states,markets);
ww5=zeros(states,markets);

price0=zeros(states,markets);
price1=zeros(states,markets);
price2=zeros(states,markets);
price3=zeros(states,markets);
price4=zeros(states,markets);
price5=zeros(states,markets);

ban=[16    28 43    63];

for market=1:88
  m=market;
  if(sum(find(ban==market))) 
    fprintf('Market %d banned\n');
    continue;
  end
  
  fprintf('Market %d\n',market);
  profitData.omega=weights{market};
  % profitData.omega=ones(8,8);
  % profitData.omega=eye(8,8);
%  for state=10:10
   for state=1:21
    d=state;
    date = state-1;
%    fprintf('\tDate %d\n',date);
    
    profitData.market=88;
    
    idx=(d-1)*88+m; 
    dataIdx = [index(idx)+1:index(idx+1)];
    stations = index(idx+1)-index(idx);
  
    %% common profit data variables
    profitData.product=8;
    profitData.demoCharacteristics=6;
    profitData.demoLineSize=6;
    profitData.parameters=10;
    profitData.N=100;
    profitData.dataLineSize=9;
    profitData.reInit=0;
    profitData.simulate=0;
    profitData.random_effects=profitData.product+1;
    profitData.extra_parameters=1;
    profitData.year_dummies=9;
    profitData.allParams=profitData.parameters+profitData.demoCharacteristics*profitData.product+...
       profitData.random_effects+profitData.extra_parameters+profitData.year_dummies;
    profitData.arg=arg(1:profitData.allParams);
    idx2=0*88+m;
    profitData.demographics=demographics(:,(idx2-1)*profitData.N+1:(idx2)*profitData.N);

    m=market;
    profitData.solve=1;
    profitData.gamma = [1 (pop(m)<500)*b1iv(1)+((pop(m)>=500)*(pop(m)<1500))*b1iv(2)+((pop(m)>=1500)*(pop(m)<3500))*b1iv(3)+(pop(m)>=3500)*b1iv(4)];
    profitData.omega = weights{m};

    if(d<4)
      profitData.dummy=1;
      profitData.gamma(1)=1;
      net_mc=0;
    else
      profitData.dummy=1;
%      profitData.dummy=profitData.arg(profitData.parameters+...
%         profitData.demoCharacteristics*profitData.product+profitData.random_effects+profitData.extra_parameters+floor((d-2)/2));
      profitData.gamma(1)=1;
      net_mc=(pop(m)<500)*b1iv(7+floor((d-2)/2))+((pop(m)>=500)*(pop(m)<1500))*b1iv(16+floor((d-2)/2))+(pop(m)>=1500)*b1iv(25+floor((d-2)/2));
%      net_mc=0;
    end


    %% market specific, constant profit data
    %  variables
    profitData.stations=stations;
    
    %% initial state space
    dataLocal=data(dataIdx,:);
    
    owner_share = [];
    for i=1:stations
      I=find(dataLocal(:,3)==dataLocal(i,3));
      owner_share=[owner_share; sum(dataLocal(I,4))];
      nst_new(i,1)=(sum((dataLocal(:,3)==dataLocal(i,3)).*(dataLocal(:,2)==dataLocal(i,2)))>1);
    end
    xi=zeros(size(dataLocal,1),1);
    xi_number=dataLocal(:,19)+1;
    nondark_idx=find(xi_number~=0); %% 0 was -1, means entry
    xi(nondark_idx)=arg(xi_number(nondark_idx)+profitData.allParams);

    % 1-fm, 2-format, 3-owner, 4-owner_share, 5-station_share, 6-xi, 7-q, 8-power
    M=[dataLocal(:,1) dataLocal(:,2) dataLocal(:,3) owner_share dataLocal(:,4) xi dataLocal(:,5) dataLocal(:,6)];
    Z=[dataLocal(:,7)];
    [M I]=sortrows(M,[-4 3]);
    Z=Z(I,:);

    Mextra=[dataLocal(:,15) dataLocal(:,16) dataLocal(:,12) dataLocal(:,11) dataLocal(:,17)];

%    nu=min(saveNu{state,market},-1e-6);
    saveNu{state,market}=min(saveNu{state,market}+net_mc,0);
    nu=saveNu{state,market};
  
    % create innitial ranking and get all the owners
    ranking = createRanking(M(:,3));
    M=[M ranking'];
  
    %%%% compute profit
    % draw nu
    I=find(M(:,2)~=8);
%    I=find((M(:,2)~=8) & (M(:,5)>0));

    % initialize state space
    profitData.data=M(I,:)';
    profitData.stations=size(I,1);
    profitData.q=M(I,7);
    profitData.epsilon=nu(I);
    saveM=M;

    %%%% End of init

    %% welfare for base case
    q_0=M(I,7);
%{
    %% check nu
    [nuhat share dgamma1 dgamma2]= epsilonFullDerMex(profitData, mySeed);
    [M(I,:) nu(I) nuhat]
    pause
%}
    fprintf('\t\tOriginal ownership and formats\n');
    q=profitData.q;
    save(['profitIn' num2str(r) '.mat'], 'profitData', 'mySeed');
    dos(['../../mex/profitIpopt profitIn' num2str(r) '.mat profitOut' num2str(r) '.mat']);
    load(['profitOut' num2str(r) '.mat']);

    q_f=zeros(8,1);
    for f=0:7
      q_f(f+1)=sum(q(find(profitData.data(2,:)==f)));
    end

    sur=profitData.omega*q_f;
    SA=0;
    for j=1:size(I,1)
      SA=SA+0.5*profitData.gamma(2)*gamma2(market)*station_shares(j)*q(j)*sur(profitData.data(2,j)+1);
    end
      
    as0(state,market)=SA;

    q0(state,market)=sum(q);
    %[sum(q)*274/size(M,1) 274*sum(q.*station_shares)/sum(station_shares)]
    %pause
    qq0(state,market)=sum(q.*station_shares)/sum(station_shares);

    profitData.q=q;
    w=welfareM();
%{
    q
    [sum(q) w]
    pause
%}
    % welfare
    w0(state,market)=w;

    % revenue
    piii=profit_station*gamma2(m);
    rev0(state,market)=sum(piii);

    % cost
%    cost0(state,market)=sum(cost(M(I,3),market));

    % price
    p_f=1-profitData.gamma(2)*profitData.omega*q_f;
    p=0;
    for j=1:size(I,1)
      p=p+station_shares(j)*p_f(profitData.data(2,j)+1);
    end
    price0(state,market)=p/sum(station_shares);

    saveq=q;
   
    zapisz=zeros(size(nu));
    zapisz(I)=q;

    %%%%% ownership of 1996 old formats
    newM=M;
    newM(:,3)=Mextra(:,4);
    newM(:,2)=Mextra(:,3);

    owner_share = [];
    for i=1:stations
      I=find(newM(:,3)==newM(i,3));
      owner_share=[owner_share; sum(newM(I,5))];
      nst_old(i,1)=(sum((newM(:,3)==newM(i,3)).*(newM(:,2)==newM(i,2)))>1);
    end
    newM(:,4)=owner_share;

    % now resort
    [newM Ix]=sortrows(newM,[-4 3]);
    newNu=nu(Ix);
    nst_old=nst_old(Ix);
    nst_new=nst_new(Ix);
    I=find(newM(:,2)~=8);
    nst_old=nst_old(I);
    nst_new=nst_new(I);

%    I=find((newM(:,2)~=8) & (newM(:,5)>0));
%    [newNu(I) (nst_new-nst_old)*((pop(m)<500)*b1iv(38)+...
%         ((pop(m)>=500)*(pop(m)<1500))*b1iv(39)+(pop(m)>=1500)*b1iv(40))]
%    pause
    profitData.epsilon=newNu(I)+(nst_new-nst_old)*((pop(m)<500)*b1iv(38)+...
      ((pop(m)>=500)*(pop(m)<1500))*b1iv(39)+(pop(m)>=1500)*b1iv(40));
    profitData.q=newM(I,7);
    profitData.data=newM(I,:)';
    profitData.stations=size(I,1);

    % calculate counterfactual quantities
    fprintf('\t\t1996 format, 1996 owner\n');
    save(['profitIn' num2str(r) '.mat'], 'profitData', 'mySeed');
    dos(['../../mex/profitIpopt profitIn' num2str(r) '.mat profitOut' num2str(r) '.mat']);
    load(['profitOut' num2str(r) '.mat']);

    takeback=zeros(size(nu));
    takeback(I)=q;
    takeback(Ix)=takeback;

    %%%%% compute advertiser surplus
    %% compute q_f
    q_f=zeros(8,1);
    for f=0:7
      q_f(f+1)=sum(q(find(profitData.data(2,:)==f)));
    end
    sur=profitData.omega*q_f;
    SA=0;
    for j=1:size(I,1)
      SA=SA+0.5*profitData.gamma(2)*gamma2(market)*station_shares(j)*q(j)*sur(profitData.data(2,j)+1);
    end
    
    as1(state,market)=SA;

    q1(state,market)=sum(q);
    qq1(state,market)=sum(q.*station_shares)/sum(station_shares);

    profitData.q=q;
    w=welfareM();
%{
    q
    [sum(q) w]
    pause
%}

    % compute weighted average
    w1(state,market)=w;

    rev1(state,market)=sum(piii);

    % price
    p_f=1-profitData.gamma(2)*profitData.omega*q_f;
    p=0;
    for j=1:size(I,1)
      p=p+station_shares(j)*p_f(profitData.data(2,j)+1);
    end
    price1(state,market)=p/sum(station_shares);
%    sum(newM(:,2)~=8)
%    sum(q)
%    [zapisz takeback]
%    pause



    %%%%% new ownership, new formats, old q
    newM=M;
    nu=saveNu{state,market};
    
    I=find(newM(:,2)~=8); 
%    I=find((newM(:,2)~=8) & (newM(:,5)>0));
    profitData.epsilon=nu(I);
    profitData.data=newM(I,:)';
    profitData.stations=size(I,1);
    profitData.solve=0;

    fprintf('\t\tNew ownership and formats, old q\n');
%    [takeback';newM(:,2)';Mextra(:,3)']
    profitData.q=takeback(I);

    save(['profitIn' num2str(r) '.mat'], 'profitData', 'mySeed');
    dos(['../../mex/profitIpopt profitIn' num2str(r) '.mat profitOut' num2str(r) '.mat']);
    load(['profitOut' num2str(r) '.mat']);

    %%%%% compute advertiser surplus
    %% compute q_f
    q_f=zeros(8,1);
    for f=0:7
      q_f(f+1)=sum(q(find(profitData.data(2,:)==f)));
    end
    sur=profitData.omega*q_f;
    SA=0;
    for j=1:size(I,1)
      SA=SA+0.5*profitData.gamma(2)*gamma2(market)*station_shares(j)*q(j)*sur(profitData.data(2,j)+1);
    end
%    sum(newM(:,2)~=8)
%    sum(q)
 %   pause
    as2(state,market)=SA;

    q2(state,market)=sum(q);
    qq2(state,market)=sum(q.*station_shares)/sum(station_shares);

    profitData.q=q;
    w=welfareM();

    % compute weighted average
    w2(state,market)=w;

    rev2(state,market)=sum(piii);

    cost2(state,market)=0;

    % price
    p_f=1-profitData.gamma(2)*profitData.omega*q_f;
    p=0;
    for j=1:size(I,1)
      p=p+station_shares(j)*p_f(profitData.data(2,j)+1);
    end
    price2(state,market)=p/sum(station_shares);

%    [saveq q]
%    [q2(10,1:20)' q0(10,1:20)' w2(10,1:20)' w0(10,1:20)']
%    [q1(10,1:20)' q2(10,1:20)' q0(10,1:20)' w1(10,1:20)' w2(10,1:20)' w0(10,1:20)']
%    pause

  end
end

save(['counter ' num2str(r) '.mat'], 'price0', 'price1', 'price2', 'price3', 'price4', 'price5', 'ww0', 'ww1', 'ww2', 'ww3', 'ww4', 'ww5', 'qq0', 'qq1', 'qq2', 'qq3', 'qq4', 'qq5', 'q0', 'q1', 'q2', 'q3', 'q4', 'q5', 'w0', 'w1', 'w2', 'w3', 'w4', 'w5', 'as0', 'as1', 'as2', 'as3', 'as4', 'as5', 'rev0', 'rev1', 'rev2', 'rev3', 'rev4', 'rev5', 'cost0', 'cost1', 'cost2', 'cost3', 'cost4', 'cost5');

end
