labels(1).format='\begin{tabular}{l}AC\\ SmoothJazz\\ New AC\end{tabular}';
labels(2).format='\begin{tabular}{l}Rock\end{tabular}';
labels(3).format='\begin{tabular}{l}CHR\end{tabular}';
labels(4).format='\begin{tabular}{l}Alternative\\ Urban\end{tabular}';
labels(5).format='\begin{tabular}{l}News/Talk\end{tabular}';
labels(6).format='\begin{tabular}{l}Country\end{tabular}';
labels(7).format='\begin{tabular}{l}Spanish\end{tabular}';
labels(8).format='\begin{tabular}{l}Other\end{tabular}';

load beta_iv
fid = fopen('tex/logit.tex','wt');
fprintf(fid,'\\begin{table}[!htb]\n');
fprintf(fid,'\\begin{center}\n');
fprintf(fid,'\\begin{tabular}{l||c|c}\n');
fprintf(fid,' & OLS & 2SLS \\\\ \\hline\n');
fprintf(fid,'Advertising & \\results{$%.3f%s$}{$%.3f$} & \\results{$%.3f%s$}{$%.3f$} \\\\ \n',beta_ols_t(1),statTest(2,abs(beta_ols_t(1))/beta_ols_t_stderr(1)),beta_ols_t_stderr(1),...
  beta_iv_t(1),statTest(2,abs(beta_iv_t(1))/beta_iv_t_stderr(1)),beta_iv_t_stderr(1));
fprintf(fid,'AM/FM & \\results{$%.3f%s$}{$%.3f$} & \\results{$%.3f%s$}{$%.3f$} \\\\ \\hline \n',beta_ols_t(2),statTest(2,abs(beta_ols_t(2))/beta_ols_t_stderr(2)),beta_ols_t_stderr(2),...
  beta_iv_t(2),statTest(2,abs(beta_iv_t(2))/beta_iv_t_stderr(2)),beta_iv_t_stderr(2));
fprintf(fid,'Power (kW) & \\results{$%.3f%s$}{$%.3f$} & \\results{$%.3f%s$}{$%.3f$} \\\\ \\hline \n',beta_ols_t(11),statTest(2,abs(beta_ols_t(11))/beta_ols_t_stderr(11)),beta_ols_t_stderr(11),...
  beta_iv_t(11),statTest(2,abs(beta_iv_t(11))/beta_iv_t_stderr(11)),beta_iv_t_stderr(11));
for i=1:8
  fprintf(fid,'%s & \\results{$%.3f%s$}{$%.3f$} & \\results{$%.3f%s$}{$%.3f$}',labels(i).format,...
    beta_ols_t(2+i),statTest(2,abs(beta_ols_t(2+i))/beta_ols_t_stderr(2+i)),beta_ols_t_stderr(2+i),...
    beta_iv_t(2+i),statTest(2,abs(beta_iv_t(2+i))/beta_iv_t_stderr(2+i)),beta_iv_t_stderr(2+i));
  fprintf(fid,'\\\\\\hline\n');
end

fprintf(fid,'\\multicolumn{3}{c}{Standard errors in parentheses} \\\\\n');
fprintf(fid,'\\multicolumn{3}{c}{*** p$<$0.01, ** p$<$0.05, * p$<$0.1} \\\\\n');
fprintf(fid,'\\end{tabular}\n');
fprintf(fid,'\\end{center}\n');
fprintf(fid,'\\caption{Estimates of random effects logit model of radio listeners demand.\n');
fprintf(fid,'First columns consists of mean values of parameters in the utility function. Second row consits of\n');
fprintf(fid,'standart deviations of a random effect $\\nu$}\\label{t:OLS1}\n');
fprintf(fid,'\\end{table}\n\n');

fprintf(fid,'\\begin{table}[!htb]\n');
fprintf(fid,'\\begin{center}\n');
fprintf(fid,'\\begin{tabular}{c||c|c|c|c|c|c|c|c|c|c}\n');
fprintf(fid,'1997 & 1998 & 1999 & 2000 & 2001 & 2002 & 2003 & 2004 & 2005 & 2006 \\\\\\hline\\hline \n');
fprintf(fid,'OLS & ');
for i=1:9
  fprintf(fid,'\\results{$%.3f%s$}{$%.3f$} ',beta_ols_t(11+i),statTest(2,abs(beta_ols_t(11+i))/beta_ols_t_stderr(11+i)),beta_ols_t_stderr(11+i));
  if(i==9)
    fprintf(fid,'\\\\ \\hline\n');
  else
    fprintf(fid,' & ');
  end
end
fprintf(fid,'2SLS & ');
for i=1:9
  fprintf(fid,'\\results{$%.3f%s$}{$%.3f$} ',beta_iv_t(11+i),statTest(2,abs(beta_iv_t(11+i))/beta_iv_t_stderr(11+i)),beta_iv_t_stderr(11+i));
  if(i==9)
    fprintf(fid,'\\\\ \\hline\n');
  else
    fprintf(fid,' & ');
  end
end

fprintf(fid,'\\multicolumn{9}{c}{Standard errors in parentheses} \\\\\n');
fprintf(fid,'\\multicolumn{9}{c}{*** p$<$0.01, ** p$<$0.05, * p$<$0.1} \\\\\n');
fprintf(fid,'\\end{tabular}\n');
fprintf(fid,'\\end{center}\n');
fprintf(fid,'\\caption{Estimates of utility (exponentiated) of not listening to radio. Value for 1996 is normalized to 1.}\\label{tOLSe2}\n');
fprintf(fid,'\\end{table}\n\n');

fclose(fid);

load stderr

theta_s=stderr;

theta=x([1:77 end]);

Pi_D = reshape(theta(11:58,1),6,8)';
sigma = abs(theta(59:67,1));
Pi_Ds = reshape(theta_s(11:58,1),6,8)';
sigma_s = theta_s(59:67,1);

fid = fopen('tex/logit_re.tex','wt');

fprintf(fid,'\\begin{table}[!htb]\n');
fprintf(fid,'\\begin{center}\n');
fprintf(fid,'\\begin{tabular}{l||c|c}\n');
fprintf(fid,' & Mean Effects & Random Effects\\\\ \\hline\n');
fprintf(fid,'Advertising & \\results{$%.3f%s$}{$%.3f$} & \\results{$%.3f%s$}{$%.3f$} \\\\ \n',theta(1),statTest(2,abs(theta(1))/theta_s(1)),theta_s(1),...
  theta(67), statTest(2,abs(theta(67))/theta_s(67)),theta_s(67));
fprintf(fid,'AM/FM & \\results{$%.3f%s$}{$%.3f$} & - \\\\ \\hline \n',theta(2),statTest(2,abs(theta(2))/theta_s(2)),theta_s(2));
fprintf(fid,'Power (kW) & \\results{$%.3f%s$}{$%.3f$} & - \\\\ \\hline \n',theta(68),statTest(2,abs(theta(68))/theta_s(68)),theta_s(68));
for i=1:8
  fprintf(fid,'%s & \\results{$%.3f%s$}{$%.3f$} & \\results{$%.3f%s$}{$%.3f$}',labels(i).format,theta(2+i),...
    statTest(2,abs(theta(2+i))/theta_s(2+i)),theta_s(2+i),sigma(i),statTest(1,abs(sigma(i))/sigma_s(i)),sigma_s(i));
  fprintf(fid,'\\\\\\hline\n');
end
fprintf(fid,'$\\rho$ & \\results{$%.3f%s$}{$%.3f$} & - ',theta(end),statTest(2,abs(theta(end))/theta_s(end)),theta_s(end));
fprintf(fid,'\\\\\\hline\n');
fprintf(fid,'\\multicolumn{3}{c}{Standard errors in parentheses} \\\\\n');
fprintf(fid,'\\multicolumn{3}{c}{*** p$<$0.01, ** p$<$0.05, * p$<$0.1} \\\\\n');
fprintf(fid,'\\end{tabular}\n');
fprintf(fid,'\\end{center}\n');
fprintf(fid,'\\caption{Estimates of random effects logit model of radio listeners demand.\n');
fprintf(fid,'First columns consists of mean values of parameters in the utility function. Second row consits of\n');
fprintf(fid,'standart deviations of a random effect $\\nu$}\\label{t:BLP1}\n');
fprintf(fid,'\\end{table}\n\n');

fprintf(fid,'\\begin{table}[!htb]\n');
fprintf(fid,'\\begin{center}\n');
fprintf(fid,'\\begin{tabular}{c|c|c|c|c|c|c|c|c|c}\n');
fprintf(fid,'1997 & 1998 & 1999 & 2000 & 2001 & 2002 & 2003 & 2004 & 2005 & 2006 \\\\\\hline\\hline \n');
for i=1:9
  fprintf(fid,'\\results{$%.3f%s$}{$%.3f$} ',theta(68+i),statTest(2,abs(theta(68+i))/theta_s(68+i)),theta_s(68+i));
  if(i==9)
    fprintf(fid,'\\\\ \\hline\n');
  else
    fprintf(fid,' & ');
  end
end
fprintf(fid,'\\multicolumn{9}{c}{Standard errors in parentheses} \\\\\n');
fprintf(fid,'\\multicolumn{9}{c}{*** p$<$0.01, ** p$<$0.05, * p$<$0.1} \\\\\n');
fprintf(fid,'\\end{tabular}\n');
fprintf(fid,'\\end{center}\n');
fprintf(fid,'\\caption{Estimates of utility (exponentiated) of not listening to radio. Value for 1996 is normalized to 1.}\\label{t:BLP3}\n');
fprintf(fid,'\\end{table}\n\n');

fprintf(fid,'\\begin{landscape}\\begin{table}[!htb]\n');
fprintf(fid,'\\begin{center}\n');
fprintf(fid,'\\begin{tabular}{l||cccccc}\n');
fprintf(fid,' & \\multicolumn{6}{c}{Demographics Characteritics} \\\\\n');
fprintf(fid,' & Age & Sex & Education & Income & Black & Spanish\\\\ \\hline\\hline\n');
for i=1:8
  fprintf(fid,'%s', labels(i).format);
  for j=1:6
    fprintf(fid,' & \\results{$%.3f%s$}{$%.3f$}',Pi_D(i,j),statTest(2,abs(Pi_D(i,j))/Pi_Ds(i,j)),Pi_Ds(i,j));
  end
  fprintf(fid,'\\\\\\hline\n');
end
fprintf(fid,'\\multicolumn{7}{c}{Standard errors in parentheses} \\\\\n');
fprintf(fid,'\\multicolumn{7}{c}{*** p$<$0.01, ** p$<$0.05, * p$<$0.1} \\\\\n');
fprintf(fid,'\\end{tabular}\n');
fprintf(fid,'\\end{center}\n');
fprintf(fid,'\\caption{Table presents estimates covariances in the random effects logit model of radio listeners demand.\n');
fprintf(fid,'Each cell represents covariance between specific domegraphic characteristic and listening to the particular radio station format.}\n');
fprintf(fid,'\\label{t:BLP2}\n');
fprintf(fid,'\\end{table}\\end{landscape}\n');

fclose(fid);
