%% This routine computes derivative of xi with respect to theta_D
% It will vbe used to update the second stage
%%

clear all
load problem_ar
load argFinal_gmm2

fprintf('Starting point ');
save startingPointIn_e problem data arg mySeed
dos('../mex/startingPoint startingPointIn_e.mat startingPointOut_e.mat');
load startingPointOut_e
fprintf('done... \n');
fprintf('Covariance matrix ');
arg=x_0;
save covarianceIn_e problem data mySeed arg
dos('../mex/covariance covarianceIn_e.mat covarianceOut_e.mat');
load covarianceOut_e
Omega=[A B';B C];
fprintf('done... \n');

%% use the value computed by a starting point routine instead of xstar to minimize the numerical error
Jxi=[];
x=x_0;
G11=[];

for i=1:78
  if(i==78) %% rho
    arg=x; arg(end)=arg(end)+1e-6;
  else
    arg=x; arg(i)=arg(i)+1e-6;
  end

  fprintf('Starting point %d ',i);
  save startingPointIn_e problem data arg mySeed
  dos('../mex/startingPoint startingPointIn_e.mat startingPointOut_e.mat');
  load startingPointOut_e
  fprintf('done... \n');

  Jxi(:,i)=x_0;

  subset=[[size(x_0,1)-1-problem.instruments+1:size(x_0,1)-1] [size(x_0,1)-1-problem.instruments-152+1:size(x_0,1)-1-problem.instruments]]';
  G11(:,i)=(x_0(subset)-x(subset))*1e6;

  COV=inv(G11(:,1:i)'*inv(Omega)*G11(:,1:i))/41220;
  stderr=sqrt(diag(COV));
  stderr(1)
end

COV=inv(G11'*inv(Omega)*G11)/41220;
stderr=sqrt(diag(COV));
save G11 G11
save stderr
save Jxi COV Jxi

