/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) Unknown 2008 <przemekj@stanford.edu>
 * 
 * main.cpp is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.cpp is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include<stdlib.h>
#include<stdio.h>
#include<math.h>

#include "cuda_generator.h"
#include "profitGlobals.h"
#include "simulateDemographics.h"

double theta_square;

void marketShareFoc(double *output, double outputJacob[][profitData->stations], 
    double outputDer[][profitData->stations][profitData->stations]) {
  int i,n,n1,n2,k;
  double temp[profitData->stations];
  double temp2[profitData->stations][profitData->stations];
  double nominator[profitData->stations];
  double delta[profitData->stations];
  double vDraws[profitData->product];
  double denominator;
  int format;
  int covarMatrixOffset;
  int offsetSigma = profitData->parameters+profitData->product*profitData->demoCharacteristics;
  double demographics[profitData->demoCharacteristics];

  for(n=0;n<profitData->stations;++n) {
    output[n]=0;
    delta[n]=profitData->q[n]*profitData->arg[0]+profitData->data[n][0]*profitData->arg[1]+
      profitData->arg[2+(int) profitData->data[n][1]]+profitData->data[n][5];
    for(n1=0;n1<profitData->stations;n1++) {
      outputJacob[n][n1]=0;
      for(n2=0;n2<profitData->stations;n2++) {
        outputDer[n2][n][n1]=0;
      }
    }
  }

  for(i=0;i<profitData->N;++i) {
    vectorNormal(seed[0], profitData->product, vDraws);
    /*for(n=0;n<profitData->product;++n) {
      printf("%f\t");
    }
    getchar();*/

    denominator=1;
    for(n=0;n<profitData->stations;++n) {
      format=profitData->data[n][1];

      covarMatrixOffset=profitData->parameters+format*profitData->demoCharacteristics;

      nominator[n]=delta[n]+profitData->arg[offsetSigma+format]*vDraws[format];
      if(profitData->simulate) {
        simulateDemographics(demographics);

        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*demographics[k];
        }
      } else {
        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*profitData->demographics[i*profitData->demoCharacteristics+k];;
        }
      }
      nominator[n]=exp(nominator[n]);
      denominator+=nominator[n];
    }
    for(n=0;n<profitData->stations;++n) {
      temp[n] = nominator[n]/denominator;
    }
    for(n=0;n<profitData->stations;++n) {
      for(n1=0;n1<=n;n1++) {
        temp2[n][n1]=theta_square*temp[n1]*temp[n];
        temp2[n1][n]=temp2[n][n1];
      }
    }
    for(n=0;n<profitData->stations;++n) {
      output[n]+=temp[n];
      for(n1=0;n1<n;n1++) {
        outputJacob[n][n1]-=profitData->arg[0]*temp[n]*temp[n1];
        for(n2=0;n2<profitData->stations;n2++) {
          if(n2==n1) {
            outputDer[n1][n][n1]+=temp2[n1][n]*(2*temp[n1]-1);
          } else if(n2!=n) { /* Cross, all different */
            outputDer[n2][n][n1]+=2*temp2[n2][n]*temp[n1];
          } else { /* Cross, one the same (n2=n)*/
            outputDer[n][n][n1]+=temp2[n1][n]*(2*temp[n]-1);
          }
        }
      }
      outputJacob[n][n]+=profitData->arg[0]*temp[n]*(1-temp[n]);
      for(n2=0;n2<profitData->stations;n2++) {
        if(n2==n) {
          outputDer[n][n][n]+=theta_square*temp[n]*(1-temp[n])*(1-2*temp[n]);
        } else { /* n=n1 */
          outputDer[n2][n][n]+=temp2[n][n2]*(2*temp[n]-1);
        }
      }
    }
  }

  for(n=0;n<profitData->stations;n++) {
    output[n]/=profitData->N;
//    output[n]*=100;
    for(n1=0;n1<=n;n1++) {
      outputJacob[n][n1]/=profitData->N;
//      outputJacob[n][n1]*=100;
      outputJacob[n1][n]=outputJacob[n][n1];
      for(n2=0;n2<profitData->stations;n2++) {
//        outputDer[n2][n][n1]*=100;
        outputDer[n2][n][n1]/=profitData->N;
        outputDer[n2][n1][n]=outputDer[n2][n][n1];
      }
    }
  }
}

void focDer(double *jacobian) {    
   int i,k,o,j,index;
   double output[profitData->stations];
   double outputJacob[profitData->stations][profitData->stations];
   double outputDer[profitData->stations][profitData->stations][profitData->stations];
   double aggrQ=0;
   double P;

   theta_square=profitData->arg[0]*profitData->arg[0];

   marketShareFoc(output, outputJacob, outputDer);

   // Aggregate output and price 
   for(i=0;i<profitData->stations;i++) {
     aggrQ+=profitData->q[i];
   }
   
   P=(profitData->gamma[0]-profitData->gamma[1]*aggrQ);


   for(o=0;o<profitData->number_of_owners;o++) {
     for(j=profitData->structure[o];j<profitData->structure[o+1];j++) {
       for(i=0;i<profitData->stations;i++) {
         index=j+i*profitData->stations;
         jacobian[index]=P*outputJacob[j][i]-profitData->gamma[1]*output[j];
         if((i>=profitData->structure[o]) && (i<profitData->structure[o+1])) {
           jacobian[index]+=P*outputJacob[i][j]-profitData->gamma[1]*output[i];
         }
         for(k=profitData->structure[o];k<profitData->structure[o+1];k++) {
           if(output[k]*P+profitData->epsilon[k]>0) {
             jacobian[index]+=profitData->q[k]*(P*outputDer[j][i][k]-profitData->gamma[1]*(outputJacob[j][k]+outputJacob[i][k]));
           }
         }
       }
     }
   }
}     
