/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) Unknown 2008 <przemekj@stanford.edu>
 * 
 * main.cpp is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.cpp is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include<stdlib.h>
#include<stdio.h>
#include<math.h>

#include "cuda_generator.h"
#include "profitGlobals.h"
#include "simulateDemographics.h"

void marketShareFoc(double *output, double outputJacob[][profitData->stations]) {
  int i,n,n1,k;
  double temp[profitData->stations];
  double nominator[profitData->stations];
  double delta[profitData->stations];
  double vDraws[profitData->product];
  double denominator;
  int format;
  int covarMatrixOffset;
  int offsetSigma = profitData->parameters+profitData->product*profitData->demoCharacteristics;
  double demographics[profitData->demoCharacteristics];

  for(n=0;n<profitData->stations;++n) {
    output[n]=0;
    delta[n]=profitData->q[n]*profitData->arg[0]+profitData->data[n][0]*profitData->arg[1]+
      profitData->arg[2+(int) profitData->data[n][1]]+profitData->data[n][5];
    for(n1=0;n1<profitData->stations;n1++) {
      outputJacob[n][n1]=0;
    }
  }

  for(i=0;i<profitData->N;++i) {
    vectorNormal(seed[0], profitData->product, vDraws);
    /*for(n=0;n<profitData->product;++n) {
      printf("%f\t");
    }
    getchar();*/

    denominator=1;
    for(n=0;n<profitData->stations;++n) {
      format=profitData->data[n][1];

      covarMatrixOffset=profitData->parameters+format*profitData->demoCharacteristics;

//      printf("arg %f\n",profitData->arg[offsetSigma+format]);getchar();
//      printf("vDraws %f\n",vDraws[format]);getchar();
//      printf("delta %f\n",delta[n]);getchar();
//      printf("offset %d\n",offsetSigma+format);getchar();
      nominator[n]=delta[n]+profitData->arg[offsetSigma+format]*vDraws[format];
      if(profitData->simulate) {
        simulateDemographics(demographics);
      
        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*demographics[k];
        }
      } else {
        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*profitData->demographics[i*profitData->demoCharacteristics+k];;
        }
      }

      nominator[n]=exp(nominator[n]);
      denominator+=nominator[n];
    }
    for(n=0;n<profitData->stations;++n) {
      temp[n] = nominator[n]/denominator;
      output[n]+=temp[n];
      for(n1=0;n1<n;n1++) {
        outputJacob[n][n1]-=profitData->arg[0]*temp[n]*temp[n1];
      }
      outputJacob[n][n]+=profitData->arg[0]*temp[n]*(1-temp[n]);
    }
  }

  for(n=0;n<profitData->stations;n++) {
    output[n]/=profitData->N;
//    output[n]*=100;
    for(n1=0;n1<=n;n1++) {
//      outputJacob[n][n1]*=100;
      outputJacob[n][n1]/=profitData->N;
      outputJacob[n1][n]=outputJacob[n][n1];
    }
  }
}
void foc(double *foc) {    
  int i,k,k1;
  double output[profitData->stations];
  double outputJacob[profitData->stations][profitData->stations];
  double aggrQ=0;
  double P;

  marketShareFoc(output, outputJacob);

  // Aggregate output and price 
  for(i=0;i<profitData->stations;i++) {
    aggrQ+=profitData->q[i];
  }
  
  P=(100*profitData->gamma[0]-profitData->gamma[1]*aggrQ);

  // Leaders loop 
  for(i=0;i<profitData->number_of_owners;i++) {
    for(k=profitData->structure[i];k<profitData->structure[i+1];k++) {
      foc[k]=output[k]*P+profitData->epsilon[k];
      for(k1=profitData->structure[i];k1<profitData->structure[i+1];k1++) {
//        if(output[k1]*P+profitData->epsilon[k1]>0) {
          foc[k]+=profitData->q[k1]*(outputJacob[k][k1]*P-output[k1]*profitData->gamma[1]);
//        }
      }
    }
  }
}     
