#include<lu.h>
#include<math.h>
#include<stdio.h>
#include<stdlib.h>

int lu(double *output, int *idx, int length) {
  double sum,temp;
  double pivot;
  int maxRow = 0;
  double vv[length];
  int i,j,k;
  int offset_i,offset_j,offset_k;
  double den;
  double change;

  for (i=0;i<length;i++) {
    double big=0.0;
    for (j=0;j<length;j++) {
        double temp;
        if ((temp=fabs(output[i*length+j])) > big) big=temp;
    }
    if (big == 0.0)  {
      printf("Singular matrix in routine ludcmp\n");
      return 0;
    }
    vv[i]=1.0/big;
  }


  for (j=0; j<length; j++) { /* iteration on columns */
    offset_i = 0;
    for (i=0; i<j; i++) {
      sum=output[offset_i+j];

      offset_k = 0;
      for(k=0;k<i;k++) {
          sum-=output[offset_i+k]*output[offset_k+j];
          offset_k+=length;
      }
      output[offset_i+j]=sum;
      offset_i+=length;
    }
    pivot = 0;
    offset_i=j*length;
    for (i=j;i<length; i++) {
      sum=output[offset_i+j];
      offset_k=0;
      for(k=0;k<j;k++) {
          sum-=output[offset_i+k]*output[offset_k+j];
          offset_k+=length;
      }
      output[offset_i+j]=sum;

      if ( (temp=vv[i]*fabs(sum))>=pivot) {
        pivot = temp;
        maxRow = i;
      }
      offset_i+=length;
    }

    /* remember the permutation */
    idx[j]=maxRow;

    /* pivoting */
    if (maxRow != j) {
      change=output[maxRow];output[maxRow]=output[j];output[maxRow]=change;
      change = vv[maxRow];vv[maxRow]=vv[j];vv[j]=change;
    }

    /* divite by the greatest element */
    offset_i=(j+1)*length;
    offset_j=j*length;
    if (output[offset_j+j]==0) {
        printf("singularity\n");
        output[offset_j+j]=1e-6;
    }

    if(j!=length-1) {
      den = 1/output[offset_j+j];
      for (i=j+1;i<length; i++) {
        output[offset_i+j]*=den;
        offset_i+=length;
      }
    }
  }
  return 1;
}
