/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) Unknown 2008 <przemekj@stanford.edu>
 * 
 * main.cpp is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.cpp is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include<stdlib.h>
#include<stdio.h>
#include<math.h>

#include "cuda_generator.h"
#include "profitGlobals.h"
#include "simulateDemographics.h"

void marketShareFoc(double *output) {
  int i,n,k;
  double temp[profitData->stations];
  double nominator[profitData->stations];
  double delta[profitData->stations];
  double vDraws[profitData->product];
  double denominator;
  int format;
  int covarMatrixOffset;
  int offsetSigma = profitData->parameters+profitData->product*profitData->demoCharacteristics;
  double demographics[profitData->demoCharacteristics];

  for(n=0;n<profitData->stations;++n) {
    output[n]=0;
    delta[n]=profitData->q[n]*profitData->arg[0]+profitData->data[n][0]*profitData->arg[1]+
      profitData->arg[2+(int) profitData->data[n][1]]+profitData->data[n][5];
  }

  for(i=0;i<profitData->N;++i) {
    vectorNormal(seed[0], profitData->product, vDraws);
    /*for(n=0;n<profitData->product;++n) {
      printf("%f\t");
    }
    getchar();*/

    denominator=1;
    for(n=0;n<profitData->stations;++n) {
      format=profitData->data[n][1];

      covarMatrixOffset=profitData->parameters+format*profitData->demoCharacteristics;

      nominator[n]=delta[n]+profitData->arg[offsetSigma+format]*vDraws[format];
      if(profitData->simulate) {
        simulateDemographics(demographics);

        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*demographics[k];
        }
      } else {
        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*profitData->demographics[i*profitData->demoCharacteristics+k];
        }
      }
      nominator[n]=exp(nominator[n]);
      denominator+=nominator[n];
    }
    for(n=0;n<profitData->stations;++n) {
      temp[n] = nominator[n]/denominator;
      output[n]+=temp[n];
    }
  }

  for(n=0;n<profitData->stations;n++) {
//    output[n]*=100;
    output[n]/=profitData->N;
  }
}
void constraint(double *profit) {
   int i,k;
   double P[profitData->stations];
   double output[profitData->stations];

   marketShareFoc(output);

   // Aggregate output and price 
   for(i=0;i<profitData->stations;i++) {
     P[i]=profitData->gamma[0]-profitData->gamma[1]*profitData->q[i];
   }
   // Leaders loop 
   profit[0]=0;
   for(i=0;i<profitData->number_of_owners;i++) {
     for(k=profitData->structure[i];k<profitData->structure[i+1];k++) {
       if(output[k]*P[k]+profitData->epsilon[k]>0) {
         profit[0]+=(output[k]*P[k]+profitData->epsilon[k])*profitData->q[k];
       }
     }
   }
}     
