/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) Unknown 2008 <przemekj@stanford.edu>
 * 
 * main.cpp is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.cpp is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include<newt.h>
#include<solve.h>
#include<foc.h>
#include<focDer.h>

void lnsrch(int n, double *xold, float fold, double *g, double *p,  
   double *x, double *f, double stpmax, int *check) {

  int i;
  double a,alam,alam2,alamin,b,disc,f2,rhs1,rhs2,slope,sum,temp,
      test,tmplam;
  *check=0;
  for (sum=0.0,i=0;i<n;i++) sum += p[i]*p[i];
  sum=sqrt(sum);
  if (sum > stpmax) //Scale if attempted step is too big.
    for (i=0;i<n;i++) p[i] *= stpmax/sum;
  for (slope=0.0,i=0;i<n;i++)
    slope += g[i]*p[i];
  if (slope >= 0.0) {
    slope = -1e-4;
  }
  test=0.0;
  for (i=0;i<n;i++) {
      temp=fabs(p[i])/FMAX(fabs(xold[i]),1.0);
      if (temp > test) test=temp;
  }
  alamin=TOLX/test; //Always try full Newton step first.
  alam=1.0; //Start of iteration loop.
  for (;;) {
      for (i=0;i<n;i++) x[i]=xold[i]+alam*p[i];
      *f=fmin2(x,n); 
      if (alam < alamin) { 
          for (i=0;i<n;i++) x[i]=xold[i];
          *check=1;
          return;
      } else if (*f <= fold+ALF*alam*slope) return;
      else {
          if (alam == 1.0)
              tmplam = -slope/(2.0*(*f-fold-slope));
          else {
              rhs1 = *f-fold-alam*slope;
              rhs2=f2-fold-alam2*slope;
              a=(rhs1/(alam*alam)-rhs2/(alam2*alam2))/(alam-alam2);
              b=(-alam2*rhs1/(alam*alam)+alam*rhs2/(alam2*alam2))/(alam-alam2);
              if (a == 0.0) tmplam = -slope/(2.0*b);
              else {
                  disc=b*b-3.0*a*slope;
                  if (disc < 0.0) tmplam=0.5*alam;
                  else if (b <= 0.0) tmplam=(-b+sqrt(disc))/(3.0*a);
                  else tmplam=-slope/(b+sqrt(disc));
              }
              if (tmplam > 0.5*alam)
                  tmplam=0.5*alam;
          }
      }
      alam2=alam;
      f2 = *f;
      alam=FMAX(tmplam,0.1*alam);
  }
}

int newt(double *x, int n) {
  int i,its,j,k,check;
  double den,f,fold,stpmax,sum,temp,test;

  double fjac[n*n];
  double g[n];
  double p[n];
  double xold[n];

  fvec = (double *) malloc(sizeof(double)*n);

  f=fmin2(x,n);
  test=0.0;

  for (i=0;i<n;i++)
      if (fabs(fvec[i]) > test) test=fabs(fvec[i]);
  if (test < 0.01*TOLF) {
      check=0;
      free(fvec);
      return 1;
  }
  for (sum=0.0,i=0;i<n;i++) sum += x[i]*x[i];
  stpmax=STPMX*FMAX(sqrt(sum),(float)n);

  for (its=0;its<MAXITS;its++) {
    focDer(x,fjac); // put numerical jacobian here
    k=0;
    for (i=0;i<n;i++) {
       for (sum=0.0,j=0;j<n;j++) {
         sum += fjac[k]*fvec[j];
         k++;
       }
       g[i]=sum;
    }

    for (i=0;i<n;i++) xold[i]=x[i];
    fold=f;
    for (i=0;i<n;i++) p[i] = -fvec[i];
    if(!solve(fjac,p,n)) {
      printf("Singular jacobian\n");
      return 0;
    }
    lnsrch(n,xold,fold,g,p,x,&f,stpmax,&check);

    test=0.0;

    for (i=0;i<n;i++) {
      if (fabs(fvec[i]) > test) test=fabs(fvec[i]);
      if (test < TOLF) {
        check=0;
        free(fvec);
        return 1;
      }
    }

    if (check) {
      test=0.0;
      den=FMAX(f,0.5*n);
      for (i=0;i<n;i++) {
        temp=fabs(g[i])*FMAX(fabs(x[i]),1.0)/den;
        if (temp > test) test=temp;
      }
      check=(test < TOLMIN ? 1 : 0);
      free(fvec);
      return 1;
    }
    test=0.0;
    for (i=0;i<n;i++) {
      temp=(fabs(x[i]-xold[i]))/FMAX(fabs(x[i]),1.0);
      if (temp > test) test=temp;
    }
    if (test < TOLX) {
      free(fvec);
      return 1;
    }
  }
  printf("Max iterations\n");
  return 0;
}


double fmin2(double *x, int size) {
  double output = 0;
  int i;
  foc(x,fvec);

  for(i=0;i<size;i++) {
    output += (fvec[i])*(fvec[i]);
  }
  return 0.5*output;
}
