/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) Unknown 2008 <przemekj@stanford.edu>
 * 
 * main.cpp is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.cpp is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include<foc.h>
#include<focDer.h>
#include<newt.h>

#include "cuda_generator.h"
#include "profitGlobals.h"
#include "simulateDemographics.h"

void marketShare(double *output) {
  int i,n,k;
  double temp[profitData->stations];
  double nominator[profitData->stations];
  double delta[profitData->stations];
  double vDraws[profitData->random_effects];
  double denominator,re;
  int format;
  int covarMatrixOffset;
  int offsetSigma = profitData->parameters+profitData->product*profitData->demoCharacteristics;
  double demographics[profitData->demoCharacteristics];

  for(n=0;n<profitData->stations;++n) {
    output[n]=0;
    delta[n]=profitData->data[n][0]*profitData->arg[1]+
      profitData->arg[2+(int) profitData->data[n][1]]+profitData->data[n][5];
  }

  for(i=0;i<profitData->N;++i) {
    vectorNormal(seed[0], profitData->random_effects, vDraws);
    /*for(n=0;n<profitData->product;++n) {
      printf("%f\t");
    }
    getchar();*/

    denominator=1;
    for(n=0;n<profitData->stations;++n) {
      re=profitData->arg[0]+profitData->arg[offsetSigma+profitData->product]*vDraws[profitData->product];

      format=profitData->data[n][1];

      covarMatrixOffset=profitData->parameters+format*profitData->demoCharacteristics;

      nominator[n]=profitData->arg[0]*re+delta[n]+profitData->arg[offsetSigma+format]*vDraws[format];
      if(profitData->simulate) {
        simulateDemographics(demographics);

        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*demographics[k];
        }
      } else {
        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*profitData->demographics[i*profitData->demoCharacteristics+k];;
        }
      }
      nominator[n]=exp(nominator[n]);
      denominator+=nominator[n];
    }
    for(n=0;n<profitData->stations;++n) {
      temp[n] = nominator[n]/denominator;
      output[n]+=temp[n];
    }
  }

  for(n=0;n<profitData->stations;n++) {
//    output[n]*=100;
    output[n]/=profitData->N;
  }
}
void profit_newton(double *profit, double *profit_station, double *owner_shares, double *output) {    
   int i,k;
   int check;
   double P[profitData->stations];
   double owner_shares_local[profitData->number_of_owners];
   double profit_local[profitData->number_of_owners];
   double f1[profitData->stations];
   double f2[profitData->stations];
   double fd[profitData->stations*profitData->stations];

   // Check derivatives
/*   
   focDer(profitData->q, fd);
   for(i=0;i<profitData->stations;i++) {
      profitData->q[i]-=1e-6;
      foc(profitData->q, f2);
      profitData->q[i]+=2*1e-6;
      foc(profitData->q, f1);
      profitData->q[i]-=1e-6;
      for(k=0;k<profitData->stations;k++) {
        printf("%f\t%f\t%f\n",fd[k*profitData->stations+i],
            (f1[k]-f2[k])*0.5*1e6, fd[k*profitData->stations+i]-(f1[k]-f2[k])*0.5*1e6);
      }
      printf("\n\n");
      getchar();
    }
*/
   // First solve FOCs
   check=newt(profitData->q, profitData->stations);

   foc(profitData->q, f1);
   for(k=0;k<profitData->stations;k++) {
     printf("foc: %f %f\n",100*f1[k],0.5*profitData->q[k]*profitData->q[k]);
   }
   getchar();

   for(i=0;i<profitData->stations;++i) {
     profitData->q[i]=0.5*profitData->q[i]*profitData->q[i];
   }

   for(i=0;i<profitData->stations;i++) {
     P[i]=profitData->gamma[0]+profitData->Gamma[i][0]*profitData->q[i];
     for(k=1;k<profitData->stations;k++) {
       P[i]+=profitData->Gamma[i][k]*profitData->q[k];
     }
   }

   marketShare(output);

   // Leaders loop 
   for(i=0;i<profitData->number_of_owners;i++) {
     profit_local[i]=0; 
     owner_shares_local[i]=0;
     for(k=profitData->structure[i];k<profitData->structure[i+1];k++) {
       profit_station[k]=(output[k]*P[k]+profitData->epsilon[k])*profitData->q[k];
       profit_local[i]+=profit_station[k];
       owner_shares_local[i]+=output[k];
     }
   }
   for(i=0;i<profitData->number_of_owners;i++) {
     for(k=profitData->structure[i];k<profitData->structure[i+1];k++) {
       owner_shares[k]=owner_shares_local[i];
       profit[k]=profit_local[i];
     }
   }
}     
