#ifndef PROFITGLOBALS_H__

#define PROFITGLOBALS_H__

#include<cuda_generator.h>

typedef struct {
  int stations;            /* Number of stations */
  int number_of_owners;    /* Number of owners */
  int *structure;          /* Ownership structure */
  double **data;           /* Data */
  double gamma[2];         /* Gamma */
  double *demographics;   /* Demographic draws */
  double *arg;             /* BLP parameters */
  int N;                   /* Number of draws per market */
  int product;             /* Number of formats */
  int demoCharacteristics; /* Number of demo characteristics */
  int parameters;          /* Number of parameters (mean BLP) */
  int allParams;           /* Total number of parameters (total BLP) */
  double *q;               /* Ad quantities */
  int random_effects;      /* number of randomeffects */
  double *epsilon;
  int dataLineSize;
  int demoLineSize;
  int simulate;
  int owner;
  double* qOther;
  double **Gamma;
} profitStructure;

profitStructure *profitData;

seedStruct *seed;
long *mySeed;

#endif
