#include<stdio.h>
#include<solve.h>
#include<lu.h>

int solve(double *data, double *b, int length) {
  int idx[length];
  int offset_i,i,j;
  double sum;
  double temp;
  int index;

  /* perform LU decomposition */
  if(!lu(data,idx,length)) {
    printf("LU decomposition failed in the linear solver routine\n");
    return 0;
  } else {
    offset_i=0;
    for (i=0;i<length;i++) {
      if ((index=(int) (idx[i]))!=i) {
        temp=b[i];b[i]=b[index];b[index]=temp;
      }
      sum=b[i];
      for(j=0;j<=i-1;j++)
        sum-=data[offset_i+j]*b[j];
      b[i]=sum;
      offset_i+=length;
    }
  }
  offset_i = (length-1)*length;
  for (i=length-1;i>=0;i--) {
    sum=b[i];
    for (j=i+1;j<length;j++) {
      sum -= data[offset_i+j]*b[j];
    }
    if((temp=data[offset_i+i])==0) {
      printf("Backward substitution in linear solver failed\n");
      temp = 1e-5;
    }
    b[i]=sum/temp;
    offset_i-=length;
  }
  return 1;
}
