#ifndef CUDA_GENERATOR_H__
#define CUDA_GENERATOR_H__

#include<setup.h>

#define H   32768               /* = 2^15 : use in MultModM.           */

#define PI 3.141592653589793

typedef long seedStruct[4];


void createGenerators(int n, long sd[4], seedStruct *g);
void createGeneratorsDefault(int n, seedStruct *g);
void createGeneratorsSaved(int n, F_TYPE *init, seedStruct *g);
void vectorNormalVar(long *g, int n, F_TYPE *output, F_TYPE var);

F_TYPE nextUniform(long *g);
F_TYPE nextNormal(long *g);
void vectorNormal(long *g, int n, F_TYPE *output);
#endif
