/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) Unknown 2008 <przemekj@stanford.edu>
 * 
 * main.cpp is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.cpp is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include<stdlib.h>
#include<stdio.h>
#include<math.h>

#include "IpStdCInterface.h"
#include "cuda_generator.h"
#include "profitGlobals.h"
#include "simulateDemographics.h"
#include "solve.h"
#include "focDer.h"

void marketShare(double *output) {
  int i,n,k;
  double temp[profitData->stations];
  double nominator[profitData->stations];
  double delta[profitData->stations];
  double vDraws[profitData->random_effects];
  double denominator,re;
  int format;
  int covarMatrixOffset;
  int offsetSigma = profitData->parameters+profitData->product*profitData->demoCharacteristics;
  double demographics[profitData->demoCharacteristics];

  for(n=0;n<profitData->stations;++n) {
    output[n]=0;
    delta[n]=profitData->data[n][0]*profitData->arg[1]+
      profitData->arg[2+(int) profitData->data[n][1]]+profitData->data[n][5]+profitData->data[n][7]*profitData->arg[profitData->power];
  }

  for(i=0;i<profitData->N;++i) {
    vectorNormal(seed[0], profitData->random_effects, vDraws);
    /*for(n=0;n<profitData->product;++n) {
      printf("%f\t");
    }
    getchar();*/

    denominator=profitData->dummy;
    for(n=0;n<profitData->stations;++n) {
      re=profitData->arg[0]+profitData->arg[offsetSigma+profitData->product]*vDraws[profitData->product];

      format=profitData->data[n][1];

      covarMatrixOffset=profitData->parameters+format*profitData->demoCharacteristics;

      nominator[n]=profitData->q[n]*re+delta[n]+profitData->arg[offsetSigma+format]*vDraws[format];
      if(profitData->simulate) {
        simulateDemographics(demographics);

        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*demographics[k];
        }
      } else {
        for(k=0;k<profitData->demoCharacteristics;++k) {
          nominator[n]+=profitData->arg[covarMatrixOffset+k]*profitData->demographics[i*profitData->demoCharacteristics+k];;
        }
      }
      nominator[n]=exp(nominator[n]);
      denominator+=nominator[n];
    }
    for(n=0;n<profitData->stations;++n) {
      temp[n] = nominator[n]/denominator;
      output[n]+=temp[n];
    }
  }

  for(n=0;n<profitData->stations;n++) {
//    output[n]*=100;
    output[n]/=profitData->N;
  }
}
void profit(double *profit, double *profit_station, double *owner_shares, double *output) {    
   int i,k;
   int check;
   double P[profitData->stations];
   double owner_shares_local[profitData->number_of_owners];
   double profit_local[profitData->number_of_owners];
   double temp;

   
   /* Allocate for globals */
/*   globalData *data = malloc(sizeof(globalData));
   data->foc_out=malloc(sizeof(double)*profitData->stations);
   data->jac_out=malloc(sizeof(double)*profitData->stations*profitData->stations);
   double jac_temp[profitData->stations*profitData->stations];
   double f_temp[profitData->stations*profitData->stations];
   focDer(profitData->q, data);

   for(i=0;i<profitData->stations;i++) {
     printf("%d: %f\n",i,data->foc_out[i]);
   }
   getchar();

   for(i=0;i<profitData->stations*profitData->stations;i++) {
     jac_temp[i]=data->jac_out[i];
   }
   for(i=0;i<profitData->stations;i++) {
     f_temp[i]=data->foc_out[i];
   }
   profitData->q[0]+=1e-6;
   focDer(profitData->q, data);
   for(i=0;i<profitData->stations;i++) {
     printf("%d: %f %f %f\n",i,1e6*(data->foc_out[i]-f_temp[i]),jac_temp[i*profitData->stations],
         1e6*(data->foc_out[i]-f_temp[i])-jac_temp[i*profitData->stations]);
   }
   getchar()*/

   if(profitData->solve) {
     solve(profitData->q);
   }

   createGenerators(1,mySeed,seed);

   for(i=0;i<profitData->stations;i++) {
     P[i]=profitData->gamma[0]+profitData->Gamma[i][0]*profitData->q[i];
     for(k=1;k<profitData->stations;k++) {
       P[i]+=profitData->Gamma[i][k]*profitData->q[k];
     }
   }

   marketShare(output);

   // Leaders loop 
   for(i=0;i<profitData->number_of_owners;i++) {
     profit_local[i]=0; 
     owner_shares_local[i]=0;
     for(k=profitData->structure[i];k<profitData->structure[i+1];k++) {
       temp = (output[k]*P[k]+profitData->epsilon[k])*profitData->q[k];
       if(temp>0) {
         profit_station[k]=temp;
       } else {
         profit_station[k]=0;
       }
       profit_local[i]+=profit_station[k];
       owner_shares_local[i]+=output[k];
     }
   }
   for(i=0;i<profitData->number_of_owners;i++) {
     for(k=profitData->structure[i];k<profitData->structure[i+1];k++) {
       owner_shares[k]=owner_shares_local[i];
       profit[k]=profit_local[i];
     }
   }
   /*
   focDer(profitData->q, data);
   for(i=0;i<profitData->stations;i++) {
     printf("%d: %f %f %f %f %f\n",i,data->foc_out[i],profitData->q[i],profit_station[i],profitData->epsilon[i],P[i]);
   }
   getchar();*/
}     
