#include <string.h>
#include "mex.h"
#include <stdio.h>
#include <stdlib.h>
#include "mat.h"

#include "cuda_generator.h"
#include "profitGlobals.h"
#include "profit.h"
#include "IpStdCInterface.h"

int solve(Number *q);

mxArray *readvar(MATFile *mfp, const char *var_name);

static profitStructure *profitDataMex;
#define NAME_LENGTH 30
/*#define COUT_DEBUG*/

int main(int argc, char *argv[]) {
  int i,j,n,d,stations,m,r1,o;
  char ar;
  mxArray *foc_out, *owner_shares, *station_shares, *profit_station, *q, *seedOut;
  double *foc_outPr, *owner_sharesPr, *station_sharesPr, *profit_stationPr, *qPr, *seedOutPr;
  double *indexInit, *demographicsInit, *lagInit, *instrumentsInit;
  double *dataInit;
  double *mySeedInit;
  double rho;
  double aggrQ;
  double *omega;
  int market, date, date_market, data_size, lagSize;

  if(argc<3) {
    printf("The executable needs two arguments: output and input .mat file names\n");
    exit(1);
  }

  char filename[NAME_LENGTH];
  MATFile *mfp;

  strncpy(filename, argv[1], NAME_LENGTH);

  if ((mfp = matOpen(filename, "r")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }
/*
  mxArray *var = readvar(mfp, "filename");

  char *file=new char[mxGetN(var)+1];
  mxGetString(var, file, mxGetN(var)+1);

  myfile.open(file);
*/
  profitDataMex = (profitStructure *) mxMalloc(sizeof(profitStructure));
  
  mxArray *dataStr = readvar(mfp,"profitData");

  profitDataMex->stations=(int) mxGetPr(mxGetField(dataStr, 0, "stations"))[0];
  profitDataMex->demoCharacteristics=(int) mxGetPr(mxGetField(dataStr, 0, "demoCharacteristics"))[0];
  profitDataMex->parameters=(int) mxGetPr(mxGetField(dataStr, 0, "parameters"))[0];
  profitDataMex->N=(int) mxGetPr(mxGetField(dataStr, 0, "N"))[0];
  profitDataMex->random_effects=(int) mxGetPr(mxGetField(dataStr, 0, "random_effects"))[0];
  profitDataMex->product=(int) mxGetPr(mxGetField(dataStr, 0, "product"))[0];
  profitDataMex->power=profitDataMex->parameters+profitDataMex->product*(profitDataMex->demoCharacteristics)+profitDataMex->random_effects;
  int power = (int) mxGetPr(mxGetField(dataStr, 0, "extra_parameters"))[0];
  profitDataMex->year_dummies=profitDataMex->parameters+profitDataMex->product*(profitDataMex->demoCharacteristics)+profitDataMex->random_effects+
    power;
  profitDataMex->dummy=mxGetPr(mxGetField(dataStr, 0, "dummy"))[0];
  profitDataMex->allParams=profitDataMex->parameters+profitDataMex->product*profitDataMex->demoCharacteristics+profitDataMex->random_effects+power+profitDataMex->year_dummies;
  profitDataMex->dataLineSize=(int) mxGetPr(mxGetField(dataStr, 0, "dataLineSize"))[0];;
  profitDataMex->simulate=(int) mxGetPr(mxGetField(dataStr, 0, "simulate"))[0];
  profitDataMex->solve=(int) mxGetPr(mxGetField(dataStr, 0, "solve"))[0];

  stations = profitDataMex->stations;

  dataInit = mxGetPr(mxGetField(dataStr, 0, "data"));
  profitDataMex->data = (F_TYPE **) mxMalloc(stations*sizeof(F_TYPE *));
  m=0;
  for(i=0;i<stations;++i) {
    profitDataMex->data[i] = (F_TYPE *) mxMalloc(profitDataMex->dataLineSize*sizeof(F_TYPE));
    mexMakeMemoryPersistent(profitDataMex->data[i]);
    for(j=0;j<profitDataMex->dataLineSize;++j) {
      profitDataMex->data[i][j]=dataInit[m];
      m++;
    }
  }

  profitDataMex->gamma[0]=mxGetPr(mxGetField(dataStr, 0, "gamma"))[0];
  profitDataMex->gamma[1]=mxGetPr(mxGetField(dataStr, 0, "gamma"))[1];
    
  /* count owners */
  o=profitDataMex->data[0][2];
  profitDataMex->number_of_owners=1;
  for(j=0;j<stations;++j) {
    if(profitDataMex->data[j][2]!=o) {
      profitDataMex->number_of_owners++;
      o=profitDataMex->data[j][2];
    }
  }

  /* create structure vector */
  profitDataMex->structure = (int *) mxMalloc((profitDataMex->number_of_owners+1)*sizeof(int));
  profitDataMex->structure[0]=0;
  o=profitDataMex->data[0][2];
  r1=0;
  for(j=0;j<stations;++j) {
    if(profitDataMex->data[j][2]!=o) {
      r1++;
      profitDataMex->structure[r1]=j;
      o=profitDataMex->data[j][2];
    }
  }
 
  profitDataMex->structure[profitDataMex->number_of_owners]=stations;

  profitDataMex->q = (double *) mxMalloc(stations*sizeof(double));
  dataInit = mxGetPr(mxGetField(dataStr, 0, "q"));
  for(i=0;i<stations;i++) {
    profitDataMex->q[i]=dataInit[i];
  }

  profitDataMex->arg = mxGetPr(mxGetField(dataStr, 0, "arg"));
  profitDataMex->epsilon = mxGetPr(mxGetField(dataStr, 0, "epsilon"));
  profitDataMex->demographics = mxGetPr(mxGetField(dataStr, 0, "demographics"));

  omega = mxGetPr(mxGetField(dataStr, 0, "omega"));

  profitDataMex->Gamma=(double **) mxMalloc(profitDataMex->stations*sizeof(double *));
  for(i=0;i<profitDataMex->stations;i++) {
    profitDataMex->Gamma[i]=(double *) mxMalloc(profitDataMex->stations*sizeof(double));
    for(j=0;j<profitDataMex->stations;j++) {
      profitDataMex->Gamma[i][j]=-profitDataMex->gamma[1]*
        omega[(int) (profitDataMex->data[i][1]+profitDataMex->data[j][1]*8)];
    }
  }

  profitData = profitDataMex;

  seed = (seedStruct *) mxMalloc(1*sizeof(seedStruct));
  mySeedInit = mxGetPr(readvar(mfp, "mySeed"));
  mySeed = (long *) mxMalloc(4*sizeof(long));
  mySeed[0] = (long) mySeedInit[0];
  mySeed[1] = (long) mySeedInit[1];
  mySeed[2] = (long) mySeedInit[2];
  mySeed[3] = (long) mySeedInit[3];

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE);
  }

  createGenerators(1,mySeed,seed);

  foc_out = mxCreateDoubleMatrix(stations,1,mxREAL);
  foc_outPr = mxGetPr(foc_out);

  owner_shares = mxCreateDoubleMatrix(stations,1,mxREAL);
  owner_sharesPr = mxGetPr(owner_shares);

  station_shares = mxCreateDoubleMatrix(stations,1,mxREAL);
  station_sharesPr = mxGetPr(station_shares);

  seedOut = mxCreateDoubleMatrix(4,1,mxREAL);
  seedOutPr = mxGetPr(seedOut);

  profit_station = mxCreateDoubleMatrix(stations,1,mxREAL);
  profit_stationPr = mxGetPr(profit_station);

  q = mxCreateDoubleMatrix(stations,1,mxREAL);   
  qPr = mxGetPr(q);
  
  profit(foc_outPr, profit_stationPr, owner_sharesPr, station_sharesPr);
  for(i=0;i<profitData->stations;i++) {
    qPr[i]=profitData->q[i];
  }

  /* Spit out the seed */
  seedOutPr[0] = seed[0][0];
  seedOutPr[1] = seed[0][1];
  seedOutPr[2] = seed[0][2];
  seedOutPr[3] = seed[0][3];

  strncpy(filename, argv[2], NAME_LENGTH);

  if ((mfp = matOpen(filename, "w")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }

  matPutVariable(mfp, "profit", foc_out);
  matPutVariable(mfp, "owner_shares", owner_shares);
  matPutVariable(mfp, "station_shares", station_shares);
  matPutVariable(mfp, "seedOut", seedOut);
  matPutVariable(mfp, "profit_station", profit_station);
  matPutVariable(mfp, "q", q);

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE); 
  }
}

mxArray *readvar(MATFile *mfp, const char *var_name) {
    mxArray *array_ptr;
    int *from, *to;

    if ((array_ptr = matGetVariable(mfp, var_name)) == NULL) {
        printf("Cannot read matlab variable %s", var_name);
        exit(1);
    }
    if ((mxGetNumberOfElements(array_ptr) == 1) && mxIsNumeric(array_ptr)) {
      #ifdef COUT_DEBUG
        printf("Reading matlab variable %s = %d\n",var_name, mxGetScalar(array_ptr));
      #endif
    } else {
        #ifdef COUT_DEBUG
          printf("Reading matlab variable %d (",var_name);
        #endif
        from = (int *) mxGetDimensions(array_ptr);
        to = from+mxGetNumberOfDimensions(array_ptr)-1;
        for (; from<to; from++) {
        #ifdef COUT_DEBUG
          printf("%dx",*from);
        #endif
        }
        #ifdef COUT_DEBUG
          printf("%d)\n",*from);
        #endif
    }

    return array_ptr;
}
