#include <string.h>
#include "mex.h"
#include <stdio.h>
#include <stdlib.h>

#include "cuda_generator.h"
#include "profitGlobals.h"
#include "profit.h"

static profitStructure *profitDataMex;

void mexFunction(int nlhs, mxArray *plhs[ ],int nrhs, const mxArray *prhs[ ])  {
  int i,j,n,d,stations,m,r1,o;
  char ar;
  double *foc_out, *owner_shares, *station_shares, *profit_station;
  double *indexInit, *demographicsInit, *lagInit, *instrumentsInit;
  double *dataInit;
  double *mySeedInit = mxGetPr(prhs[1]);
  double rho;
  double aggrQ;
  double *omega, *q;
  int market, date, date_market, data_size, lagSize;

  profitDataMex = (profitStructure *) mxMalloc(sizeof(profitStructure));

  profitDataMex->stations=(int) mxGetPr(mxGetField(prhs[0], 0, "stations"))[0];
  profitDataMex->demoCharacteristics=(int) mxGetPr(mxGetField(prhs[0], 0, "demoCharacteristics"))[0];
  profitDataMex->parameters=(int) mxGetPr(mxGetField(prhs[0], 0, "parameters"))[0];
  profitDataMex->N=(int) mxGetPr(mxGetField(prhs[0], 0, "N"))[0];
  profitDataMex->random_effects=(int) mxGetPr(mxGetField(prhs[0], 0, "random_effects"))[0];
  profitDataMex->product=(int) mxGetPr(mxGetField(prhs[0], 0, "product"))[0];
  profitDataMex->power=profitDataMex->parameters+profitDataMex->product*(profitDataMex->demoCharacteristics)+profitDataMex->random_effects;
  int power = (int) mxGetPr(mxGetField(prhs[0], 0, "extra_parameters"))[0];
  profitDataMex->year_dummies=profitDataMex->parameters+profitDataMex->product*(profitDataMex->demoCharacteristics)+profitDataMex->random_effects+
    power;
  profitDataMex->dummy=mxGetPr(mxGetField(prhs[0], 0, "dummy"))[0];
  profitDataMex->allParams=profitDataMex->parameters+profitDataMex->product*profitDataMex->demoCharacteristics+profitDataMex->random_effects+power+profitDataMex->year_dummies;
  profitDataMex->dataLineSize=(int) mxGetPr(mxGetField(prhs[0], 0, "dataLineSize"))[0];;
  profitDataMex->simulate=(int) mxGetPr(mxGetField(prhs[0], 0, "simulate"))[0];
  profitDataMex->solve=(int) mxGetPr(mxGetField(prhs[0], 0, "solve"))[0];

  stations = profitDataMex->stations;

  dataInit = mxGetPr(mxGetField(prhs[0], 0, "data"));
  profitDataMex->data = (F_TYPE **) mxMalloc(stations*sizeof(F_TYPE *));
  m=0;
  for(i=0;i<stations;++i) {
    profitDataMex->data[i] = (F_TYPE *) mxMalloc(profitDataMex->dataLineSize*sizeof(F_TYPE));
    mexMakeMemoryPersistent(profitDataMex->data[i]);
    for(j=0;j<profitDataMex->dataLineSize;++j) {
      profitDataMex->data[i][j]=dataInit[m];
      m++;
    }
  }

  profitDataMex->gamma[0]=mxGetPr(mxGetField(prhs[0], 0, "gamma"))[0];
  profitDataMex->gamma[1]=mxGetPr(mxGetField(prhs[0], 0, "gamma"))[1];
    
  /* count owners */
  o=profitDataMex->data[0][2];
  profitDataMex->number_of_owners=1;
  for(j=0;j<stations;++j) {
    if(profitDataMex->data[j][2]!=o) {
      profitDataMex->number_of_owners++;
      o=profitDataMex->data[j][2];
    }
  }

  /* create structure vector */
  profitDataMex->structure = (int *) mxMalloc((profitDataMex->number_of_owners+1)*sizeof(int));
  profitDataMex->structure[0]=0;
  o=profitDataMex->data[0][2];
  r1=0;
  for(j=0;j<stations;++j) {
    if(profitDataMex->data[j][2]!=o) {
      r1++;
      profitDataMex->structure[r1]=j;
      o=profitDataMex->data[j][2];
    }
  }
 
  profitDataMex->structure[profitDataMex->number_of_owners]=stations;

  profitDataMex->q = (double *) mxMalloc(stations*sizeof(double));
  dataInit = mxGetPr(mxGetField(prhs[0], 0, "q"));
  for(i=0;i<stations;i++) {
    profitDataMex->q[i]=dataInit[i];
  }

/*  profitDataMex->q = mxGetPr(mxGetField(prhs[0], 0, "q"));*/
  profitDataMex->arg = mxGetPr(mxGetField(prhs[0], 0, "arg"));
  profitDataMex->epsilon = mxGetPr(mxGetField(prhs[0], 0, "epsilon"));
  profitDataMex->demographics = mxGetPr(mxGetField(prhs[0], 0, "demographics"));

  omega = mxGetPr(mxGetField(prhs[0], 0, "omega"));

  profitDataMex->Gamma=(double **) mxMalloc(profitDataMex->stations*sizeof(double *));
  for(i=0;i<profitDataMex->stations;i++) {
    profitDataMex->Gamma[i]=(double *) mxMalloc(profitDataMex->stations*sizeof(double));
    for(j=0;j<profitDataMex->stations;j++) {
      profitDataMex->Gamma[i][j]=-profitDataMex->gamma[1]*
        omega[(int) (profitDataMex->data[i][1]+profitDataMex->data[j][1]*8)];
    }
  }

  profitData = profitDataMex;

  seed = (seedStruct *) mxMalloc(1*sizeof(seedStruct));

  mySeed = (long *) mxMalloc(4*sizeof(long));
  mySeed[0] = (long) mySeedInit[0];
  mySeed[1] = (long) mySeedInit[1];
  mySeed[2] = (long) mySeedInit[2];
  mySeed[3] = (long) mySeedInit[3];

  createGenerators(1,mySeed,seed);

  plhs[0] = mxCreateDoubleMatrix(stations,1,mxREAL);
  foc_out = mxGetPr(plhs[0]);

  plhs[1] = mxCreateDoubleMatrix(stations,1,mxREAL);
  owner_shares = mxGetPr(plhs[1]);

  plhs[2] = mxCreateDoubleMatrix(stations,1,mxREAL);
  station_shares = mxGetPr(plhs[2]);

  plhs[3] = mxCreateDoubleMatrix(4,1,mxREAL);
  mySeedInit = mxGetPr(plhs[3]);

  if(nlhs>=5) {
    plhs[4] = mxCreateDoubleMatrix(stations,1,mxREAL);
    profit_station = mxGetPr(plhs[4]);
  } else {
    profit_station = (double *) mxMalloc(stations*sizeof(double));
  }
  if(nlhs>=6) {
    plhs[5] = mxCreateDoubleMatrix(stations,1,mxREAL);
    q = mxGetPr(plhs[5]);
  }
  printf("WTF!\n");
  solve(profitDataMex->q);
  getchar();

  profit(foc_out, profit_station, owner_shares, station_shares);
  for(i=0;i<profitData->stations;i++) {
    q[i]=profitData->q[i];
  }

  /* Spit out the seed */
  mySeedInit[0] = seed[0][0];
  mySeedInit[1] = seed[0][1];
  mySeedInit[2] = seed[0][2];
  mySeedInit[3] = seed[0][3];
}
