#include "cuda_generator.h"
#include "profitGlobals.h"
#include "simulateDemographics.h"
void simulateDemographics(double *simulations) {
  double a,cumulative;
  int j;

  /* Age 0-6 */
  a = nextUniform(profitSeed[0]);
  cumulative = 0;
  simulations[0]=7;
  for(j=0;j<7;j++) {
    cumulative+=profitData->demographics[j];
    if(a<=cumulative) {
      simulations[0]=j;
      break;
    }
  }

  /* Sex 7 */
  if(nextUniform(profitSeed[0])<=profitData->demographics[7]) {
    simulations[1]=1;
  } else {
    simulations[1]=0;
  }

  /* Education 8-10 */
  a = nextUniform(profitSeed[0]);
  cumulative = 0;
  simulations[2]=3;
  for(j=8;j<11;j++) {
    cumulative+=profitData->demographics[j];
    if(a<=cumulative) {
      simulations[2]=j-8;
      break;
    }
  }

  /* Income 11-13 */
  a = nextUniform(profitSeed[0]);
  cumulative = 0;
  simulations[3]=3;
  for(j=11;j<14;j++) {
    cumulative+=profitData->demographics[j];
    if(a<=cumulative) {
      simulations[3]=j-11;
      break;
    }
  }

  /* Blacks 14
     Hispanic 15 */
  for(j=14;j<16;j++) {
    if(nextUniform(profitSeed[0])<=profitData->demographics[j]) {
      simulations[j-10]=1;
    } else {
      simulations[j-10]=0;
    }
  }
}
