#ifndef SIMULATIONS_H__
#define SIMULATIONS_H__

#define T 80

#define NUMBER_OF_GENERATORS 10

#include<cuda_generator.h>

typedef struct {
  double **M;
  double demo[T][16];
  double demo_diff[T][16];
  int stations;
  double beta;
  double price;
  double rho;
  double *variance;
  double variance_nu;
  double *nu;
  double *zeta;
  int bucketSize;
} dataStructure;

seedStruct *seed;

void merge(dataStructure *data, double *beta_m, double beta_fs[][8],
    double *V);

#endif /* SIMULATIONS_H__ */
