/* Copyright (C) 2005, 2006 International Business Machines and others.
 * All Rights Reserved.
 * This code is published under the Common Public License.
 *
 * $Id: hs071_c.c 1324 2008-09-16 14:19:26Z andreasw $
 *
 * Authors:  Carl Laird, Andreas Waechter     IBM    2005-08-17
 */

#include "IpStdCInterface.h"
#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include <focDer.h>
#include <math.h>

/* Function Declarations */
Bool eval_f(Index n, Number* x, Bool new_x,
            Number* obj_value, UserDataPtr user_data);

Bool eval_grad_f(Index n, Number* x, Bool new_x,
                 Number* grad_f, UserDataPtr user_data);

Bool eval_g(Index n, Number* x, Bool new_x,
            Index m, Number* g, UserDataPtr user_data);

Bool eval_jac_g(Index n, Number *x, Bool new_x,
                Index m, Index nele_jac,
                Index *iRow, Index *jCol, Number *values,
                UserDataPtr user_data);

Bool eval_h(Index n, Number *x, Bool new_x, Number obj_factor,
            Index m, Number *lambda, Bool new_lambda,
            Index nele_hess, Index *iRow, Index *jCol,
            Number *values, UserDataPtr user_data);
/*
int main() {
  double q[profitData->stations];
  int i;

  for(i=0;i<profitData->stations;i++) {
    q[i]=1;
  }
  solve(q);
}*/

/* Main Program */
int solve(Number *q) {
  Index n=profitData->stations;        /* number of variables */
  Index m=profitData->stations;        /* number of constraints */
  Number* x_L = NULL;                  /* lower bounds on x */
  Number* x_U = NULL;                  /* upper bounds on x */
  Number* g_L = NULL;                  /* lower bounds on g */
  Number* g_U = NULL;                  /* upper bounds on g */
  IpoptProblem nlp = NULL;             /* IpoptProblem */
  enum ApplicationReturnStatus status; /* Solve return code */
  Number* x = NULL;                    /* starting point and solution vector */
  Number* mult_x_L = NULL;             /* lower bound multipliers
  					  at the solution */
  Number* mult_x_U = NULL;             /* upper bound multipliers
  					  at the solution */
  Number obj;                          /* objective value */
  Index i;                             /* generic counter */

  /* Number of nonzeros in the Jacobian of the constraints */
  Index nele_jac = n*m;
  /* Number of nonzeros in the Hessian of the Lagrangian (lower or
     upper triangual part only) */
  Index nele_hess = 1;
  /* indexing style for matrices */
  Index index_style = 0; /* C-style; start counting of rows and column
  			    indices at 0 */


  globalData *data = malloc(sizeof(globalData));
  data->foc_out=malloc(sizeof(double)*profitData->stations);
  data->jac_out=malloc(sizeof(double)*profitData->stations*profitData->stations);

  /* allocate space for the bounds */
  x_L = (Number*)malloc(sizeof(Number)*n);
  x_U = (Number*)malloc(sizeof(Number)*n);
  /* set the values for the variable bounds */
  for (i=0; i<n; i++) {
    x_L[i] = 0;
    x_U[i] = 3;
  }

  /* allocate space for the bounds */ 
  g_L = (Number*)malloc(sizeof(Number)*m);
  g_U = (Number*)malloc(sizeof(Number)*m);
  /* set the values of the constraint bounds */
  for(i=0;i<m;i++) {
    g_L[i] = 0;
    g_U[i] = 0;
  }

  /* create the IpoptProblem */
  nlp = CreateIpoptProblem(n, x_L, x_U, m, g_L, g_U, nele_jac, nele_hess,
                           index_style, &eval_f, &eval_g, &eval_grad_f,
                           &eval_jac_g, &eval_h);

  /* We can free the memory now - the values for the bounds have been
     copied internally in CreateIpoptProblem */
  free(x_L);
  free(x_U);
  free(g_L);
  free(g_U);

  /* Set some options.  Note the following ones are only examples,
     they might not be suitable for your problem. */
  AddIpoptNumOption(nlp, "tol", 1e-6);
  AddIpoptStrOption(nlp, "mu_strategy", "adaptive");
//  AddIpoptStrOption(nlp, "output_file", "ipopt.out");
  AddIpoptStrOption(nlp, "hessian_approximation","limited-memory");
  AddIpoptIntOption(nlp, "print_level", 0);
//  AddIpoptStrOption(nlp, "derivative_test", "first-order");


  /* allocate space for the initial point and set the values */
  x = (Number*)malloc(sizeof(Number)*n);
  for(i=0;i<n;i++) {
    x[i]=q[i];
  }
  focDer(x,data);
//  for(i=0;i<n;i++) {
//    printf("%f\n",data->foc_out[i]);
//  }
//  getchar();


  /* allocate space to store the bound multipliers at the solution */
  mult_x_L = (Number*)malloc(sizeof(Number)*n);
  mult_x_U = (Number*)malloc(sizeof(Number)*n);
  /* solve the problem */
  status = IpoptSolve(nlp, x, NULL, &obj, NULL, mult_x_L, mult_x_U, (UserDataPtr) data);

  /* free allocated memory */
//  FreeIpoptProblem(nlp);

  if (!((status == Solve_Succeeded) || (status==Solved_To_Acceptable_Level) || (status==Feasible_Point_Found))) {
    focDer(x,data);
    for(i=0;i<n;i++) {
      if(fabs(data->foc_out[i])>1e-6) { // Didn't solve
        if((x[i]<1e-6) && (data->foc_out[i]<1e-6)) { // This is ok
          break;
        }
        if(x[i]>3-1e-6) { // Ok too
          break;
        }
        printf("Problem (q,foc): %f %f\n",x[i],data->foc_out[i]);
      }
    }
  }

  for(i=0;i<n;i++) {
    q[i]=x[i];
  }
  FreeIpoptProblem(nlp);
  
  free(x);
  free(mult_x_L);
  free(mult_x_U);

  free(data->foc_out);
  free(data->jac_out);
  free(data);

  return 0;
}


/* Function Implementations */
Bool eval_f(Index n, Number* x, Bool new_x,
            Number* obj_value, UserDataPtr user_data) {
  assert(n == profitData->stations);

  *obj_value = 1;

  return TRUE;
}

Bool eval_grad_f(Index n, Number* x, Bool new_x,
                 Number* grad_f, UserDataPtr user_data) {
  int i;

  assert(n == profitData->stations);

  for(i=0;i<n;i++)
    grad_f[i] = 0;

  return TRUE;
}

Bool eval_g(Index n, Number* x, Bool new_x,  
    Index m, Number* g, UserDataPtr user_data) {
  int i;
  globalData *data = (globalData *) user_data;

  assert(n == profitData->stations);
  assert(m == profitData->stations);

  if(new_x) {
    focDer(x,data);
  }

  for(i=0;i<n;i++) {
//    g[i] = foc_out[i];
    g[i]=data->foc_out[i];
//    printf("%f, %f\n",x[i], data->foc_out[i]);
  }
//  getchar();

  return TRUE;
}

Bool eval_jac_g(Index n, Number *x, Bool new_x,
                Index m, Index nele_jac,
                Index *iRow, Index *jCol, Number *values,
                UserDataPtr user_data) {
  int i,j,k;
  globalData *data = (globalData *) user_data;

  if (values == NULL) {
    k=0;
    for(i=0;i<n;i++) {
      for(j=0;j<m;j++) {
      /* return the structure of the jacobian */
        iRow[k] = i;
        jCol[k] = j;
        k++;
      }
    }
  }
  else {
    if(new_x) {
      focDer(x,data);
    }
    /* return the values of the jacobian of the constraints */
    k=n*m;
    for(i=0;i<k;i++) {
      values[i] = data->jac_out[i];
//      values[i] = jac_out[i];
    }
  }

  return TRUE;
}

Bool eval_h(Index n, Number *x, Bool new_x, Number obj_factor,
            Index m, Number *lambda, Bool new_lambda,
            Index nele_hess, Index *iRow, Index *jCol,
            Number *values, UserDataPtr user_data) {

  return FALSE;
}
