/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) Unknown 2008 <przemekj@stanford.edu>
 * 
 * main.cpp is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.cpp is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include<stdlib.h>
#include<stdio.h>
#include<math.h>

#include "cuda_generator.h"
#include "profitGlobals.h"

void marketShareFoc(double *output, double outputJacob[][profitData->stations]) {
  int i,n,n1,k;
  double temp[profitData->stations];
  double nominator[profitData->stations];
  double delta[profitData->stations];
  double vDraws[profitData->random_effects];
  double denominator,re;
  int format;
  int covarMatrixOffset;
  int offsetSigma = profitData->parameters+profitData->product*profitData->demoCharacteristics;

  for(n=0;n<profitData->stations;++n) {
    output[n]=0;
    delta[n]=profitData->q[n]*profitData->arg[0]+profitData->data[n][0]*profitData->arg[1]+
      profitData->arg[2+(int) profitData->data[n][1]]+profitData->data[n][5]+profitData->data[n][7]*profitData->arg[profitData->power];
    for(n1=0;n1<profitData->stations;n1++) {
      outputJacob[n][n1]=0;
    }
  }

  for(i=0;i<profitData->N;++i) {
    vectorNormal(seed[0], profitData->random_effects, vDraws);

    denominator=profitData->dummy;
    for(n=0;n<profitData->stations;++n) {
      re = profitData->arg[offsetSigma+profitData->product]*vDraws[profitData->product]*profitData->q[n];

      format=profitData->data[n][1];

      covarMatrixOffset=profitData->parameters+format*profitData->demoCharacteristics;

      nominator[n]=re+delta[n]+profitData->arg[offsetSigma+format]*vDraws[format];
      for(k=0;k<profitData->demoCharacteristics;++k) {
        nominator[n]+=profitData->arg[covarMatrixOffset+k]*profitData->demographics[i*profitData->demoCharacteristics+k];
      }
      nominator[n]=exp(nominator[n]);
      denominator+=nominator[n];
    }
    for(n=0;n<profitData->stations;++n) {
      temp[n] = nominator[n]/denominator;
      output[n]+=temp[n];
      for(n1=0;n1<n;n1++) {
        outputJacob[n][n1]-=(profitData->arg[0]+profitData->arg[offsetSigma+profitData->product]*vDraws[profitData->product])*temp[n]*temp[n1];
      }
      outputJacob[n][n]+=(profitData->arg[0]+profitData->arg[offsetSigma+profitData->product]*vDraws[profitData->product])*temp[n]*(1-temp[n]);
    }
  }

  for(n=0;n<profitData->stations;n++) {
    output[n]/=profitData->N;
//    output[n]*=100;
    for(n1=0;n1<=n;n1++) {
//      outputJacob[n][n1]*=100;
      outputJacob[n][n1]/=profitData->N;
      outputJacob[n1][n]=outputJacob[n][n1];
    }
  }
}
void epsilon(double *foc, double *output) {    
  int i,o,k;
  double outputJacob[profitData->stations][profitData->stations];
  double P[profitData->stations];

  for(i=0;i<profitData->stations;i++) {
    P[i]=profitData->gamma[0]+profitData->Gamma[i][0]*profitData->q[0];
    for(k=1;k<profitData->stations;k++) {
      P[i]+=profitData->Gamma[i][k]*profitData->q[k];
    }
  }

  marketShareFoc(output, outputJacob);

  // Leaders loop
  for(o=0;o<profitData->number_of_owners;o++) {
    for(i=profitData->structure[o];i<profitData->structure[o+1];i++) {
      foc[i]=-output[i]*P[i];
      for(k=profitData->structure[o];k<profitData->structure[o+1];k++) {
        foc[i]-=profitData->q[k]*(profitData->Gamma[k][i]*output[k]+P[k]*outputJacob[k][i]);
      }
    }
  }
}     
