/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) Unknown 2008 <przemekj@stanford.edu>
 * 
 * main.cpp is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.cpp is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include<stdlib.h>
#include<stdio.h>
#include<math.h>

#include "epsilon.h"
#include "solve.h"
#include "setup.h"
#include "cuda_generator.h"
#include "globals.h"

void marketShare(double *q, int stations, double *output, double outputJacob[][stations]) {
  int i,j,n,n1,k;
  double temp[stations];
  double nominator[stations];
  double delta[stations];
  double vDraws[problem->product];
  double denominator;
  int drawsIndex=problem->N*advDem->idx;
  int format;
  int covarMatrixOffset;
  int offsetSigma = problem->parameters+problem->product*problem->demoCharacteristics;
  int offsetXi = problem->allParams;

  for(j=data->index[advDem->idx],n=0;j<data->index[advDem->idx+1];++j,++n) {
    output[n]=0;
    delta[n]=q[n]*advDem->arg[0]+data->data[j][1]*advDem->arg[1]+
      advDem->arg[2+(int) data->data[j][2]]+advDem->arg[offsetXi+j];
    for(n1=0;n1<stations;n1++) {
      outputJacob[n][n1]=0;
    }
  }

  for(i=0;i<problem->N;++i) {
    vectorNormal(seed[0], problem->product, vDraws);

    denominator=1;
    for(j=data->index[advDem->idx],n=0;j<data->index[advDem->idx+1];++j,++n) {
      format=data->data[j][2];

      covarMatrixOffset=problem->parameters+format*problem->demoCharacteristics;

      nominator[n]=delta[n]+advDem->arg[offsetSigma+format]*vDraws[format];

      for(k=0;k<problem->demoCharacteristics;++k) {
        nominator[n]+=advDem->arg[covarMatrixOffset+k]*data->demographics[i+drawsIndex][k];
      }
      nominator[n]=exp(nominator[n]);
      denominator+=nominator[n];
    }
    for(n=0;n<stations;++n) {
      temp[n] = nominator[n]/denominator;
      output[n]+=temp[n];
      for(n1=0;n1<n;n1++) {
        outputJacob[n][n1]-=advDem->arg[0]*temp[n]*temp[n1];
      }
      outputJacob[n][n]+=advDem->arg[0]*temp[n]*(1-temp[n]);
    }
  }

  for(n=0;n<stations;n++) {
    output[n]/=problem->N;
    for(n1=0;n1<=n;n1++) {
      outputJacob[n][n1]/=problem->N;
      outputJacob[n1][n]=outputJacob[n][n1];
    }
  }
}

void epsilon(double *q, double *foc, double *output) {    
   int i,k,k1;
   double outputJacob[advDem->structure[advDem->number_of_owners]][advDem->structure[advDem->number_of_owners]];
   double P, aggrQ=0;

   marketShare(q, advDem->structure[advDem->number_of_owners], output, outputJacob);
   for(i=0;i<advDem->structure[advDem->number_of_owners];++i) {
     aggrQ+=q[i];
   }
   P=1-advDem->gamma[1]*aggrQ;

   /* Leaders loop */
   for(i=0;i<advDem->number_of_owners;i++) {
     for(k=advDem->structure[i];k<advDem->structure[i+1];k++) {
       foc[data->index[advDem->idx]+k]=output[k]*P;
       for(k1=advDem->structure[i];k1<advDem->structure[i+1];k1++) {
         foc[data->index[advDem->idx]+k]+=q[k1]*(outputJacob[k][k1]*P-output[k1]*advDem->gamma[1]);
       }
     }
   }
}     
