#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <pthread.h>

#include <blp.h>
//BLPproblem problem;
//BLPdata data;
//seedStruct *seed;


#ifdef SMP
typedef struct {
  F_TYPE *output;
  F_TYPE *output2;
  F_TYPE *arg;
  BLPproblem *problem;
  BLPdata *data;
  seedStruct *seed;
  int cut;
  short number;
} ThreadStructureJacobian;

void *jacobianThread(void *inputInit) {
  int j;
//  int step = threadsN/SMP+1;
  ThreadStructureJacobian *input = (ThreadStructureJacobian *) inputInit;

  for(j=input->number;j<threadsN;j+=SMP) {
    jacobian(input->output, input->output2, input->arg, 
      input->problem, input->data, input->seed, input->cut, j);
  }

  pthread_exit(NULL);
}

typedef struct {
  F_TYPE *output;
  F_TYPE *arg;
  BLPproblem *problem;
  BLPdata *data;
  seedStruct *seed;
  int cut;
  short number;
} ThreadStructureConstraint;

void *constraintThread(void *inputInit) {
  int j;
//  int step = threadsN/SMP+1;
  ThreadStructureConstraint *input = (ThreadStructureConstraint *) inputInit;

  for(j=input->number;j<threadsN;j+=SMP) {
    constraint(input->output, input->arg,
      input->problem, input->data, input->seed, input->cut, j);
  }

  pthread_exit(NULL);
}

#endif

int search(int *input, int number) {
  int i;
  for(i=0;i<problem->subsampling;++i) {
    if(input[i]==number) {
      return 1;
    }
  }
  return 0;
}

F_TYPE getElement(int *Rows, int *Columns, F_TYPE *Elements, int size, int i, int j) {
  int m;

  for(m=0;m<size;m++) {
    if((Rows[m]==i) && (Columns[m]==j)) {
      return Elements[m];
    }
  }

  return 0;
}

void clasify(double *demo, int *groups) {
  int i;
  for(i=0;i<8;++i) {
    if(demo[0]==i) {
      groups[i]=1;
    } else {
      groups[i]=0;
    }
  }
  // Sex
  groups[8]=demo[1];
  
  for(i=0;i<4;++i) {
    if(demo[2]==i) {
      groups[9+i]=1;
    } else {
      groups[9+i]=0;
    }
  }

  for(i=0;i<4;++i) {
    if(demo[3]==i) {
      groups[13+i]=1;
    } else {
      groups[13+i]=0;
    }
  }

  groups[17]=demo[4];
  groups[18]=demo[5];
  /*
  for(i=0;i<6;++i) {
    printf("%f ",demo[i]);
  }
  printf("\n");
  for(i=0;i<19;++i) {
    printf("%d ",groups[i]);
  }
  printf("\n");
  getchar();*/
}

int getSparseSize(BLPproblem *problem, BLPdata *data) {
  int i;
  int size = 0, stations;

  data->jacobianIndex[0]=0;

  for(i=0;i<problem->date*problem->market;i++) {
    stations=data->index[i+1]-data->index[i];
    size+=stations*(problem->allParams+stations);
    data->jacobianIndex[i+1]=size;
  }

  size+=problem->product*problem->demoGroups*(problem->allParams+1); // +1 for extra derivative with respect to nu1
  
  size+=problem->instruments*
    (data->index[problem->date*problem->market]+1);

  if(problem->ar) {
    size+=problem->instruments;
  }

  return size;
}

void createSparseIndex(BLPproblem *problem, BLPdata *data) {
  int i,j,z,m,k;
  int size_params_xi = problem->allParams+data->index[problem->date*problem->market];

  m=0;
  for(i=0;i<problem->date*problem->market;i++) {
    for(z=data->index[i];z<data->index[i+1];z++) {
      for(k=0;k<problem->allParams;++k) {
        Rows[m]=z;
        Columns[m]=k;
        m++;
      }
      for(k=data->index[i];k<data->index[i+1];k++) {
        Rows[m]=z;
        Columns[m]=problem->allParams+k;
        m++;
      }
    }
  }

  for(i=0;i<problem->product*problem->demoGroups;++i) {
    for(j=0;j<problem->allParams;++j) {
      Rows[m]=data->index[problem->date*problem->market]+i;
      Columns[m]=j;
      m++;
    }
    Rows[m]=data->index[problem->date*problem->market]+i;
    Columns[m]=Rows[m]+problem->allParams;
    m++;
  }

  if(problem->doInstruments==1) {
    for(j=0;j<problem->instruments;j++) {
      for(i=0;i<data->index[problem->date*problem->market];i++) {
        Rows[m]=data->index[problem->date*problem->market]+problem->product*problem->demoGroups+j;
        Columns[m]=problem->allParams+i;
        m++;
      }
      Rows[m]=data->index[problem->date*problem->market]+problem->product*problem->demoGroups+j;
      Columns[m]=Rows[m]+problem->allParams;
      m++;

      if(problem->ar) {
        Rows[m]=data->index[problem->date*problem->market]+problem->product*problem->demoGroups+j;
        Columns[m]=problem->allParams+data->index[problem->date*problem->market]+problem->product*problem->demoGroups+problem->instruments;
        m++;
      }
    }
  }
}

void jacobian(F_TYPE *output, F_TYPE *output2, F_TYPE *arg, BLPproblem *problem, BLPdata *data, seedStruct *seed, int cut, int idx) {
  F_TYPE denominator, temp, re;
  F_TYPE nominator[100],delta[100];
  F_TYPE term2[problem->allParams];
  int drawsIndex=problem->N*idx;
  int format = 0;
  int i,j,k,n,z,n1,m,f,m1,stations,d;
  int covarMatrixOffset;
  int offsetDate;
  F_TYPE vDraws[problem->random_effects];
  int offsetSigma = problem->parameters+problem->product*problem->demoCharacteristics;
  int size_params_xi = problem->allParams+data->index[problem->date*problem->market]+1;
  int offsetGroup;
  int offsetOutput=problem->product*problem->demoGroups*problem->allParams*idx;
  int demoGroup[problem->demoGroups];
  double numberOfDraws[problem->demoGroups];
  double der[problem->allParams];

  int group;
  int date;
  int market;

  date = idx/problem->market;
  int year = (date<3) ? -1 : (date-1)/2-1; // 96-97 are one year (-1)

  for(j=data->jacobianIndex[idx];j<data->jacobianIndex[idx+1];j++) {
    output[j]=0;
  }
  for(d=0;d<problem->demoGroups;++d) {
    numberOfDraws[d]=0;
  }

  for(j=0;j<problem->allParams*problem->product*problem->demoGroups;++j) {
    output2[offsetOutput+j]=0;
  }

  for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
    delta[n]=data->data[j][0]*arg[0]+data->data[j][1]*arg[1]+
      arg[2+(int) data->data[j][2]]+arg[problem->allParams+j]+data->data[j][7]*arg[problem->power];
  }

  for(i=0;i<problem->N;++i) {
    vectorNormal(seed[idx], problem->random_effects, vDraws);

    for(k=0;k<problem->allParams;k++) {
      term2[k]=0;
    }
    
    if(year>-1) {
      denominator=arg[problem->year_dummies+year];
    } else {
      denominator=1;
    }
    for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
      re = arg[offsetSigma+problem->product]*vDraws[problem->product]*data->data[j][0];

      format=data->data[j][2];

      covarMatrixOffset=problem->parameters+format*problem->demoCharacteristics;

      nominator[n]=re+delta[n]+arg[offsetSigma+format]*vDraws[format];

      for(k=0;k<problem->demoCharacteristics;++k) {
        nominator[n]+=arg[covarMatrixOffset+k]*data->demographics[i+drawsIndex][k];
      }
      nominator[n]=exp(nominator[n]);
      denominator+=nominator[n];

      term2[0]+=data->data[j][0]*nominator[n];
	    term2[1]+=data->data[j][1]*nominator[n];
	    term2[2+format]+=nominator[n];
	    for(k=0;k<problem->demoCharacteristics;k++) {
        term2[covarMatrixOffset+k]+=data->demographics[i+drawsIndex][k]*nominator[n];
	    }
	    term2[offsetSigma+format]+=vDraws[format]*nominator[n];

      term2[offsetSigma+problem->product]+=vDraws[problem->product]*nominator[n]*data->data[j][0];

      term2[problem->power]+=data->data[j][7]*nominator[n];
    }
    for(k=0;k<problem->allParams;k++) {
      term2[k]/=denominator;
    }

    for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
      nominator[n]/=denominator;
    }
   
    // Clasify demographics (puts 1 in the vector if the person belongs to the certain group)
    clasify(data->demographics[i+drawsIndex],demoGroup);
    for(d=0;d<problem->demoGroups;++d) {
      if(demoGroup[d]>0) {
        numberOfDraws[d]++;
      }
    }

    m = data->jacobianIndex[idx];
    for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
      format=data->data[j][2];
	    m1 = 0;

      der[m1]=(data->data[j][0]-term2[m1])*nominator[n];
      output[m]+=der[m1];
      m++;m1++;

      der[m1]=(data->data[j][1]-term2[m1])*nominator[n];
      output[m]+=der[m1];
      m++;m1++;

      for(k=0;k<format;k++) {
        der[m1]=-term2[m1]*nominator[n];
        output[m]+=der[m1];
        m++;m1++;
      }
      der[m1]=(1-term2[m1])*nominator[n];
      output[m]+=der[m1];
      m++;m1++;
      for(k=format+1;k<problem->product;k++) {
        der[m1]=-term2[m1]*nominator[n];
        output[m]+=der[m1];
        m++;m1++;
      }

      // Derivative with respect to Pi
      for(f=0;f<format;f++) {
        for(k=0;k<problem->demoCharacteristics;k++) {
          der[m1]=-term2[m1]*nominator[n];
          output[m]+=der[m1];
          m++;m1++;
        }
      }
      for(k=0;k<problem->demoCharacteristics;k++) {
        der[m1]=(data->demographics[i+drawsIndex][k]-term2[m1])*nominator[n];
        output[m]+=der[m1];
        m++;m1++;
      }
      for(f=format+1;f<problem->product;f++) {
        for(k=0;k<problem->demoCharacteristics;k++) {
          der[m1]=-term2[m1]*nominator[n];
          output[m]+=der[m1];
          m++;m1++;
        }
      }

      // Derivative with respect to sigma
      for(k=0;k<format;k++) {
        der[m1]=-term2[m1]*nominator[n];
        output[m]+=der[m1];
        m++;m1++;
      }
      der[m1]=(vDraws[format]-term2[m1])*nominator[n];
      output[m]+=der[m1];
      m++;m1++;
      for(k=format+1;k<problem->product;k++) {
        der[m1]=-term2[m1]*nominator[n];
        output[m]+=der[m1];
        m++;m1++;
      }

      // Random effect derivative
      output[m]+=(data->data[j][0]*vDraws[problem->product]-term2[m1])*nominator[n];
      der[m1]=(data->data[j][0]*vDraws[problem->product]-term2[m1])*nominator[n];
      m++;m1++;
      
      // Power derivative
      output[m]+=(data->data[j][7]-term2[m1])*nominator[n];
      der[m1]=(data->data[j][7]-term2[m1])*nominator[n];
      m++;m1++;

      // Year derivative
      for(k=0;k<problem->number_of_year_dummies;k++) {
        der[m1+k]=0;
      }
      if(year>-1) {
        output[m+year]-=nominator[n]/denominator;
        der[m1+year]=-nominator[n]/denominator;
      }
      m+=problem->number_of_year_dummies;

      // Derivative with respect to Xi
	    for(n1=0;n1<data->index[idx+1]-data->index[idx];++n1) {
	      output[m]-=nominator[n1]*nominator[n];
	      if(n1==n) {
	        output[m]+=nominator[n];
	      }
	      m++;
	    }
      for(d=0;d<problem->demoGroups;++d) {
        if(demoGroup[d]>0) {
          offsetGroup=(problem->product*d+(int) data->data[j][2])*problem->allParams;
          for(k=0;k<problem->allParams;++k) {
            output2[offsetOutput+offsetGroup+k]+=der[k];
          }
        }
      }
    }
  }
  for(j=data->jacobianIndex[idx];j<data->jacobianIndex[idx+1];++j) {
    output[j]/=problem->N;
  }
  for(d=0;d<problem->demoGroups;++d) {
    if(numberOfDraws[d]>0) {
      for(j=0;j<problem->product;++j) {
        for(k=0;k<problem->allParams;++k) {
          output2[offsetOutput+(d*problem->product+j)*problem->allParams+k]/=numberOfDraws[d];
        }
      }
    } 
  }
}

void augmentedJacobian(F_TYPE *output, F_TYPE *arg) {
  int i,m,m1,d,j,c,date,k;
  int groupsproduct = problem->demoGroups*problem->product;
  int date_market = problem->date*problem->market;
  int offset;
  #ifdef SMP
    ThreadStructureJacobian *input;
  #endif

  F_TYPE *output2;
  int rho = problem->allParams+data->index[problem->date*problem->market]+groupsproduct+instrumentsSave;

  printf("Evaluting jacobian...");
  output2 = (F_TYPE *) malloc(date_market*groupsproduct*problem->allParams*sizeof(F_TYPE));

  #ifndef SMP
    for(i=0;i<threadsN;++i) {
      jacobian(output, output2, arg, problem, data, seed, date_market, i);
    }
  #else
    pthread_t thread_id[SMP];
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);
    input = (ThreadStructureJacobian *) malloc(SMP*sizeof(ThreadStructureJacobian));
    for(j=0;j<SMP;j++) {
      input[j].output=output;
      input[j].output2=output2;
      input[j].arg=arg;
      input[j].problem=problem;
      input[j].data=data;
      input[j].seed=seed;
      input[j].cut=date_market;
      input[j].number=j;

      pthread_create(&thread_id[j], &attr, jacobianThread, (void *) &input[j] );
    }
    pthread_attr_destroy(&attr);

    for(j=0;j<SMP;j++) {
      pthread_join(thread_id[j], NULL);
    }

    free(input);
  #endif

  // Now sum it up!
  m1=0;
  m=data->jacobianIndex[date_market];
  for(i=0;i<groupsproduct;++i) {
    for(j=0;j<problem->allParams;++j) {
      output[m]=output2[m1];
      m++;m1++;
    }

    output[m]=-1;
    m++;
  }
  for(d=1;d<date_market;++d) {
    m=data->jacobianIndex[date_market];
    for(i=0;i<groupsproduct;++i) {
      for(j=0;j<problem->allParams;++j) {
        output[m]+=output2[m1];
        m++;m1++;
      }
      
      // dnu
      m++;
    }
  }

  m=data->jacobianIndex[date_market];
  for(i=0;i<groupsproduct;++i) {
    for(j=0;j<problem->allParams;++j) {
      if(problem->subsampling) {
        output[m]/=problem->subsampling*problem->market;
      } else {
        output[m]/=date_market;
      }
      m++;
    }
    // dnu
    m++;
  }

  offset=data->jacobianIndex[date_market]+(problem->allParams+1)*groupsproduct;

  if(problem->doInstruments==1) {
    if(problem->ar) {
      for(j=0;j<problem->instruments;j++) {
        m=offset;
        for(i=0;i<data->index[date_market]+2;++i) {
          output[m]=0;
          m++;
        }
        c=0;
        ///// need a fix to correct for data - same in jacobian
        date=0;
        for(k=data->index[problem->market];k<data->index[date_market];k++) {
          if(problem->bs) {
            i=data->bsDraws[k-data->index[problem->market]];
          } else {
            i=k;
          }
          if(problem->subsampling) {
            if(i>=data->index[problem->market*(date+1)]) {
              date++;
              if(!search(data->subsample,date)) {
                continue;
              }
            }
          }
          output[offset+i]+=data->instruments[j][i];
//          printf("%d %d\n",i,lag[i]);
          if(lag[i]>-1) {
            output[offset+lag[i]]-=arg[rho]*data->instruments[j][i];
            output[offset+data->index[date_market]+1]-=arg[problem->allParams+lag[i]]*data->instruments[j][i];
          }
          c++;
        }
        output[offset+data->index[date_market]]=-c;

        offset+=data->index[date_market]+2;
      }
    } else { // Linear constraints
      for(j=0;j<problem->instruments;j++) {
        for(i=0;i<data->index[date_market];i++) {
          output[m]=data->instruments[j][i];
          m++;
        }

        output[m]=-1;
        m++;
      }
    }
  }

  free(output2);

  printf("done.\n");
}

void augmentedCovariance(F_TYPE *arg, F_TYPE *A, F_TYPE *B, F_TYPE *C) {
  int i,j,c,date,k,m;
  int date_market = problem->date*problem->market;
  int startSum = data->index[date_market];
  int step = problem->product*problem->demoGroups;
  int start = data->index[date_market]+step;
  int end = data->index[date_market]+date_market*step;
  int nu1 = problem->allParams+data->index[date_market];
  int nu2 = nu1+step;
  int rho = nu2+instrumentsSave;
  int offset,idx;
  F_TYPE *output2;

  #ifdef SMP
    ThreadStructureConstraint *input;
  #endif

  printf("Evaluating constraints...");

  // Allocate memory
  output2 = (F_TYPE *) malloc((data->index[date_market]+date_market*problem->demoGroups*problem->product)*sizeof(F_TYPE));

  #ifndef SMP
    for(i=0;i<threadsN;++i) {
      constraint(output2, arg, problem, data, seed, date_market, i);
    }
  #else
    pthread_t thread_id[SMP];
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);
    input = (ThreadStructureConstraint *) malloc(SMP*sizeof(ThreadStructureConstraint));
    for(j=0;j<SMP;j++) {
      input[j].output=output2;
      input[j].arg=arg;
      input[j].problem=problem;
      input[j].data=data;
      input[j].seed=seed;
      input[j].cut=date_market;
      input[j].number=j;

      pthread_create(&thread_id[j], &attr, constraintThread, (void *) &input[j] );
    }
    pthread_attr_destroy(&attr);

    for(j=0;j<SMP;j++) {
      pthread_join(thread_id[j], NULL);
    }

    free(input);
  #endif

  // Upper diagonal
  m=0;
  if(problem->ar) {
    for(j=0;j<instrumentsSave;j++) {
      for(k=0;k<instrumentsSave;k++) {
        A[m]=0;
        for(i=data->index[problem->market];i<data->index[date_market];i++) {
          if(lag[i]>-1) {
            A[m]+=(arg[i+problem->allParams]-arg[rho]*arg[lag[i]+problem->allParams])*
              (arg[i+problem->allParams]-arg[rho]*arg[lag[i]+problem->allParams])*
              data->instruments[j][i]*data->instruments[k][i];
          } else {
            A[m]+=(arg[i+problem->allParams])*
              (arg[i+problem->allParams])*
              data->instruments[j][i]*data->instruments[k][i];
          }
        }
        A[m]/=(data->index[date_market]-data->index[problem->market]);
        m++;
      }
    }
  } else {
    for(j=0;j<instrumentsSave;j++) {
      for(k=0;k<instrumentsSave;k++) {
        A[m]=0;
        for(i=0;i<data->index[date_market];i++) {
          A[m]+=arg[i+problem->allParams]*arg[i+problem->allParams]*data->instruments[j][i]*data->instruments[k][i];
        }
        A[m]/=data->index[date_market];
        m++;
      }
    }
  }
  
  m=0;
  // Upper off-diagonal
  if(problem->ar) {
    for(j=0;j<instrumentsSave;j++) {
      for(k=0;k<problem->product*problem->demoGroups;k++) {
        B[m]=0;
        for(idx=problem->market;idx<date_market;++idx) {
          offset=idx*problem->product*problem->demoGroups;
          for(i=data->index[idx];i<data->index[idx+1];i++) {
            if(lag[i]>-1) {
              B[m]+=(arg[i+problem->allParams]-arg[rho]*arg[lag[i]+problem->allParams])*data->instruments[j][i]*
                (output2[offset+k]-data->demoFromData[k]);
            } else {
              B[m]+=(arg[i+problem->allParams])*data->instruments[j][i]*
                (output2[offset+k]-data->demoFromData[k]);
            } 
          }
        }
        B[m]/=(data->index[date_market]-data->index[problem->market]);
        m++;
      }
    }
  }
  
  m=0;
  // Lower diagonal
  for(j=0;j<problem->product*problem->demoGroups;j++) {
    for(k=0;k<problem->product*problem->demoGroups;k++) {
      C[m]=0;
      for(idx=problem->market;idx<date_market;++idx) {
        offset=idx*problem->product*problem->demoGroups;
        C[m]+=(output2[offset+j]-data->demoFromData[j])*(output2[offset+k]-data->demoFromData[k]);
      }
      C[m]/=(date_market-problem->market);
      m++;
    }
  }

  free(output2);
}

void augmentedConstraint(F_TYPE *output, F_TYPE *arg) {
  int i,j,c,date,k;
  int date_market = problem->date*problem->market;
  int startSum = data->index[date_market];
  int step = problem->product*problem->demoGroups;
  int start = data->index[date_market]+step;
  int end = data->index[date_market]+date_market*step;
  int nu1 = problem->allParams+data->index[date_market];
  int nu2 = nu1+step;
  int rho = nu2+instrumentsSave;
  F_TYPE *output2;

  #ifdef SMP
    ThreadStructureConstraint *input;
  #endif

  printf("Evaluating constraints...");

  // Allocate memory
  output2 = (F_TYPE *) malloc((data->index[date_market]+date_market*problem->demoGroups*problem->product)*sizeof(F_TYPE));

  #ifndef SMP
    for(i=0;i<threadsN;++i) {
      constraint(output2, arg, problem, data, seed, date_market, i);
    }
  #else
    pthread_t thread_id[SMP];
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);
    input = (ThreadStructureConstraint *) malloc(SMP*sizeof(ThreadStructureConstraint));
    for(j=0;j<SMP;j++) {
      input[j].output=output2;
      input[j].arg=arg;
      input[j].problem=problem;
      input[j].data=data;
      input[j].seed=seed;
      input[j].cut=date_market;
      input[j].number=j;

      pthread_create(&thread_id[j], &attr, constraintThread, (void *) &input[j] );
    }
    pthread_attr_destroy(&attr);

    for(j=0;j<SMP;j++) {
      pthread_join(thread_id[j], NULL);
    }

    free(input);
  #endif

  for(i=0;i<start;i++) {
    output[i]=output2[i];
  }

  for(i=start;i<end;i+=step) {
    for(j=0;j<step;++j) {
      output[startSum+j]+=output2[i+j];
    }
  }

  for(j=0;j<step;++j) {
    if(problem->subsampling) {
      output[startSum+j]/=problem->subsampling*problem->market;
    } else {
      output[startSum+j]/=date_market;
    }
    output[startSum+j]-=data->demoFromData[j]+arg[nu1+j];
  }

  for(j=0;j<startSum;++j) {
    output[j]-=data->share[j];
  }

  if(problem->doInstruments==1) {
    // Linear constraints
    if(problem->ar) {
      for(j=0;j<problem->instruments;j++) {
        c=0;
        date=0;
        output[start+j]=0;
        for(k=data->index[problem->market];k<data->index[date_market];k++) {
          if(problem->bs) {
            i=data->bsDraws[k-data->index[problem->market]];
          } else {
            i=k;
          }
          if(problem->subsampling) {
            if(i>=data->index[problem->market*(date+1)]) {
              date++;

              if(!search(data->subsample,date)) {
                continue;
              } 
            }
          }
          output[start+j]+=arg[problem->allParams+i]*data->instruments[j][i];
//          printf("%f ",arg[problem->allParams+i]);
          if(lag[i]>-1) {
            output[start+j]-=arg[rho]*arg[problem->allParams+lag[i]]*data->instruments[j][i];
//            printf("%f %f %f",arg[problem->allParams+lag[i]],arg[rho],arg[problem->allParams+i]-arg[rho]*arg[problem->allParams+lag[i]]);
          }
//          printf("\n");
          c++;
        }
        output[start+j]-=c*arg[nu2+j];
      }
    } else {
      for(j=0;j<problem->instruments;j++) {
        output[start+j]=0;
        for(i=0;i<data->index[date_market];i++) {
          output[start+j]+=arg[problem->allParams+i]*data->instruments[j][i];
        }
        output[start+j]-=data->index[date_market]*arg[nu2+j];
      }
    }
  }
//  getchar();

  free(output2);

  printf("done.\n");
}
  

void constraint(F_TYPE *output, F_TYPE *arg, BLPproblem *problem, BLPdata *data, seedStruct *seed, int cut, int idx) {
  F_TYPE denominator, re;
  F_TYPE nominator[100], delta[100];
  int drawsIndex=problem->N*idx;
  int format;
  int i,j,k,n,z,d;
  int covarMatrixOffset;
  int offsetDate, offsetOutput, offsetGroup;
  int offsetSigma = problem->parameters+problem->product*problem->demoCharacteristics;
  int offsetXi = problem->allParams;
  double share;
  double numberOfDraws[problem->product*problem->demoGroups];
  int demoGroup[problem->demoGroups];
  F_TYPE vDraws[problem->random_effects];

  int group;
  int date;
  int market;
  int year;

  for(d=0;d<problem->demoGroups*problem->product;++d) {
    numberOfDraws[d]=0;
  }

  date = idx/problem->market;
  year = (date<3) ? -1 : (date-1)/2-1; // 96-97 are one year (-1)
  for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
    output[j]=0;
    delta[n]=data->data[j][0]*arg[0]+data->data[j][1]*arg[1]+
      arg[2+(int) data->data[j][2]]+arg[offsetXi+j]+data->data[j][7]*arg[problem->power];
  }
  offsetOutput = data->index[cut]+idx*(problem->product*problem->demoGroups);
  for(i=0;i<problem->product*problem->demoGroups;++i) {
    output[offsetOutput+i]=0;
  }
  for(i=0;i<problem->N;++i) {
    vectorNormal(seed[idx], problem->random_effects, vDraws);

    if(year>-1) {
      denominator=arg[problem->year_dummies+year];
    } else {
      denominator=1;
    }
    for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
      re = arg[offsetSigma+problem->product]*vDraws[problem->product]*data->data[j][0];

      format=data->data[j][2];
	
	    covarMatrixOffset=problem->parameters+format*problem->demoCharacteristics;
  
	    nominator[n]=re+delta[n]+arg[offsetSigma+format]*vDraws[format];
	
	    for(k=0;k<problem->demoCharacteristics;++k) {
	      nominator[n]+=arg[covarMatrixOffset+k]*data->demographics[i+drawsIndex][k];
	    }
 
	    nominator[n]=exp(nominator[n]);
	    denominator+=nominator[n];
    }

    // Clasify demographics (puts 1 in the vector if the person belongs to the certain group)
    clasify(data->demographics[i+drawsIndex],demoGroup);
    // We keep a separate vector for each market/data, the size is problem->product*problem->demoGroups (152?)
    for(d=0;d<problem->demoGroups;++d) {
      if(demoGroup[d]>0) {
        numberOfDraws[d]++;
      }
    }
    // Market share
    for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
      share=nominator[n]/denominator;
      output[j]+=share;
      for(d=0;d<problem->demoGroups;++d) {
        if(demoGroup[d]>0) {
          offsetGroup=problem->product*d+(int) data->data[j][2];
          output[offsetOutput+offsetGroup]+=share;
        }
      }
    }
  }
  for(j=data->index[idx];j<data->index[idx+1];++j) {
    output[j]/=problem->N;
  }
  for(d=0;d<problem->demoGroups;++d) {
    if(numberOfDraws[d]>0) {
      for(j=0;j<problem->product;++j) {
        output[offsetOutput+d*problem->product+j]/=numberOfDraws[d];
      }
    }
  }
}
