#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <pthread.h>

#include <blp.h>
//BLPproblem problem;
//BLPdata data;
//seedStruct *seed;

#ifdef SMP
typedef struct {
  F_TYPE *output;
  F_TYPE *output2;
  F_TYPE *arg;
  BLPproblem *problem;
  BLPdata *data;
  seedStruct *seed;
  int cut;
  short number;
} ThreadStructureJacobian;

void *jacobianThread(void *inputInit) {
  int j;
//  int step = threadsN/SMP+1;
  ThreadStructureJacobian *input = (ThreadStructureJacobian *) inputInit;

  for(j=input->number;j<threadsN;j+=SMP) {
    jacobian(input->output, input->output2, input->arg, 
      input->problem, input->data, input->seed, input->cut, j);
  }

  pthread_exit(NULL);
}

typedef struct {
  F_TYPE *output;
  F_TYPE *arg;
  BLPproblem *problem;
  BLPdata *data;
  seedStruct *seed;
  int cut;
  short number;
} ThreadStructureConstraint;

void *constraintThread(void *inputInit) {
  int j;
//  int step = threadsN/SMP+1;
  ThreadStructureConstraint *input = (ThreadStructureConstraint *) inputInit;

  for(j=input->number;j<threadsN;j+=SMP) {
    constraint(input->output, input->arg,
      input->problem, input->data, input->seed, input->cut, j);
  }

  pthread_exit(NULL);
}

#endif


int search(int *input, int number) {
  int i;
  for(i=0;i<problem->subsampling;++i) {
    if(input[i]==number) {
      return 1;
    }
  }
  return 0;
}


F_TYPE getElement(int *Rows, int *Columns, F_TYPE *Elements, int size, int i, int j) {
  int m;

  for(m=0;m<size;m++) {
    if((Rows[m]==i) && (Columns[m]==j)) {
      return Elements[m];
    }
  }

  return 0;
}

int getSparseSize(BLPproblem *problem, BLPdata *data) {
  int i;
  int size = 0, stations;
  int size_params_xi = problem->allParams+data->index[problem->date*problem->market];

  data->jacobianIndex[0]=0;

  for(i=0;i<problem->date*problem->market;i++) {
    stations=data->index[i+1]-data->index[i];
    size+=stations*(problem->allParams+stations);
    data->jacobianIndex[i+1]=size;
  }

  size+=problem->product*problem->demoGroups*
    (size_params_xi+1);
  
  size+=problem->instruments*
    (data->index[problem->date*problem->market]+1);

  if(problem->ar) {
    size+=problem->instruments;
  }

  return size;
}

void createSparseIndex(BLPproblem *problem, BLPdata *data) {
  int i,j,z,m,k;
  int size_params_xi = problem->allParams+data->index[problem->date*problem->market];

  m=0;
  for(i=0;i<problem->date*problem->market;i++) {
    for(z=data->index[i];z<data->index[i+1];z++) {
      for(k=0;k<problem->allParams;++k) {
        Rows[m]=z;
        Columns[m]=k;
        m++;
      }
      for(k=data->index[i];k<data->index[i+1];k++) {
        Rows[m]=z;
        Columns[m]=problem->allParams+k;
        m++;
      }
    }
  }

  for(i=0;i<problem->product*problem->demoGroups;++i) {
    for(j=0;j<size_params_xi;++j) {
      Rows[m]=data->index[problem->date*problem->market]+i;
      Columns[m]=j;
      m++;
    }
    Rows[m]=data->index[problem->date*problem->market]+i;
    Columns[m]=size_params_xi+i;
    m++;
  }

  if(problem->doInstruments==1) {
    for(j=0;j<problem->instruments;j++) {
      for(i=0;i<data->index[problem->date*problem->market];i++) {
        Rows[m]=data->index[problem->date*problem->market]+problem->product*problem->demoGroups+j;
        Columns[m]=problem->allParams+i;
        m++;
      }
      Rows[m]=data->index[problem->date*problem->market]+problem->product*problem->demoGroups+j;
      Columns[m]=Rows[m]+problem->allParams;
      m++;

      if(problem->ar) {
        Rows[m]=data->index[problem->date*problem->market]+problem->product*problem->demoGroups+j;
        Columns[m]=problem->allParams+data->index[problem->date*problem->market]+problem->product*problem->demoGroups+problem->instruments;
        m++;
      }
    }
  }
}

void createSparseIndexMatlab(BLPproblem *problem, BLPdata *data) {
  int i,z,m,k,z1,s1,s,m1;
  int size_params_xi = problem->allParams+data->index[problem->date*problem->market];
  int date_market = problem->date*problem->market;
  int stations;

  // dParams
  m=0;
  m1=0;
  for(k=0;k<problem->allParams;++k) {
    Columns[m1]=m;
    for(i=0;i<problem->date*problem->market;i++) {
      stations=data->index[i+1]-data->index[i];
      for(z=data->index[i],s=0;z<data->index[i+1];++z,++s) {
        Rows[m]=z;
        Transpose[m]=data->jacobianIndex[i]+s*(problem->allParams+stations)+k;
        m++;
      }
    }
    // demographics
    for(i=0;i<problem->product*problem->demoGroups;++i) {
      Columns[m]=data->index[problem->date*problem->market]+i;
      Transpose[m]=data->jacobianIndex[problem->date*problem->market]+(size_params_xi+1)*i+k;
      m++;
    }
    m1++;
  }

  // dXi
  for(i=0;i<problem->date*problem->market;i++) {
    // Stations
    stations=data->index[i+1]-data->index[i];
    for(z=data->index[i],s=0;z<data->index[i+1];++z,++s) {
      Columns[m1]=problem->allParams+z;
      m1++;
      for(z1=data->index[i],s1=0;z1<data->index[i+1];++z1,++s1) {
        Rows[m]=z1;
        Transpose[m]=data->jacobianIndex[i]+s1*(problem->allParams+stations)+problem->allParams+z;
        m++;
      }
      // Demographics
      for(z1=0;z1<problem->product*problem->demoGroups;++z1) {
        Rows[m]=z1+data->index[date_market];
        Transpose[m]=data->jacobianIndex[date_market]+z1*(size_params_xi+1)+z;
        m++;
      }
    
      // Linear constraints
      for(z1=0;z1<problem->instruments;++z1) {
        Rows[m]=z1+data->index[date_market]+problem->product*problem->demoGroups;
        Transpose[m]=data->jacobianIndex[date_market]+(problem->product*problem->demoGroups)*(size_params_xi+1)+
          z1*(data->index[date_market]+1)+z;
        m++;
      }
    }
  }
  
  // dnu1
  for(i=0;i<problem->instruments;i++) {
    Columns[m1]=problem->allParams+data->index[date_market]+i;
    m1++;
    Rows[m]=data->index[date_market]+problem->product*problem->demoGroups+i;
    Transpose[m]=data->jacobianIndex[date_market]+(problem->product*problem->demoGroups)*(size_params_xi+1)+i*(data->index[date_market]+1)+data->index[date_market]+i;
    m++;
  }
  // dnu2
  for(i=0;i<problem->product*problem->demoGroups;i++) {
    Columns[m1]=problem->allParams+data->index[date_market]+problem->instruments+i;
    m1++;
    Rows[m]=data->index[date_market]+i;
    Transpose[m]=data->jacobianIndex[date_market]+i*(size_params_xi+1)+size_params_xi+i;
    m++;
  }
  Columns[m1]=problem->allParams+data->index[date_market]+problem->product*problem->demoGroups+problem->instruments;
}


void jacobian(F_TYPE *output, F_TYPE *output2, F_TYPE *arg, BLPproblem *problem, BLPdata *data, seedStruct *seed, int cut, int idx) {
  F_TYPE denominator, temp, re;
  F_TYPE nominator[100],delta[100];
  F_TYPE term2[problem->allParams];
  int drawsIndex=problem->N*idx;
  int format = 0;
  int i,j,k,n,z,n1,m,f,m1,stations;
  int covarMatrixOffset;
  int offsetDate;
  F_TYPE vDraws[problem->random_effects];
  int offsetSigma = problem->parameters+problem->product*problem->demoCharacteristics;
  int size_params_xi = problem->allParams+data->index[problem->date*problem->market]+1;
  int output2Line;
  int offsetOutput, offsetOutput2;

  int group;
  int date;
  int market;

  if(idx<cut) { // Market shares
    for(j=data->jacobianIndex[idx];j<data->jacobianIndex[idx+1];j++) {
      output[j]=0;
    }

    for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
      delta[n]=data->data[j][0]*arg[0]+data->data[j][1]*arg[1]+
        arg[2+(int) data->data[j][2]]+arg[problem->allParams+j];
    }

    for(i=0;i<problem->N;++i) {
      vectorNormal(seed[idx], problem->random_effects, vDraws);
//      for(k=0;k<problem->product;k++) {
//        vDraws[k]=nextNormal(seed[idx]);
//      }

      for(k=0;k<problem->allParams;k++) {
        term2[k]=0;
      }

      denominator=1;

      for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
        re = arg[offsetSigma+problem->product]*vDraws[problem->product]*data->data[j][0];

        format=data->data[j][2];

        covarMatrixOffset=problem->parameters+format*problem->demoCharacteristics;

        nominator[n]=re+delta[n]+arg[offsetSigma+format]*vDraws[format];

        for(k=0;k<problem->demoCharacteristics;++k) {
          nominator[n]+=arg[covarMatrixOffset+k]*data->demographics[i+drawsIndex][k];
        }
        nominator[n]=exp(nominator[n]);
        denominator+=nominator[n];

        term2[0]+=data->data[j][0]*nominator[n];
	      term2[1]+=data->data[j][1]*nominator[n];
	      term2[2+format]+=nominator[n];
	      for(k=0;k<problem->demoCharacteristics;k++) {
          term2[covarMatrixOffset+k]+=data->demographics[i+drawsIndex][k]*nominator[n];
	      }
	      term2[offsetSigma+format]+=vDraws[format]*nominator[n];

        term2[offsetSigma+problem->product]+=vDraws[problem->product]*nominator[n]*data->data[j][0];
      }
      for(k=0;k<problem->allParams;k++) {
        term2[k]/=denominator;
      }

      for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
        nominator[n]/=denominator;
      }
     
      m = data->jacobianIndex[idx];
      for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
        format=data->data[j][2];
	      m1 = 0;

        output[m]+=(data->data[j][0]-term2[m1])*nominator[n];
        m++;m1++;
        output[m]+=(data->data[j][1]-term2[m1])*nominator[n];
        m++;m1++;

        for(k=0;k<format;k++) {
          output[m]-=term2[m1]*nominator[n];
          m++;m1++;
        }
        output[m]+=(1-term2[m1])*nominator[n];
        m++;m1++;
        for(k=format+1;k<problem->product;k++) {
          output[m]-=term2[m1]*nominator[n];
          m++;m1++;
        }

        // Derivative with respect to Pi
        for(f=0;f<format;f++) {
          for(k=0;k<problem->demoCharacteristics;k++) {
            output[m]-=term2[m1]*nominator[n];
            m++;m1++;
          }
        }
        for(k=0;k<problem->demoCharacteristics;k++) {
          output[m]+=(data->demographics[i+drawsIndex][k]-term2[m1])*nominator[n];
          m++;m1++;
        }
        for(f=format+1;f<problem->product;f++) {
          for(k=0;k<problem->demoCharacteristics;k++) {
            output[m]-=term2[m1]*nominator[n];
            m++;m1++;
          }
        }

        // Derivative with respect to sigma
        for(k=0;k<format;k++) {
          output[m]-=term2[m1]*nominator[n];
          m++;m1++;
        }
        output[m]+=(vDraws[format]-term2[m1])*nominator[n];
        m++;m1++;
        for(k=format+1;k<problem->product;k++) {
          output[m]-=term2[m1]*nominator[n];
          m++;m1++;
        }

        // Random effect derivative
        output[m]+=(data->data[j][0]*vDraws[problem->product]-term2[m1])*nominator[n];
        m++;m1++;
      
        // Derivative with respect to Xi
	      for(n1=0;n1<data->index[idx+1]-data->index[idx];++n1) {
	        output[m]-=nominator[n1]*nominator[n];
	        if(n1==n) {
	          output[m]+=nominator[n];
	        }
	        m++;
	      }
      }
    }
    for(j=data->jacobianIndex[idx];j<data->jacobianIndex[idx+1];++j) {
      output[j]/=problem->N;
    }
  } else {
    idx-=cut;
    date = idx/problem->demoGroups;
    offsetDate = date*problem->market;
    group = idx % problem->demoGroups;

    output2Line = problem->allParams;
    offsetOutput2 = (idx*problem->product)*output2Line;
    offsetOutput = data->jacobianIndex[cut]+(group*problem->product)*size_params_xi;

    drawsIndex = idx*problem->P;

    for(i=offsetOutput2;i<offsetOutput2+problem->product*output2Line;++i) {
      output2[i]=0;
    }

    m1=offsetOutput+problem->allParams;
    for(f=0;f<problem->product;f++) {
      for(m=data->index[offsetDate];m<data->index[offsetDate+problem->market];m++) {
        output[m1+m]=0;
      }
      m1+=size_params_xi;
    }

    if(problem->subsampling) {
      if(!search(data->subsample,date)) {
        return;
      }
    }

    for(z=drawsIndex,i=0;i<problem->P;++z,++i) {
      denominator = 1;
      market = data->demoGroups[z][0];
      for(k=0;k<problem->allParams;k++) {
	term2[k]=0;
      }
      vectorNormal(seed[idx+cut], problem->random_effects, vDraws);
//      for(k=0;k<problem->product;k++) {
//        vDraws[k]=nextNormal(seed[idx+cut]);
//      }

      stations = data->index[offsetDate+market+1]-data->index[offsetDate+market];
      for(j=data->index[offsetDate+market],n=0;j<data->index[offsetDate+market+1];++j,++n) {
        re = arg[offsetSigma+problem->product]*vDraws[problem->product]*data->data[j][0];

        format=data->data[j][2];

        covarMatrixOffset=10+format*problem->demoCharacteristics;

        nominator[n]=re+data->data[j][0]*arg[0]+
          data->data[j][1]*arg[1]+arg[2+format]+arg[problem->allParams+j]+arg[offsetSigma+format]*vDraws[format];

        for(k=0;k<problem->demoCharacteristics;++k) {
          nominator[n]+=arg[covarMatrixOffset+k]*data->demoGroups[z][k+1];
        }

        nominator[n]=exp(nominator[n]);
        denominator+=nominator[n];

        term2[0]+=data->data[j][0]*nominator[n];
        term2[1]+=data->data[j][1]*nominator[n];
        term2[2+format]+=nominator[n];
	m=problem->parameters+problem->demoCharacteristics * format;
        for(k=0;k<problem->demoCharacteristics;k++) {
          term2[m+k]+=data->demoGroups[z][k+1]*nominator[n];
        }
        m=problem->parameters+problem->demoCharacteristics * problem->product;
        term2[m+format]+=vDraws[format]*nominator[n];

        // Additional random effects
        term2[m+problem->product]+=vDraws[problem->product]*data->data[j][0]*nominator[n];
      }
      for(k=0;k<problem->allParams;k++) {
        term2[k]/=denominator;
      }

      for(n=0;n<stations;++n) {
        nominator[n]/=denominator;
      }

      for(j=data->index[offsetDate+market],n=0;j<data->index[offsetDate+market+1];++j,++n) { 
        format=data->data[j][2];
        
	m = offsetOutput2+format*output2Line;
	m1 = 0;
        
	temp = nominator[n]/problem->P;

	output2[m]+=(data->data[j][0]-term2[m1])*temp;
        m++;m1++;
        output2[m]+=(data->data[j][1]-term2[m1])*temp;
        m++;m1++;

        for(k=0;k<format;k++) {
	  output2[m]-=term2[m1]*temp;
	  m++;m1++;
	}
	output2[m]+=(1-term2[m1])*temp;
        m++;m1++;
	for(k=format+1;k<problem->product;k++) {
          output2[m]-=term2[m1]*temp;
	  m++;m1++;
	}
        
	// Derivative with respect to Pi
	for(f=0;f<format;f++) {
	  for(k=0;k<problem->demoCharacteristics;k++) {
            output2[m]-=term2[m1]*temp;
            m++;m1++;
          }
	}
        for(k=0;k<problem->demoCharacteristics;k++) {
	  output2[m]+=(data->demoGroups[z][k+1]-term2[m1])*temp;
	  m++;m1++;
	}
	for(f=format+1;f<problem->product;f++) {
	  for(k=0;k<problem->demoCharacteristics;k++) {
	    output2[m]-=term2[m1]*temp;
	    m++;m1++;
	  }
	}

	// Derivative with respect to sigma
        for(k=0;k<format;k++) {
          output2[m]-=term2[m1]*temp;
          m++;m1++;
        }
        output2[m]+=(vDraws[format]-term2[m1])*temp;
        m++;m1++;
        for(k=format+1;k<problem->product;k++) {
          output2[m]-=term2[m1]*temp;
          m++;m1++;
        }

        // Random effect derivative
        output2[m]+=(data->data[j][0]*vDraws[problem->product]-term2[m1])*temp;
        m++;m1++;
	
	m = offsetOutput+format*size_params_xi+problem->allParams+data->index[offsetDate+market];
	// Derivative with respect to Xi
        for(n1=0;n1<stations;++n1) {
          output[m]-=nominator[n1]*nominator[n];
	  if(n1==n) {
            output[m]+=nominator[n];
          }
	  m++;
        }
      }
    }

    m1=offsetOutput+problem->allParams;
    for(f=0;f<problem->product;f++) {
      for(m=data->index[offsetDate];m<data->index[offsetDate+problem->market];m++) {
        output[m1+m]/=(problem->P*problem->date);
      }
      m1+=size_params_xi;
    }
  }
}

void augmentedJacobian(F_TYPE *output, F_TYPE *arg) {
  int i,m,m1,d,j,c,date;
  int groupsproduct = problem->demoGroups*problem->product;
  int date_market = problem->date*problem->market;
  int offset;
  #ifdef SMP
    ThreadStructureJacobian *input;
  #endif

  F_TYPE *output2;
  int rho = problem->allParams+data->index[problem->date*problem->market]+groupsproduct+instrumentsSave;

  printf("Evaluting jacobian...");

  output2 = (F_TYPE *) malloc(problem->date*problem->demoGroups*problem->product*problem->allParams*sizeof(F_TYPE));


  #ifndef SMP
    for(i=0;i<threadsN;++i) {
      jacobian(output, output2, arg, problem, data, seed, date_market, i);
    }
  #else
    pthread_t thread_id[SMP];
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);
    input = (ThreadStructureJacobian *) malloc(SMP*sizeof(ThreadStructureJacobian));
    for(j=0;j<SMP;j++) {
      input[j].output=output;
      input[j].output2=output2;
      input[j].arg=arg;
      input[j].problem=problem;
      input[j].data=data;
      input[j].seed=seed;
      input[j].cut=date_market;
      input[j].number=j;

      pthread_create(&thread_id[j], &attr, jacobianThread, (void *) &input[j] );
    }
    pthread_attr_destroy(&attr);

    for(j=0;j<SMP;j++) {
      pthread_join(thread_id[j], NULL);
    }

    free(input);
  #endif

  // Now sum it up!
  m1=0;
  m=data->jacobianIndex[date_market];
  for(i=0;i<groupsproduct;++i) {
    for(j=0;j<problem->allParams;++j) {
      output[m]=output2[m1];
      m++;m1++;
    }
    m+=data->index[date_market]+1;
  }
  for(d=1;d<problem->date;++d) {
    m=data->jacobianIndex[date_market];
    for(i=0;i<groupsproduct;++i) {
      for(j=0;j<problem->allParams;++j) {
        output[m]+=output2[m1];
        m++;m1++;
      }
      m+=data->index[date_market]+1;
    }
  }

  m=data->jacobianIndex[date_market];
  for(i=0;i<groupsproduct;++i) {
    for(j=0;j<problem->allParams;++j) {
      if(problem->subsampling) {
        output[m]/=problem->subsampling;
      } else {
        output[m]/=problem->date;
      }
      m++;
    }
    m+=data->index[date_market];

    output[m]=-1;
    m++;
  }

  offset=data->jacobianIndex[date_market]+(problem->allParams+data->index[date_market]+1)*groupsproduct;

  if(problem->doInstruments==1) {
    if(problem->ar) {
      for(j=0;j<problem->instruments;j++) {
        m=offset;
        for(i=0;i<data->index[date_market]+2;++i) {
          output[m]=0;
          m++;
        }
        c=0;
        ///// need a fix to correct for data - same in jacobian
        date=0;
        for(i=data->index[problem->market];i<data->index[date_market];i++) {
          if(problem->subsampling) {
            if(i>=data->index[problem->market*(date+1)]) {
              date++;
              if(!search(data->subsample,date)) {
                continue;
              }
            }
          }
          output[offset+i]+=data->instruments[j][i];
          if(lag[i]>-1) {
            output[offset+lag[i]]-=arg[rho]*data->instruments[j][i];
            output[offset+data->index[date_market]+1]-=arg[problem->allParams+lag[i]]*data->instruments[j][i];
          }
          c++;
        }
        output[offset+data->index[date_market]]=-c;

        offset+=data->index[date_market]+2;
      }
    } else { // Linear constraints
      for(j=0;j<problem->instruments;j++) {
        for(i=0;i<data->index[date_market];i++) {
          output[m]=data->instruments[j][i];
          m++;
        }

        output[m]=-1;
        m++;
      }
    }
  }

  free(output2);

  printf("done.\n");
}

void augmentedCovariance(F_TYPE *output, F_TYPE *output2, F_TYPE *arg) {
  int i,j,m,k;
  int threadsN = problem->market*problem->date+problem->demoGroups*problem->date;
  int date_market = problem->market*problem->date;
  F_TYPE **localOutput;
  int rho = problem->allParams+data->index[problem->date*problem->market]+problem->demoGroups*problem->product+instrumentsSave;


  localOutput = (F_TYPE **) malloc(problem->product*problem->demoGroups*sizeof(F_TYPE *));
  for(i=0;i<problem->product*problem->demoGroups;++i) {
    localOutput[i] = (F_TYPE *) malloc(problem->date*problem->P*sizeof(F_TYPE));
  }
  
  for(i=date_market;i<threadsN;++i) {
    covariance(localOutput, arg, problem, data, seed, date_market, i);
  }

  m=0;
  if(problem->ar) {
    for(j=0;j<instrumentsSave;j++) {
      for(k=0;k<instrumentsSave;k++) {
        output[m]=0;
        for(i=data->index[problem->market];i<data->index[date_market];i++) {
          if(lag[i]>-1) {
            output[m]+=(arg[i+problem->allParams]-arg[rho]*arg[lag[i]+problem->allParams])*
              (arg[i+problem->allParams]-arg[rho]*arg[lag[i]+problem->allParams])*
              data->instruments[j][i]*data->instruments[k][i];
          } else {
            output[m]+=(arg[i+problem->allParams])*
              (arg[i+problem->allParams])*
              data->instruments[j][i]*data->instruments[k][i];
          }
//          output[m]+=data->instruments[j][i]*data->instruments[k][i];
        }
        output[m]/=(data->index[date_market]-data->index[problem->market]);
        m++;
      }
    }
  } else {
    for(j=0;j<instrumentsSave;j++) {
      for(k=0;k<instrumentsSave;k++) {
        output[m]=0;
        for(i=0;i<data->index[date_market];i++) {
          output[m]+=arg[i+problem->allParams]*arg[i+problem->allParams]*data->instruments[j][i]*data->instruments[k][i];
        }
        output[m]/=data->index[date_market];
        m++;
      }
    }
  }

  m=0;
  for(j=0;j<problem->product*problem->demoGroups;j++) {
    for(k=0;k<problem->product*problem->demoGroups;k++) {
      output2[m]=0;
      for(i=0;i<problem->date*problem->P;i++) {
        output2[m]+=localOutput[j][i]*localOutput[k][i];
      }
      output2[m]/=problem->date*problem->P;
      m++;
    }
  }
  for(i=0;i<problem->product*problem->demoGroups;++i) {
    free(localOutput[i]);
  }
  free(localOutput);
}

void augmentedConstraint(F_TYPE *output, F_TYPE *arg) {
  int i,j,c,date;
  int date_market = problem->date*problem->market;
  int startSum = data->index[date_market];
  int step = problem->product*problem->demoGroups;
  int start = data->index[date_market]+step;
  int end = data->index[date_market]+problem->date*step;
  int nu1 = problem->allParams+data->index[date_market];
  int nu2 = nu1+step;
  int rho = nu2+instrumentsSave;
  F_TYPE *output2;

  #ifdef SMP
    ThreadStructureConstraint *input;
  #endif

  printf("Evaluating constraints...");

  // Allocate memory
  output2 = (F_TYPE *) malloc((data->index[date_market]+problem->demoGroups*problem->date*problem->product)*sizeof(F_TYPE));

  #ifndef SMP
    for(i=0;i<threadsN;++i) {
      constraint(output2, arg, problem, data, seed, date_market, i);
    }
  #else
    pthread_t thread_id[SMP];
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);
    input = (ThreadStructureConstraint *) malloc(SMP*sizeof(ThreadStructureConstraint));
    for(j=0;j<SMP;j++) {
      input[j].output=output2;
      input[j].arg=arg;
      input[j].problem=problem;
      input[j].data=data;
      input[j].seed=seed;
      input[j].cut=date_market;
      input[j].number=j;

      pthread_create(&thread_id[j], &attr, constraintThread, (void *) &input[j] );
    }
    pthread_attr_destroy(&attr);

    for(j=0;j<SMP;j++) {
      pthread_join(thread_id[j], NULL);
    }

    free(input);
  #endif

  for(i=0;i<start;i++) {
    output[i]=output2[i];
  }

  for(i=start;i<end;i+=step) {
    for(j=0;j<step;++j) {
      output[startSum+j]+=output2[i+j];
    }
  }

  for(j=0;j<step;++j) {
    if(problem->subsampling) {
      output[startSum+j]/=problem->subsampling;
    } else {
      output[startSum+j]/=problem->date;
    }
    output[startSum+j]-=data->demoFromData[j]+arg[nu1+j];
  }

  for(j=0;j<startSum;++j) {
    output[j]-=data->share[j];
  }

  if(problem->doInstruments==1) {
    // Linear constraints
    if(problem->ar) {
      for(j=0;j<problem->instruments;j++) {
        c=0;
        date=0;
        output[start+j]=0;
        for(i=data->index[problem->market];i<data->index[date_market];i++) {
          //printf("%d\n",i);
          if(problem->subsampling) {
            if(i>=data->index[problem->market*(date+1)]) {
              date++;

              if(!search(data->subsample,date)) {
                continue;
              } 
            }
          }
          output[start+j]+=arg[problem->allParams+i]*data->instruments[j][i];
          if(lag[i]>-1) {
            output[start+j]-=arg[rho]*arg[problem->allParams+lag[i]]*data->instruments[j][i];
          }
          c++;
        }
        output[start+j]-=c*arg[nu2+j];
      }
    } else {
      for(j=0;j<problem->instruments;j++) {
        output[start+j]=0;
        for(i=0;i<data->index[date_market];i++) {
          output[start+j]+=arg[problem->allParams+i]*data->instruments[j][i];
        }
        output[start+j]-=data->index[date_market]*arg[nu2+j];
      }
    }
  }

  free(output2);

  printf("done.\n");
}
  

void constraint(F_TYPE *output, F_TYPE *arg, BLPproblem *problem, BLPdata *data, seedStruct *seed, int cut, int idx) {
  F_TYPE denominator, re;
  F_TYPE nominator[100], delta[100];
  int drawsIndex=problem->N*idx;
  int format;
  int i,j,k,n,z;
  int covarMatrixOffset;
  int offsetDate, offsetOutput;
  int offsetSigma = problem->parameters+problem->product*problem->demoCharacteristics;
  int offsetXi = problem->allParams;
  F_TYPE vDraws[problem->random_effects];

  int group;
  int date;
  int market;
  if(idx<cut) { // Market shares
    for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
      output[j]=0;
      delta[n]=data->data[j][0]*arg[0]+data->data[j][1]*arg[1]+
        arg[2+(int) data->data[j][2]]+arg[offsetXi+j];
    }
    for(i=0;i<problem->N;++i) {
      vectorNormal(seed[idx], problem->random_effects, vDraws);

      denominator=1;

      for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
        re = arg[offsetSigma+problem->product]*vDraws[problem->product]*data->data[j][0];

        format=data->data[j][2];
	
	      covarMatrixOffset=problem->parameters+format*problem->demoCharacteristics;
/*        printf("%d\n",j);
        printf("re:%f\n",re);
        printf("delta:%f\n",delta[n]);
        printf("arg:%f\n",arg[offsetSigma+format]);
        printf("format:%d\n",format);
        printf("nd:%d\n",problem->random_effects);
        printf("draws:%f\n",vDraws[format]);
        getchar();
*/  
	      nominator[n]=re+delta[n]+arg[offsetSigma+format]*vDraws[format];
	
	      for(k=0;k<problem->demoCharacteristics;++k) {
	        nominator[n]+=arg[covarMatrixOffset+k]*data->demographics[i+drawsIndex][k];
	      }
	      nominator[n]=exp(nominator[n]);
	      denominator+=nominator[n];
      }
      for(j=data->index[idx],n=0;j<data->index[idx+1];++j,++n) {
        output[j]+=nominator[n]/denominator;
      }
    }
    for(j=data->index[idx];j<data->index[idx+1];++j) {
      output[j]/=problem->N;
    }
  } else {
    idx-=cut;
    date = idx/problem->demoGroups;
    offsetDate = date*problem->market;
    group = idx % problem->demoGroups;

    drawsIndex = idx*problem->P;
    offsetOutput = data->index[cut]+idx*problem->product;
    for(j=offsetOutput;j<offsetOutput+problem->product;++j) {
      output[j]=0;
    }
    if(problem->subsampling) {
      if(!search(data->subsample,date)) {
        return;
      }
    }

    for(z=drawsIndex,i=0;i<problem->P;++z,++i) {
      denominator = 1;
      market = data->demoGroups[z][0];
     
      vectorNormal(seed[idx+cut], problem->random_effects, vDraws);
//      for(k=0;k<problem->product;k++) {
//        vDraws[k]=1;
//        vDraws[k]=nextNormal(seed[idx+cut]);
//      }
      for(j=data->index[offsetDate+market],n=0;j<data->index[offsetDate+market+1];++j,++n) {
        re = arg[offsetSigma+problem->product]*vDraws[problem->product]*data->data[j][0];

	format=data->data[j][2];
	
	covarMatrixOffset=10+format*problem->demoCharacteristics;

	nominator[n]=re+data->data[j][0]*arg[0]+
	  data->data[j][1]*arg[1]+arg[2+format]+arg[offsetXi+j]+arg[offsetSigma+format]*vDraws[format];

	for(k=0;k<problem->demoCharacteristics;++k) {
	  nominator[n]+=arg[covarMatrixOffset+k]*data->demoGroups[z][k+1];
	}

	nominator[n]=exp(nominator[n]);
        denominator+=nominator[n];
      }

      for(j=data->index[offsetDate+market],n=0;j<data->index[offsetDate+market+1];++j,++n) {
        format=data->data[j][2];
        output[offsetOutput+format]+=nominator[n]/denominator;
      }
      for(j=data->index[offsetDate+market],n=0;j<data->index[offsetDate+market+1];++j,++n) {
        format=data->data[j][2];
      }
    }

    for(j=offsetOutput;j<offsetOutput+problem->product;++j) {
      output[j]/=problem->P;
    }
  }
}

void covariance(F_TYPE **output2, F_TYPE *arg, BLPproblem *problem, BLPdata *data, seedStruct *seed, int cut, int idx) {
  F_TYPE denominator,re;
  F_TYPE nominator[100];
  int drawsIndex=problem->N*idx;
  int format;
  int i,j,k,n,z;
  int covarMatrixOffset;
  int offsetDate, offsetOutput;
  int offsetSigma = problem->parameters+problem->product*problem->demoCharacteristics;
  int offsetXi = problem->allParams;
  F_TYPE vDraws[problem->random_effects];
  int offsetDraw;

  int group;
  int date;
  int market;
  {
    idx-=cut;
    date = idx/problem->demoGroups;
    offsetDate = date*problem->market;
    group = idx % problem->demoGroups;

    drawsIndex = idx*problem->P;
    offsetOutput = group*problem->product;

    for(z=drawsIndex,i=0;i<problem->P;++z,++i) {
      offsetDraw = date*problem->P+i;
      for(j=offsetOutput;j<offsetOutput+problem->product;++j) {
        output2[j][offsetDraw]=0;
      }
      denominator = 1;
      market = data->demoGroups[z][0];

      vectorNormal(seed[idx+cut], problem->random_effects, vDraws);
//      for(k=0;k<problem->product;k++) {
//        vDraws[k]=1;
//        vDraws[k]=nextNormal(seed[idx+cut]);
//      }
      for(j=data->index[offsetDate+market],n=0;j<data->index[offsetDate+market+1];++j,++n) {
        re = arg[offsetSigma+problem->product]*vDraws[problem->product]*data->data[j][0];

        format=data->data[j][2];

        covarMatrixOffset=10+format*problem->demoCharacteristics;

        nominator[n]=re+data->data[j][0]*arg[0]+
          data->data[j][1]*arg[1]+arg[2+format]+arg[offsetXi+j]+arg[offsetSigma+format]*vDraws[format];

        for(k=0;k<problem->demoCharacteristics;++k) {
          nominator[n]+=arg[covarMatrixOffset+k]*data->demoGroups[z][k+1];
        }

        nominator[n]=exp(nominator[n]);
        denominator+=nominator[n];
      }

      for(j=data->index[offsetDate+market],n=0;j<data->index[offsetDate+market+1];++j,++n) {
        format=data->data[j][2];
        output2[offsetOutput+format][offsetDraw]+=nominator[n]/denominator;
      }
    }
    for(z=drawsIndex,i=0;i<problem->P;++z,++i) {
      offsetDraw = date*problem->P+i;
      for(j=offsetOutput;j<offsetOutput+problem->product;++j) {
        output2[j][offsetDraw]-=data->demoFromData[j];
      }
    }
  }
}
