#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<math.h>
long MultModM(long s, long t, long M) {
   /* Returns (s*t) MOD M.  Assumes that -M < s < M and -M < t < M.    */
   /* See L'Ecuyer and Cote (1991).                                    */ 
  long R, S0, S1, q, qh, rh, k;

  if (s < 0)  s += M;
  if (t < 0)  t += M;
  if (s < H)  { S0 = s;  R = 0; }
  else {
    S1 = s/H;  S0 = s - H*S1;
    qh = M/H;  rh = M - H*qh;
    if (S1 >= H)  {
      S1 -= H;   k = t/qh;   R = H * (t - k*qh) - k*rh;
      while (R < 0)  R += M;
    } else R = 0;
    if (S1 != 0) {
      q = M/S1;   k = t/q;   R -= k * (M - S1*q);
      if (R > 0)  R -= M;
      R += S1*(t - k*q);
      while (R < 0)  R += M;
    }
    k = R/qh;   R = H * (R - k*qh) - k*rh;
    while (R < 0) R += M;
  }
  if (S0 != 0) {
    q = M/S0;   k = t/q;   R -= k* (M - S0*q);
    if (R > 0)  R -= M;
    R += S0 * (t - k*q);
    while (R < 0)  R += M;
  }
  return R;
}

void createGeneratorsSaved(int n, F_TYPE *init, seedStruct *g) {
  int i,j;

  j=0;
  for(i=0;i<n;i++) {
    g[i][0]=init[j];
    j++;

    g[i][1]=init[j];
    j++;

    g[i][2]=init[j];
    j++;

    g[i][3]=init[j];
    j++;
  }
}

void createGenerators(int n, long sd[4], seedStruct *g) {
  int i,j,r;
  int v=31,w=41;

  long aw[4], avw[4],      //   a[j]^{2^w} et a[j]^{2^{v+w}}
    a[4] = { 45991, 207707, 138556, 49689 },
    m[4] = { 2147483647, 2147483543, 2147483423, 2147483323 };


  for (j = 0; j < 4; j++) {
    aw[j] = a[j];
    for (i = 1; i <= w; i++)
      aw[j]  = MultModM (aw[j], aw[j], m[j]);
    avw[j] = aw[j];
    for (i = 1; i <= v; i++)
      avw[j] = MultModM (avw[j], avw[j], m[j]);
  }

  for (j = 0; j < 4; j++)  g[0][j] = sd[j];
  for (r = 1; r < n; r++) {
    for (j = 0; j < 4; j++)
      g[r][j] = MultModM (avw[j], g[r-1][j], m[j]);
  }
}

void createGeneratorsDefault(int n, seedStruct *g) {
  long sd[4] = {11111111, 22222222, 33333333, 44444444};

  createGenerators(n, sd, g);
}

F_TYPE nextUniform(long *g) {
  long k,s;
  F_TYPE u;
  u = 0.0;

  s = g[0];  k = s / 46693;
  s = 45991 * (s - k * 46693) - k * 25884;
  if (s < 0) s = s + 2147483647;  g[0] = s;
  u = u + 4.65661287524579692e-10 * s;
 
  s = g[1];  k = s / 10339;
  s = 207707 * (s - k * 10339) - k * 870;
  if (s < 0) s = s + 2147483543;  g[1] = s;
  u = u - 4.65661310075985993e-10 * s;
  if (u < 0) u = u + 1.0;

  s = g[2];  k = s / 15499;
  s = 138556 * (s - k * 15499) - k * 3979;
  if (s < 0) s = s + 2147483423;  g[2] = s;
  u = u + 4.65661336096842131e-10 * s;
  if (u >= 1.0) u = u - 1.0;

  s = g[3];  k = s / 43218;
  s = 49689 * (s - k * 43218) - k * 24121;
  if (s < 0) s = s + 2147483323;  g[3] = s;
  u = u - 4.65661357780891134e-10 * s;
  if (u < 0) u = u + 1.0;

  return (u);
}

F_TYPE nextNormal(long *g) {
/*  double u,v;
  if(!initialized) {
    initialized=1;

    u=sqrt(-2*log(nextUniform(g)));
    v=2*PI*nextUniform(g);
    
    second = u*cos(v);
    return u*sin(v);
  } else {
    initialized=0;
    return second;
  }*/
  return sqrt(-2*log(nextUniform(g)))*sin(2*PI*nextUniform(g));
}

void vectorNormal(long *g, int n, F_TYPE *output) {
  int i;
  double u,v;
  if(n % 2 == 0) {
    for(i=0;i<n;i+=2) {
      u=sqrt(-2*log(nextUniform(g)));
      v=2*PI*nextUniform(g);

      output[i]=u*cos(v);
      output[i+1]=u*sin(v);
    } 
  } else {
    for(i=0;i<n-1;i+=2) {
      u=sqrt(-2*log(nextUniform(g)));
      v=2*PI*nextUniform(g);

      output[i]=u*cos(v);
      output[i+1]=u*sin(v);
    }
    output[n-1]=sqrt(-2*log(nextUniform(g)))*sin(2*PI*nextUniform(g));
  }
}

void vectorNormalVar(long *g, int n, F_TYPE *output, F_TYPE var) {
  int i;
  double u,v;
  if(n % 2 == 0) {
    for(i=0;i<n;i+=2) {
      u=sqrt(-2*log(nextUniform(g)));
      v=2*PI*nextUniform(g);

      output[i]=var*u*cos(v);
      output[i+1]=var*u*sin(v);
    }
  } else {
    for(i=0;i<n-1;i+=2) {
      u=sqrt(-2*log(nextUniform(g)));
      v=2*PI*nextUniform(g);

      output[i]=var*u*cos(v);
      output[i+1]=var*u*sin(v);
    }
    output[n-1]=var*sqrt(-2*log(nextUniform(g)))*sin(2*PI*nextUniform(g));
  }
}
