#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <blp.h>
#include <tripletToCompressed.h>

#include <mex.h>

void mexFunction(int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[]) { 
  int i,m,j,height,length,n;
  int date_market, data_size;
  F_TYPE *arg;
  int argSize;
  double *target;


  height = data->index[problem->market*problem->date]+problem->demoGroups*problem->product+problem->instruments;

  if(problem->doInstruments==1) {
    length = problem->allParams+height;
    if(problem->ar) {
      length++;
    }
  } else {
    length = problem->allParams+height+instrumentsSave;
  }

  plhs[0]=mxCreateDoubleMatrix(1, 1, mxREAL);
  plhs[1]=mxCreateDoubleMatrix((date_market+1), 1, mxREAL);

  jacobianIndexInit = mxGetPr(plhs[1]);  
  sizeInit = mxGetPr(plhs[0]);
  data->jacobianIndex = (int *) malloc((date_market+1)*sizeof(int));
  *sizeInit = getSparseSize(problem, data);
  size = *sizeInit;
  for(i=0;i<=date_market;++i) {
    jacobianIndexInit[i] = data->jacobianIndex[i];
  }
  free(data->jacobianIndex);

  Rows = (int *) malloc(size*sizeof(int));
  Columns = (int *) malloc(size*sizeof(int));
  plhs[2]=mxCreateDoubleMatrix(size, 1, mxREAL);
  plhs[3]=mxCreateDoubleMatrix(length+1, 1, mxREAL);
  plhs[4]=mxCreateDoubleMatrix(size, 1, mxREAL);
  Rows_matlab = mxGetPr(plhs[2]);
  Columns_matlab = mxGetPr(plhs[3]);
  Transpose_matlab = mxGetPr(plhs[4]);

  createSparseIndex(problem, data);
  tripletToCompressed(size, height, length, Rows, Columns, Rows_matlab, Columns_matlab, Transpose_matlab);

  /* Load indexes */

  n = height;
  m = length;
  plhs[5] = mxCreateSparse(n,m,size,mxREAL);

  Jc = (mwIndex *) mxMalloc((m+1)*sizeof(mwIndex));
  Ir = (mwIndex *) mxMalloc(size*sizeof(mwIndex));
  target = (double *) mxMalloc(size*sizeof(double));

  mxSetIr(plhs[5], Ir);
  mxSetJc(plhs[5], Jc);
  mxSetPr(plhs[5], target);
  for(i=0;i<=m;i++) {
    Jc[i]=Columns_matlab[i];
  }
  for(i=0;i<size;i++) {
    Ir[i]=Rows_matlab[i];
    target[i]=1;
  }

  free(Rows);
  free(Columns);

  /* Load data to the device */
  
  /* Run optimization */

  /* Free memory */
  free(data->index);

  for(i=0;i<data_size;++i) {
    free(data->data[i]);
  }
  free(data->data);

  if(problem->doInstruments==1) {
    for(i=0;i<problem->instruments;++i) {
      free(data->instruments[i]);
    }
    free(data->instruments);
  }

  for(i=0;i<date_market*problem->N;++i) {
    free(data->demographics[i]);
  }
  free(data->demographics);

  for(i=0;i<problem->date*problem->demoGroups*problem->P;++i) {
    free(data->demoGroups[i]);
  }
  free(data->demoGroups);

  free(data->share);
  free(data->demoFromData);

  free(problem);
  free(data);
}
