#ifndef SETUP_H__
#define SETUP_H__

typedef double F_TYPE;

#define MAX_DATES 21

#define SMP 42

int reInit;

#ifdef ADVDEM
typedef struct {
  double gamma[2];
  int *structure;
  int number_of_owners;
  int idx;
  double *arg;
  double *q;
  double *epsilon;
  double *P;
} advDemStructure;
#endif

typedef struct {
  short market;
  short date;
  short product;
  short demoCharacteristics; /* Number of demographic characteristics */
  short demoGroups; /* Number of demographic groups (for demographic moments) */
  short parameters;
  short P;  /* Number of people in demographic moment */
  short Pn; /* Number of draws per person */
  short N;  /* Number of draws when simulating market share */
  short doInstruments;
  short ar;

  short R; /* number of simulation in the simulation routine */

  short bs;

  short instruments;

  short dataLineSize;
  short demoLineSize;
  short groupsLineSize;

  int allParams;

  int mysize;

  int subsampling;

  int random_effects;

  int power;
  int year_dummies;
  int number_of_year_dummies;
} BLPproblem;

typedef struct {
  int *index; /* Indexes of market/dates in data array */
  int *jacobianIndex;

  int *subsample;

  F_TYPE **data; /* Main product data */
                 /* (date x market x dataLine x data)*/
  F_TYPE **demographics; /* Demographic draws for each market/date*/
                          /* (date x market x draw x charateristics) */
  F_TYPE **demoGroups; /* Demographics draws for each group and date */
                        /* (date x group x person x characteristics) */
  F_TYPE *arg0;
  F_TYPE **instruments;
  F_TYPE *share;
  F_TYPE *demoFromData;

  double *bsDraws; /* Bootstrap draws from zeta */
} BLPdata;

#endif
