#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <blp.h>
#include <tripletToCompressed.h>

#include <mex.h>

static BLPproblem *problemMex;

void mexFunction(int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[]) { 
  int m,i;
  F_TYPE *output, *mySeedInit;

  problemMex = (BLPproblem *) mxMalloc(sizeof(BLPproblem));

  problemMex->market=(int) mxGetPr(mxGetField(prhs[0], 0, "market"))[0];
  problemMex->date=(int) mxGetPr(mxGetField(prhs[0], 0, "date"))[0];
  problemMex->demoGroups=(int) mxGetPr(mxGetField(prhs[0], 0, "demoGroups"))[0];
  problemMex->R=(int) mxGetPr(mxGetField(prhs[0], 0, "R"))[0];

  problem=problemMex;

  threadsN = problem->market*problem->date+problem->demoGroups*problem->date;

  plhs[0]=mxCreateDoubleMatrix(threadsN*4, problem->R, mxREAL);
  output=mxGetPr(plhs[0]);

  mySeedInit = mxGetPr(prhs[1]);

  mySeed = (long *) mxMalloc(4*sizeof(long));
  mySeed[0] = (long) mySeedInit[0];
  mySeed[1] = (long) mySeedInit[1];
  mySeed[2] = (long) mySeedInit[2];
  mySeed[3] = (long) mySeedInit[3];

  seed = (seedStruct *) mxMalloc(threadsN*problem->R*sizeof(seedStruct));

  createGenerators(threadsN*problem->R, mySeed, seed);

  m=0;
  for(i=0;i<threadsN*problem->R;i++) {
    output[m]=seed[i][0];
    m++;
    output[m]=seed[i][1];
    m++;
    output[m]=seed[i][2];
    m++;
    output[m]=seed[i][3];
    m++;
  }
}
