#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <blp.h>
#include <globals.h>
#include "mat.h"
#include <mex.h>

static int initialized = 0;
static BLPproblem *problemMex;
static BLPdata *dataMex;

#include<loadDataBin.c>

int main(int argc, char *argv[]) {
  int i,m,j;
  F_TYPE *arg;
  F_TYPE *output;
  int date_market, data_size;
  double *mySeedInit;
  mxArray *mxOut;

  loadData(argc, argv);

  if(argc<3) {
    printf("The executable needs two arguments: output and input .mat file names\n");
    exit(1);
  }

  char filename[NAME_LENGTH];
  MATFile *mfp;

  strncpy(filename, argv[1], NAME_LENGTH);

  if ((mfp = matOpen(filename, "r")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }

  problem=problemMex;
  data=dataMex;

  date_market=problem->market*problem->date;
  data_size = data->index[date_market];
  threadsN = problem->market*problem->date;

  /* Initialize random number generator */
  mySeedInit = mxGetPr(readvar(mfp,"mySeed"));
  if(problem->bs) {
    seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));

    createGeneratorsSaved(threadsN, mySeedInit, seed);
  } else {
    mySeed = (long *) mxMalloc(4*sizeof(long));
    mySeed[0] = (long) mySeedInit[0];
    mySeed[1] = (long) mySeedInit[1];
    mySeed[2] = (long) mySeedInit[2];
    mySeed[3] = (long) mySeedInit[3];

    seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));

    createGenerators(threadsN, mySeed, seed);
  }
 
  /* Load the starting point */
  arg = mxGetPr(readvar(mfp,"arg"));

  /* Load data to the device */
  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE);
  } 
  /* Run optimization */
  mxOut=mxCreateDoubleMatrix(data->index[problem->market*problem->date]+problem->demoGroups*problem->product+problem->instruments, 1, mxREAL);
  output = mxGetPr(mxOut);
  augmentedConstraint(output, arg);
 
  strncpy(filename, argv[2], NAME_LENGTH); 
  if ((mfp = matOpen(filename, "w")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }

  matPutVariable(mfp, "output", mxOut);

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE);
  }
}
