#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <blp.h>
#include <mex.h>

static int initialized = 0;
static BLPproblem *problemMex;
static BLPdata *dataMex;

#include<loadDataBin.c>

int main(int argc, char *argv[]) {
  int i,m,j;
  int date_market, data_size;
  double *mySeedInit;
  F_TYPE *arg;
  mxArray *output, *output2, *output3;
  F_TYPE *outputPr, *output2Pr, *output3Pr;

  loadData(argc,argv);

  if(argc<3) {
    printf("The executable needs two arguments: output and input .mat file names\n");
    exit(1);
  }

  char filename[NAME_LENGTH];
  MATFile *mfp;

  strncpy(filename, argv[1], NAME_LENGTH);

  if ((mfp = matOpen(filename, "r")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }

  problem=problemMex;
  data=dataMex;

  date_market=problem->market*problem->date;
  data_size = data->index[date_market];
  threadsN = problem->market*problem->date;

  /* Initialize random number generator */
  mySeedInit = mxGetPr(readvar(mfp,"mySeed"));
  if(problem->bs) {
    seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));

    createGeneratorsSaved(threadsN, mySeedInit, seed);
  } else {
    mySeed = (long *) mxMalloc(4*sizeof(long));
    mySeed[0] = (long) mySeedInit[0];
    mySeed[1] = (long) mySeedInit[1];
    mySeed[2] = (long) mySeedInit[2];
    mySeed[3] = (long) mySeedInit[3];

    seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));

    createGenerators(threadsN, mySeed, seed);
  }

  /* Load the starting point */
  arg = mxGetPr(readvar(mfp,"arg"));

  /* Run optimization */
  output=mxCreateDoubleMatrix(instrumentsSave, instrumentsSave, mxREAL);
  outputPr = mxGetPr(output);
  output2=mxCreateDoubleMatrix(problem->demoGroups*problem->product, instrumentsSave, mxREAL);
  output2Pr = mxGetPr(output2);
  output3=mxCreateDoubleMatrix(problem->demoGroups*problem->product, 
      problem->demoGroups*problem->product, mxREAL);
  output3Pr = mxGetPr(output3);
  augmentedCovariance(arg, outputPr, output2Pr, output3Pr);
  printf("done\n");

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE);
  }

  strncpy(filename, argv[2], NAME_LENGTH);

  if ((mfp = matOpen(filename, "w")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }
  matPutVariable(mfp, "A", output);
  matPutVariable(mfp, "B", output2);
  matPutVariable(mfp, "C", output3);
  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE);
  }
}
