#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<setup.h>
#include<math.h>

#include <mex.h>

void mexFunction(int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[]) { 
  int i,j,d,z,m,offset;
  double *demPool, *output;
  long seed[4];
  BLPproblem *problem;
  int demPoolSize;
  double *dates;
  int market;
  int datesN;

  /* long r0,r1,r2;
   struct tms t,u,r; */

  problem = (BLPproblem *) mxMalloc(sizeof(BLPproblem));

  /* Initialize problem structure */

  demPool = mxGetPr(mxGetField(prhs[1], 0, "demPool"));
  seed[0] = (long) mxGetPr(prhs[2])[0];
  seed[1] = (long) mxGetPr(prhs[2])[1];
  seed[2] = (long) mxGetPr(prhs[2])[2];
  seed[3] = (long) mxGetPr(prhs[2])[3];
  problem->N=(int) mxGetPr(mxGetField(prhs[0], 0, "N"))[0];
  problem->date=(int) mxGetPr(mxGetField(prhs[0], 0, "date"))[0];
  problem->market=(int) mxGetPr(mxGetField(prhs[0], 0, "market"))[0];
  demPoolSize = (int) mxGetPr(mxGetField(prhs[0], 0, "demPoolSize"))[0];

  problem->demoLineSize=(int) mxGetPr(mxGetField(prhs[0], 0, "demoLineSize"))[0];;

  plhs[0]=mxCreateDoubleMatrix(problem->demoLineSize, problem->market*problem->date*problem->N, mxREAL);
  output = mxGetPr(plhs[0]);

  m=0;
  for(d=0;d<problem->market*problem->date;++d) {
    offset = d*demPoolSize*problem->demoLineSize;
    for(i=0;i<problem->N;++i) {
      z = (int) (demPoolSize*nextUniform(seed));
      z = z*problem->demoLineSize+offset;
      for(j=0;j<problem->demoLineSize;++j) {
        output[m]=demPool[z+j];
        m++;
      }
    }
  }
}
